<?php
header('Content-Type: application/json; charset=utf-8');
require_once('../includes/Developers.php');

$response = [];

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Validate required parameter
    if (!empty($_GET['user_id'])) {
        $userId = $_GET['user_id'];
        $status = 1;

        // Initialize database operations
        $db = new Developers();
        $accDetails = $db->getMyAccName($userId, $status);

        // Build response based on query result
        $response['error'] = false;
        $response['max_acc'] = $accDetails ? $accDetails : "Event(Default)";
    } else {
        // Missing parameter
        $response['error'] = true;
        $response['message'] = 'Required parameters are missing';
    }
} else {
    // Invalid request method
    $response['error'] = true;
    $response['message'] = 'Invalid request';
}

// Return JSON response
echo json_encode($response);
?>
