<?php
class DbConnect
{
    // Shared connection instance (Singleton)
    private static $conn = null;

    public function __construct()
    {
        // Leave empty – we don't create DB connections in the constructor
    }

    public function connect()
    {
        // Return existing connection if already open
        if (self::$conn !== null) {
            return self::$conn;
        }

        include_once dirname(__FILE__) . '/Constants.php';

        /*  
            Use persistent connection:
            - Faster
            - Prevents too many connection openings
            - Reuses existing MySQL links
        */

        self::$conn = new mysqli('p:' . DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

        if (self::$conn->connect_errno) {
            error_log("DB Connection Failed: " . self::$conn->connect_error);
            return null; // avoid fatal errors
        }

        // Optional: set UTF-8
        self::$conn->set_charset("utf8mb4");

        return self::$conn;
    }

    public function __destruct()
    {
        // Close the connection properly (optional with persistent, but good practice)
        if (self::$conn !== null) {
            self::$conn->close();
            self::$conn = null;
        }
    }
}
?>
