<?php
     session_start();
     class Developers
        {
            private $con;

            function __construct(){
                require_once dirname(__FILE__).'/DbConnect.php';
                $db = new DbConnect();

                $this->con = $db->connect();
            }
            
            /* CRUD -> c -> Create */
            
                public function getCountry(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_countries`");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getProvince(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_province`");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public  function getPinCodeNumber($lenght,$lower=false,$upper=true,$number=true){
                    $pool="";
                    $var_pincode_data="";
                    if ($lower == true) {
                      $pool .="azertyuiopqsdfghjklmwxcvbn";
                    } if($upper == true){
                      $pool .="AZERTYUIOPQSDFGHJKLMWXCVBN";
                    }if($number == true){
                      $pool .="0123456789";
                    }
                    $cc = 0;
                    while ($cc < $lenght) {
                      $var_pincode_data .=$pool[rand(0,strlen($pool)-1)];
                      $cc++;
                    }
                    return $var_pincode_data; 
             }
             
             public  function getSerialCodeNo($lenght,$lower=false,$upper=true,$number=true){
                    $pool="";
                    $var_pincode_data="";
                    if ($lower == true) {
                      $pool .="azertyuiopqsdfghjklmwxcvbn";
                    } if($upper == true){
                      $pool .="AZERTYUIOPQSDFGHJKLMWXCVBN";
                    }if($number == true){
                      $pool .="0123456789";
                    }
                    $cc = 0;
                    while ($cc < $lenght) {
                      $var_pincode_data .=$pool[rand(0,strlen($pool)-1)];
                      $cc++;
                    }
                    return $var_pincode_data; 
             }
             
            public  function getNumberLevPinNo($lenght,$lower=false,$upper=true,$number=true){
                    $pool="";
                    $var_pincode_data="";
                    if ($lower == true) {
                      $pool .="azertyuiopqsdfghjklmwxcvbn";
                    } if($upper == true){
                      $pool .="AZERTYUIOPQSDFGHJKLMWXCVBN";
                    }if($number == true){
                      $pool .="0123456789";
                    }
                    $cc = 0;
                    while ($cc < $lenght) {
                      $var_pincode_data .=$pool[rand(0,strlen($pool)-1)];
                      $cc++;
                    }
                    return $var_pincode_data; 
             }
             
           public function getMixedRandomId($lenght,$lower=false,$upper=true,$number=true){
                    $pool="";
                    $var_pincode_data="";
                    if ($lower == true) {
                      $pool .="azertyuiopqsdfghjklmwxcvbn";
                    } if($upper == true){
                      $pool .="AZERTYUIOPQSDFGHJKLMWXCVBN";
                    }if($number == true){
                      $pool .="0123456789";
                    }
                    $cc = 0;
                    while ($cc < $lenght) {
                      $var_pincode_data .=$pool[rand(0,strlen($pool)-1)];
                      $cc++;
                    }
                    return $var_pincode_data; 
             }
             
             public function getPaysName($user_country){
                  $stmt = $this->con->prepare("SELECT country_code AS code_uid FROM `agc_countries` WHERE `id` = ?");
                     $stmt->bind_param("s",$user_country);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['code_uid'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
              public function getRightPassWord($var_pssd,$var_pssd_rep){
                 if($var_pssd == $var_pssd_rep){
                        return 3;
                    }else{
                        return 4;
                    }
            }
            
            public function getNewAccount($var_fullname,$var_username,$var_pssd,$var_contact,$var_residence,$var_province,$var_country,$user_country,$var_smsInfo,$var_pincode,$Community,$customers,$var_date,$var_time,$validation,$varIndex){
                if ($this->isAccExist($var_contact)) {
                        return 0;
                } else { 
                    if ($this->isUsernameExist($var_username)) {
                        return 3;
                } else {
                     if ($this->isPasswordExist($var_pssd)) {
                        return 4;
                    } else {
                    
                            $pass = md5($var_pssd);
                             $stmt = $this->con->prepare("INSERT INTO `code_users`(`fullname`, `username`, `contact`, `residence`, `province`, `country`,`countryId`, `smsInfo`, `password`,`pass_eye`, `user_id`, `agence`, `category`, `date`, `time`, `validation`, `createdBy`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                            $stmt->bind_param("sssssssssssssssss", $var_fullname,$var_username,$var_contact,$var_residence,$var_province,$var_country,$user_country,$var_smsInfo,$pass,$var_pssd,$var_pincode,$Community,$customers,$var_date,$var_time,$validation,$varIndex);
                            if ($stmt->execute()) {
                                return 1;
                            } else {
                                return 2;
                            }
                        }
                    } 
                }
            }
            
            private function isPasswordExist($var_pssd){
                $stmt = $this->con->prepare("SELECT id FROM `code_users` WHERE `pass_eye`=?");
                $stmt->bind_param("s", $var_pssd);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
             private function isUsernameExist($var_username){
                $stmt = $this->con->prepare("SELECT id FROM `code_users` WHERE `username`=?");
                $stmt->bind_param("s", $var_username);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            private function isAccExist($var_contact){
                $stmt = $this->con->prepare("SELECT id FROM `code_users` WHERE `contact`=?");
                $stmt->bind_param("s", $var_contact);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            public function getAccountCred($var_fullname,$var_username,$var_pssd,$var_date,$var_time){
                 $stmt = $this->con->prepare("INSERT INTO `agc_account`(`fullname`, `username`, `password`, `date`, `time`) VALUES (?,?,?,?,?)");
                    $stmt->bind_param("sssss", $var_fullname,$var_username,$var_pssd,$var_date,$var_time);
                    if ($stmt->execute()) {
                        return 1;
                    } else {
                        return 2;
                    }
            }
            
            public function getMembersNo(){
                $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_members FROM `code_users`");
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_members'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getUserSignIn($agico_uid,$agico_pssd){
                $pass = md5($agico_pssd);
                $stmt = $this->con->prepare("SELECT id FROM `code_users` WHERE `username`=? AND `password`=?");
                $stmt->bind_param("ss",$agico_uid,$pass);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
            
            public function getUserByUID($agico_uid){
                $stmt = $this->con->prepare("SELECT *  FROM `code_users` WHERE `username`=?");
                $stmt->bind_param("s",$agico_uid);
                $stmt->execute();
                return $stmt->get_result()->fetch_assoc();
            }
            
            public function setUserDetails($response) {
            if (!is_array($response)) {
                return;
            }
            $fields = array(
                'Id',  'img', 'fullname',  'username', 'contact',  'residence', 'province', 'country','countryId',  'smsInfo'
                ,  'user_id',  'agence',   'category',   'typeaccount',  'date',  'time', 'validation', 'createdBy'
            );
        
            $userDetails = array('last_login' => time());
        
            foreach ($fields as $field) {
                $userDetails[$field] = isset($response[$field]) ? $response[$field] : null;
            }
        
            $_SESSION['user_details'] = $userDetails;
            }
        
            public function AgicoUserDetails() {
                return isset($_SESSION['user_details']) ? $_SESSION['user_details'] : null;
                
            }
            
            public function isLoggedIn() {
                return isset($_SESSION['user_details']);
                
            }
            
            public function logoutUser() {
                    session_unset();
                    session_destroy();
            }
            
            public function AgicoSaveToken($agicoUId,$varPINVar,$var_codeId,$var_date,$var_time){
               $stmt = $this->con->prepare("INSERT INTO `agc_log_token`(`user_id`, `token`, `user_codeId`, `date`, `time`) VALUES (?,?,?,?,?)");
                $stmt->bind_param("sssss", $agicoUId,$varPINVar,$var_codeId,$var_date,$var_time);
                if ($stmt->execute()) {
                    return 1;
                } else {
                    return 2;
                }
            }
            
            public function getAccountUidv1($account_uidId){
              $stmt = $this->con->prepare("SELECT *  FROM `code_users` WHERE `id`=?");
              $stmt->bind_param("s",$account_uidId);
              $stmt->execute();
              return $stmt->get_result()->fetch_assoc();
            }
            
            public function getStoreUidv2($post_Id){
               $stmt = $this->con->prepare("SELECT *  FROM `agc_social` WHERE `id`=?");
              $stmt->bind_param("s",$post_Id);
              $stmt->execute();
             return $stmt->get_result()->fetch_assoc();     
            }
           
            public function getReaction($myAccImg,$eventIdv1,$eventReactionLike,$PostOwnerId,$myFullName,$myAccId,$var_pays,$var_date,$var_time) {
                if (!$this->isLikeReacted($myAccId,$eventIdv1)) {  
                    $stmt = $this->con->prepare("INSERT INTO `agc_social_reaction`(`urlImg_profile`, `post_id`, `post_like`, `owner_id`, `reactuid_name`, `reactuid_id`, `event_pays`, `action_date`, `action_temps`) VALUES (?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssss", $myAccImg,$eventIdv1,$eventReactionLike,$PostOwnerId,$myFullName,$myAccId,$var_pays,$var_date,$var_time);
                    if ($stmt->execute()) {
                        return 1;  
                    } else {
                        return 2;  
                    }
                } else {
                    return 0;  
                }
            }
            
            private function isLikeReacted($myAccId,$eventIdv1){
                $stmt = $this->con->prepare("SELECT `id` FROM `agc_social_reaction` WHERE `reactuid_id`=? AND `post_id`=?");
                $stmt->bind_param("ss", $myAccId,$eventIdv1);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            public function getAdsLikeAdded($eventLike,$eventIdv1){
                 $stmt = $this->con->prepare("UPDATE `agc_ads` SET `like_event`=? WHERE `post_id`=?");
                $stmt->bind_param("ss", $eventLike,$eventIdv1);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getLikeAdded($eventLike,$eventIdv1){
                 $stmt = $this->con->prepare("UPDATE `agc_social` SET `event_like`=? WHERE `id`=?");
                $stmt->bind_param("ss", $eventLike,$eventIdv1);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getLoveReaction($myAccImg,$eventIdv1,$eventReactionLove,$PostOwnerId,$myFullName,$myAccId,$var_pays,$var_date,$var_time) {
                if (!$this->isLoveReacted($myAccId,$eventIdv1)) {  
                    $stmt = $this->con->prepare("INSERT INTO `agc_social_reaction`(`urlImg_profile`, `post_id`, `post_love`, `owner_id`, `reactuid_name`, `reactuid_id`, `event_pays`, `action_date`, `action_temps`) VALUES (?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssss", $myAccImg,$eventIdv1,$eventReactionLove,$PostOwnerId,$myFullName,$myAccId,$var_pays,$var_date,$var_time);
                    if ($stmt->execute()) {
                        return 1;  
                    } else {
                        return 2;  
                    }
                } else {
                    return 0;  
                }
            }
            
            private function isLoveReacted($myAccId,$eventIdv1){
                $stmt = $this->con->prepare("SELECT `id` FROM `agc_social_reaction` WHERE `reactuid_id`=? AND `post_id`=?");
                $stmt->bind_param("ss", $myAccId,$eventIdv1);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            } 
            
            public function getAdsLoveAdded($eventLove,$eventIdv1){
                 $stmt = $this->con->prepare("UPDATE `agc_ads` SET `love_event`=? WHERE `post_id`=?");
                $stmt->bind_param("ss", $eventLove,$eventIdv1);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getLoveAdded($eventLove,$eventIdv1){
                 $stmt = $this->con->prepare("UPDATE `agc_social` SET `event_love`=? WHERE `id`=?");
                $stmt->bind_param("ss", $eventLove,$eventIdv1);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getDisLikeReaction($myAccImg,$eventIdv1,$eventReactionDisLike,$PostOwnerId,$myFullName,$myAccId,$var_pays,$var_date,$var_time){
              if (!$this->isDisLikeReacted($myAccId,$eventIdv1)) {  
                    $stmt = $this->con->prepare("INSERT INTO `agc_social_reaction`(`urlImg_profile`, `post_id`, `post_dislike`, `owner_id`, `reactuid_name`, `reactuid_id`, `event_pays`, `action_date`, `action_temps`) VALUES (?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssss", $myAccImg,$eventIdv1,$eventReactionDisLike,$PostOwnerId,$myFullName,$myAccId,$var_pays,$var_date,$var_time);
                    if ($stmt->execute()) {
                        return 1;  
                    } else {
                        return 2;  
                    }
                } else {
                    return 0;  
                }
            }
            
            private function isDisLikeReacted($myAccId,$eventIdv1){
                $stmt = $this->con->prepare("SELECT `id` FROM `agc_social_reaction` WHERE `reactuid_id`=? AND `post_id`=?");
                $stmt->bind_param("ss", $myAccId,$eventIdv1);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            public function getAdsDisLikeAdded($eventDisLike,$eventIdv1){
                 $stmt = $this->con->prepare("UPDATE `agc_ads` SET `dislike_event`=? WHERE `post_id`=?");
                $stmt->bind_param("ss", $eventDisLike,$eventIdv1);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getDisLikeAdded($eventDisLike,$eventIdv1){
              $stmt = $this->con->prepare("UPDATE `agc_social` SET `event_dislike`=? WHERE `id`=?");
                $stmt->bind_param("ss", $eventDisLike,$eventIdv1);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getUIDName($var_userId){
                $stmt = $this->con->prepare("SELECT `fullname` AS max_name FROM `code_users` WHERE `id`=?");
                $stmt->bind_param("s",$var_userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['max_name'];
                } else {
                    $giss_getVar = "Pas de données disponibles";
                    return $giss_getVar;
                }
            }
            
            public function getUIDImage($var_userId){
                $stmt = $this->con->prepare("SELECT `img` AS max_image FROM `code_users` WHERE `id`=?");
                $stmt->bind_param("s",$var_userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['max_image'];
                } else {
                    $giss_getVar = "Pas de données disponibles";
                    return $giss_getVar;
                }
            }
            
            public function getPaysNamev1($var_userId){
                  $stmt = $this->con->prepare("SELECT country AS code_uid FROM `code_users` WHERE `id` = ?");
                     $stmt->bind_param("s",$var_userId);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['code_uid'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
            }
         
            public function getPublish($user_img,$user_details, $user_paysname, $var_content, $eventImage, $like, $love, $dislike, $var_date, $var_time, $var_userId,$ImagePath,$ImageData){
                    $stmt = $this->con->prepare("INSERT INTO `agc_social`(`urlImg_profile`, `event_name`, `event_country`, `event_content`, `event_image`, `event_like`, `event_love`, `event_dislike`, `event_date`, `event_time`, `event_uid`) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssssss", $user_img, $user_details, $user_paysname, $var_content, $eventImage, $like, $love, $dislike, $var_date, $var_time, $var_userId);
                    if ($stmt->execute()) {
                      file_put_contents($ImagePath,base64_decode($ImageData));
                        return 1;
                    } else {
                        return 2;
               }
            }
            
            public function getSocial(){
                $stmt = $this->con->prepare("SELECT * FROM `agc_social` ORDER BY `id` DESC");
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
            public function getWallet($userId){
                $stat = 1;
                 $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_income FROM `agc_recette` WHERE `Agence`=? AND `status`=? AND YEAR(date) = YEAR(CURDATE())");
                 $stmt->bind_param("ss",$userId,$stat);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_income'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getMyNumPol($userId,$var_state){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_police FROM `agc_chargement` WHERE `Status`=? AND `Agence`=?");
                  $stmt->bind_param("ss",$var_state,$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_police'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getCertificate($userId,$var_state){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_certificate FROM `agc_certificat` WHERE `Status`=? AND `Agence`=?");
                   $stmt->bind_param("ss",$var_state,$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_certificate'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getNote($userId,$var_state){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_prime FROM `agc_notprime` WHERE `Status`=? AND `Agence`=?");
                  $stmt->bind_param("ss",$var_state,$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_prime'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getCustNo(){
                 $stmt = $this->con->prepare("SELECT COUNT(`id`) AS total_clients FROM `agc_preneur`");
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_clients'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getCusts(){
                $stmt = $this->con->prepare("SELECT * FROM `agc_preneur` ORDER BY `Id` DESC");
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
               public function AccGetDetailsLogValues($eventWorkId,$event_uid_2){
                  $stmt = $this->con->prepare("SELECT *  FROM `code_users` WHERE `username` =? AND `Id`=?");
                  $stmt->bind_param("ss",$event_uid_2,$eventWorkId);
                  $stmt->execute();
                 return $stmt->get_result()->fetch_assoc();
                }
            
            public function getUidSignIn($var_pincode,$event_uid_1,$event_uid_2){
                $var_pincodev1 = '%' . $var_pincode;
                $stmt = $this->con->prepare("SELECT id FROM `code_users` WHERE `username` =? AND `contact` LIKE ? AND `Id` = ?");
                $stmt->bind_param("sss",$event_uid_2,$var_pincodev1,$event_uid_1);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }

            public function getUidByUID($var_pincode,$event_uid_2){
                $var_pincodev1 = '%' . $var_pincode;
                $stmt = $this->con->prepare("SELECT *  FROM `code_users` WHERE `username` =? AND `contact` LIKE ?");
                $stmt->bind_param("ss",$event_uid_2,$var_pincodev1);
                $stmt->execute();
                return $stmt->get_result()->fetch_assoc();
            }
            
            public function getClient($var_fullname,$var_numberNIF,$var_contact,$var_residence,$var_province,$var_country,$var_aganceId,$var_username,$var_date,$var_userId){
                if ($this->isClientExist($var_contact)) {
                        return 0;
                } else { 
                     $stmt = $this->con->prepare("INSERT INTO `agc_preneur`(`Nomprenom`, `Categorie`, `Phone`, `AddresResidence`, `province`, `country`, `Agence`, `username`, `code_user`, `date`) VALUES (?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("ssssssssss", $var_fullname,$var_numberNIF,$var_contact,$var_residence,$var_province,$var_country,$var_aganceId,$var_username,$var_userId,$var_date);
                    if ($stmt->execute()) {
                        return 1;
                    } else {
                        return 2;
                    }
                }
            }
            
            private function isClientExist($var_contact){
                $stmt = $this->con->prepare("SELECT `Id` FROM `agc_preneur` WHERE `Phone`=?");
                $stmt->bind_param("s", $var_contact);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            public function getAutoNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat` WHERE `agence`=? AND `DateEmission` BETWEEN DATE_SUB(CURDATE(), INTERVAL 4 WEEK) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            //,$var_date
            public function getAutoNow($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat` WHERE `agence`=? AND `DateEmission` BETWEEN DATE_SUB(CURDATE(), INTERVAL 4 WEEK) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getAutov1No($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 1 MONTH))");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getAutoPast($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getAutov2No($userId){
                 $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `agc_contrat` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                  $stmt->bind_param("s",$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_balance'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getAutoFina($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getOwner(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_preneur` ORDER BY `Nomprenom` ASC");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getOwnerCat(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_pol_categ` ORDER BY `Libelle` ASC");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getAutoPolice($user_agence,$pol_status,$prefix){
                 $var_pincodev1 = $prefix.'%';
                 $stmt = $this->con->prepare("SELECT * FROM `agc_chargement` WHERE `Agence`=? AND `Status`=? AND Numpol like ? ORDER BY `Numpol` ASC");
                  $stmt->bind_param("sss",$user_agence,$pol_status,$var_pincodev1);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getAutoCertificate($user_agence,$cert_status,$produit){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_certificat` WHERE `produit`=? AND `Status`=? AND `Agence`=? ORDER BY `Certificat` ASC");
                  $stmt->bind_param("sss",$produit,$cert_status,$user_agence);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
                        
            public function getAutoPrime($user_agence,$prime_status,$produit){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_notprime` WHERE `produit`=? AND `Status`=? AND `Agence`=? ORDER BY `NotePrime` ASC");
                  $stmt->bind_param("sss",$produit,$prime_status,$user_agence);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getPlateCat(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_categorieplaque` ORDER BY `category` ASC");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getUsagePlate(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_plaquecategory` ORDER BY `usage` ASC");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getGarantiAuto($produit){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_garanties` WHERE `produit`=? ORDER BY `Garantie` ASC");
                  $stmt->bind_param("s",$produit);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getMyContratPolNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat` WHERE `agence`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getAutomobile($var_preneur,$var_categoryPreneur,$var_police,$var_dateCarteRose,$var_dateEffet,$var_dateEcheance,$var_certificat,$var_prime,$var_plaque,$var_categoryPlaque,$var_chassis,$var_dateFabrication,$var_model,$var_puissance,$var_cabine,$var_plateau,$var_usage,$var_primeNet,$var_valeurAssure,$var_garanti,$Year2,$var_userFullname,$var_username,$var_userCode,$var_agenceName){
                if ($this->isAutomobileExist($var_certificat,$var_police,$var_prime)) {
                        return 0;
                }else {
                    $stmt = $this->con->prepare("CALL insertAutomobile(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssssssssssssssssssss", $var_preneur,$var_categoryPreneur,$var_police,$var_dateCarteRose,$var_dateEffet,$var_dateEcheance,$var_certificat,$var_prime,$var_plaque,$var_categoryPlaque,$var_chassis,$var_dateFabrication,$var_model,$var_puissance,$var_cabine,$var_plateau,$var_usage,$var_primeNet,$var_valeurAssure,$var_garanti,$Year2,$var_userFullname,$var_username,$var_userCode,$var_agenceName);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isAutomobileExist($var_certificat,$var_police,$var_prime){
                $stmt = $this->con->prepare("SELECT Id FROM `agc_contrat` WHERE `Numpol`=? OR `NumCertificat`=? OR  `NumPrime`=?");
                $stmt->bind_param("sss",$var_police,$var_certificat,$var_prime);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            public function getReport($Motif,$var_agenceName,$var_username,$date_operation){
                    $stmt = $this->con->prepare("INSERT INTO `agc_maintenance`(`mistake_reported`, `agence`, `correctedBy`, `date`) VALUES (?,?,?,?)");
                    $stmt->bind_param("ssss", $Motif,$var_agenceName,$var_username,$date_operation);
                    if ($stmt->execute()) {
                        return 1;
                    } else {
                        return 2;
               }  
            }
            
            public function getTransNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_marine` WHERE `agence`=? AND `DateEmission` BETWEEN DATE_SUB(CURDATE(), INTERVAL 4 WEEK) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getTransNow($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_marine` WHERE `agence`=? AND `DateEmission` BETWEEN DATE_SUB(CURDATE(), INTERVAL 4 WEEK) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getTransv1No($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_marine` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 1 MONTH))");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getTransPast($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_marine` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getTransv2No($userId){
                 $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `agc_contrat_marine` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                  $stmt->bind_param("s",$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_balance'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getTransFina($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_marine` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getMyContTransPolNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_marine` WHERE `agence`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getTransPolice($user_agence,$pol_status,$prefix){
                 $var_pincodev1 = $prefix.'%';
                 $stmt = $this->con->prepare("SELECT * FROM `agc_chargement` WHERE `Agence`=? AND `Status`=? AND Numpol like ? ORDER BY `Numpol` ASC");
                  $stmt->bind_param("sss",$user_agence,$pol_status,$var_pincodev1);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getTransPrime($user_agence,$prime_status,$produit){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_notprime` WHERE `produit`=? AND `Status`=? AND `Agence`=? ORDER BY `NotePrime` ASC");
                  $stmt->bind_param("sss",$produit,$prime_status,$user_agence);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getVoie(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_voie`");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getTransit(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_transit`");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
             public function getPortFrom(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_countries`");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getPortDest(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_countries`");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
             public function getCurrency(){
                 $stmt = $this->con->prepare("SELECT * FROM `helper_country`");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getGarantiTrans($produit){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_garanties` WHERE `produit`=? ORDER BY `Garantie` ASC");
                  $stmt->bind_param("s",$produit);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
             public function getEmballage(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_paquet` ORDER BY `typeEmballage` ASC");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
           public function getTransport($var_preneur,$var_police,$var_dateEffet,$var_dateEcheance,
                   $var_certificat,$var_natureMarchandise,$var_taux_Cotation,$var_numeroFacture,$var_dateFacture,$var_DetailArticle,
                   $var_valeurDevise,$var_tauxChange,$var_voie,$var_transit,$var_emballage,$var_portOrigine,
                   $var_portDestination,$var_devise,$var_garanti,$var_userFullname,
                   $var_agenceName,$var_username,$var_userCode,$Year2){
                            if ($this->isTransportExist($var_certificat,$var_police)) {
                               return 0;
                            }else {
            
                                $stmt = $this->con->prepare("CALL insertTransport(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                $stmt->bind_param("ssssssssssssssssssssssss", $var_preneur,$var_police,$var_dateEffet,$var_dateEcheance,
                   $var_certificat,$var_natureMarchandise,$var_taux_Cotation,$var_numeroFacture,$var_dateFacture,$var_DetailArticle,
                   $var_valeurDevise,$var_tauxChange,$var_voie,$var_transit,$var_emballage,$var_portOrigine,
                   $var_portDestination,$var_devise,$var_garanti,$var_userFullname,
                   $var_agenceName,$var_username,$var_userCode,$Year2);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isTransportExist($var_certificat,$var_police){
                $stmt = $this->con->prepare("SELECT Id FROM `agc_contrat_marine` WHERE `NumCertificat`=? OR `Numpol`=?");
                $stmt->bind_param("ss", $var_certificat,$var_police);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            public function getIncNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_fire` WHERE `agence`=? AND `DateEmission` BETWEEN DATE_SUB(CURDATE(), INTERVAL 4 WEEK) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getIncNow($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_fire` WHERE `agence`=? AND `DateEmission` BETWEEN DATE_SUB(CURDATE(), INTERVAL 4 WEEK) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getIncv1No($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_fire` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 1 MONTH))");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getIncPast($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_fire` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getIncv2No($userId){
                 $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `agc_contrat_fire` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                  $stmt->bind_param("s",$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_balance'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getIncFina($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_fire` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getMyContIncPolNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_fire` WHERE `agence`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getIncPolice($user_agence,$pol_status,$prefix){
                 $var_pincodev1 = $prefix.'%';
                 $stmt = $this->con->prepare("SELECT * FROM `agc_chargement` WHERE `Agence`=? AND `Status`=? AND Numpol like ? ORDER BY `Numpol` ASC");
                  $stmt->bind_param("sss",$user_agence,$pol_status,$var_pincodev1);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getIncPrime($user_agence,$prime_status,$produit){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_notprime` WHERE `produit`=? AND `Status`=? AND `Agence`=? ORDER BY `NotePrime` ASC");
                  $stmt->bind_param("sss",$produit,$prime_status,$user_agence);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getGarantiInc($produit){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_garanties` WHERE `produit`=? ORDER BY `Garantie` ASC");
                  $stmt->bind_param("s",$produit);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getIncendie($var_preneur,$var_tauxCotation,$var_police,$var_dateEffet,
                    $var_dateEcheance,$var_certificat,$var_ObjetAssurer,$var_quantite,$var_typebatiment,$var_modePrevention,$var_modeConstruction,$var_numeroTitre,$var_numeroParcelle,
                    $var_emplacement,$var_nombreNiveau,$var_numeroAutorisation,$var_usage,$var_garanti,$var_valeurAssure,$var_primeNet,$Year2,
                    $var_userFullname,$var_userCode,$var_username,$var_agenceName){
                if ($this->isIncendieExist($var_certificat,$var_police)) {
                   return 0;
                }else {

                    $stmt = $this->con->prepare("CALL insertIncendie(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssssssssssssssssssss", $var_preneur,$var_police,$var_dateEffet,
                    $var_dateEcheance,$var_certificat,$var_ObjetAssurer,$var_quantite,$var_typebatiment,$var_usage,$var_modePrevention,$var_numeroTitre,$var_numeroParcelle,
                    $var_emplacement,$var_numeroAutorisation,$var_modeConstruction,$var_nombreNiveau,$var_tauxCotation,$var_primeNet,$var_valeurAssure,$var_garanti,$Year2,
                    $var_userFullname,$var_userCode,$var_username,$var_agenceName);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isIncendieExist($var_certificat,$var_police){
                $stmt = $this->con->prepare("SELECT Id FROM `agc_contrat_fire` WHERE `NumCertificat`=? OR `Numpol`=?");
                $stmt->bind_param("ss", $var_certificat,$var_police);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            public function getRespNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_rc` WHERE `agence`=? AND `DateEmission` BETWEEN DATE_SUB(CURDATE(), INTERVAL 4 WEEK) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getRespNow($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_rc` WHERE `agence`=? AND `DateEmission` BETWEEN DATE_SUB(CURDATE(), INTERVAL 4 WEEK) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getRespv1No($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_rc` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 1 MONTH))");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getRespPast($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_rc` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getRespv2No($userId){
                 $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `agc_contrat_rc` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                  $stmt->bind_param("s",$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_balance'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getRespFina($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_rc` WHERE `agence`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
           public function getMyContRespPolNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_rc` WHERE `agence`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getRespPolice($user_agence,$pol_status,$prefix){
                 $var_pincodev1 = $prefix.'%';
                 $stmt = $this->con->prepare("SELECT * FROM `agc_chargement` WHERE `Agence`=? AND `Status`=? AND Numpol like ? ORDER BY `Numpol` ASC");
                  $stmt->bind_param("sss",$user_agence,$pol_status,$var_pincodev1);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getRespPrime($user_agence,$prime_status,$produit){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_notprime` WHERE `produit`=? AND `Status`=? AND `Agence`=? ORDER BY `NotePrime` ASC");
                  $stmt->bind_param("sss",$produit,$prime_status,$user_agence);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getGarantiResp($produit){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_garanties` WHERE `produit`=? ORDER BY `Garantie` ASC");
                  $stmt->bind_param("s",$produit);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getResponsabilite($var_preneur,$var_police,$var_dateEffet,$var_dateEcheance,
               $var_certificat,$var_designation,$var_occupation,$var_localisation,
               $var_descrValeur,$var_tauxCotation,$var_usage,$var_garanti,$var_ValeurAssurer,
               $var_primeNet,$var_userFullname,$var_agenceName,$var_username,$var_userCode,$Year2){
                if ($this->isResponsabiliteExist($var_certificat,$var_police)) {
                   return 0;
                }else {

                    $stmt = $this->con->prepare("CALL insertResponsabilite(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssssssssssssss", $var_preneur,$var_police,$var_dateEffet,$var_dateEcheance,
                    $var_certificat,$var_designation,$var_occupation,$var_localisation,
                    $var_descrValeur,$var_tauxCotation,$var_usage,$var_garanti,$var_ValeurAssurer,
                    $var_primeNet,$var_userFullname,$var_agenceName,$var_username,$var_userCode,$Year2);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isResponsabiliteExist($var_certificat,$var_police){
                $stmt = $this->con->prepare("SELECT Id FROM `agc_contrat_rc` WHERE `NumCertificat`=? OR `Numpol`=?");
                $stmt->bind_param("ss", $var_certificat,$var_police);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            public function getAccNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_ac` WHERE `agence`=? AND `Date_emission` BETWEEN DATE_SUB(CURDATE(), INTERVAL 4 WEEK) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getAccNow($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_ac` WHERE `agence`=? AND `Date_emission` BETWEEN DATE_SUB(CURDATE(), INTERVAL 4 WEEK) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getAccv1No($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_ac` WHERE `agence`=? AND Date_emission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 1 MONTH))");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getAccPast($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_ac` WHERE `agence`=? AND Date_emission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getAccv2No($userId){
                 $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `agc_contrat_ac` WHERE `agence`=? AND Date_emission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                  $stmt->bind_param("s",$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_balance'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getAccFina($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_ac` WHERE `agence`=? AND Date_emission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getMyContAccPolNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_ac` WHERE `agence`=? AND `Date_emission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getAccPolice($user_agence,$pol_status,$prefix){
                 $var_pincodev1 = $prefix.'%';
                 $stmt = $this->con->prepare("SELECT * FROM `agc_chargement` WHERE `Agence`=? AND `Status`=? AND Numpol like ? ORDER BY `Numpol` ASC");
                  $stmt->bind_param("sss",$user_agence,$pol_status,$var_pincodev1);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getAccPrime($user_agence,$prime_status,$produit){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_notprime` WHERE `produit`=? AND `Status`=? AND `Agence`=? ORDER BY `NotePrime` ASC");
                  $stmt->bind_param("sss",$produit,$prime_status,$user_agence);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getGarantiAcc($produit){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_garanties` WHERE `produit`=? ORDER BY `Garantie` ASC");
                  $stmt->bind_param("s",$produit);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getAccident($var_preneur,$var_police,$var_dateEffet,$var_dateEcheance, $var_certificat,
                $var_statio,$var_occupation,$var_localisation,$var_usagio,$var_effectif,
                $var_nature, $var_indeminite,$var_tocotation,$var_garanti,
               $var_plafond,$var_userFullname,$var_userAgence,$var_username,$var_userCode,$Year2){
                if ($this->isAccidentExist($var_certificat,$var_police)) {
                   return 0;
                }else {

                    $stmt = $this->con->prepare("CALL insertAccident(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("ssssssssssssssssssss", $var_preneur,$var_police,$var_dateEffet,$var_dateEcheance, $var_certificat,$var_statio,
                    $var_occupation,$var_localisation,$var_usagio,$var_effectif,$var_nature, $var_indeminite,
                    $var_tocotation,$var_garanti,$var_plafond,$var_userFullname,$var_userAgence,$var_username,$var_userCode,$Year2);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isAccidentExist($var_certificat,$var_police){
                $stmt = $this->con->prepare("SELECT Id FROM `agc_contrat_ac` WHERE `Numnoteprime`=? OR `Numpol`=?");
                $stmt->bind_param("ss", $var_certificat,$var_police);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            public function getPsrNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`id`) AS total_contrat FROM `agc_agicoplus_psr` WHERE `agence`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getPsr($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_agicoplus_psr` WHERE `agence`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getObrNo($user_agence){
                 $stmt = $this->con->prepare("SELECT COUNT(`id`) AS total_contrat FROM `agc_obr_dataebms` WHERE `agence`=? AND `date` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
                        
            public function getObr($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_obr_dataebms` WHERE `agence`=? AND `date` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getMyCommission($userId,$Status){
                 $stmt = $this->con->prepare("SELECT SUM(`part_agence`) AS total_balance FROM `agc_commission` WHERE `Status`=? AND `Agence`=? AND CreatedAt BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                  $stmt->bind_param("ss",$Status,$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_balance'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
             public function getCommission($user_agence,$status){
                $stmt = $this->con->prepare("SELECT * FROM `agc_commission` WHERE `Status`=? AND `Agence`=? AND `CreatedAt` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `id` DESC");
                $stmt->bind_param("ss",$status, $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getRecetteNo($userId,$Status){
                 $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `agc_recette` WHERE `status`=? AND `Agence`=? AND date BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                  $stmt->bind_param("ss",$Status,$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_balance'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getRecette($user_agence,$status){
                //SELECT * FROM `agc_recette` WHERE `status`=? AND `Agence`=? AND date BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `id` DESC
                $stmt = $this->con->prepare("SELECT * FROM `agc_recette` WHERE `status`=? AND `Agence`=? AND date BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `id` DESC");
                $stmt->bind_param("ss",$status,$user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
             public function getPostNo($user_Id){
                 $stmt = $this->con->prepare("SELECT COUNT(`id`) AS total_post FROM `agc_social` WHERE `event_uid`=? AND `event_date` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("s", $user_Id);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_post'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getLikesNo($user_Id){
                 $stmt = $this->con->prepare("SELECT SUM(`event_like`) AS total_likes FROM `agc_social` WHERE `event_uid`=? AND `event_date` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("s", $user_Id);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_likes'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getLovesNo($user_Id){
                 $stmt = $this->con->prepare("SELECT SUM(`event_love`) AS total_loves FROM `agc_social` WHERE `event_uid`=? AND `event_date` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("s", $user_Id);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_loves'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
              public function getDislikeNo($user_Id){
                 $stmt = $this->con->prepare("SELECT SUM(`event_dislike`) AS total_dislikes FROM `agc_social` WHERE `event_uid`=? AND `event_date` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("s", $user_Id);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_dislikes'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getMyRespNo($user_name,$user_id){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_rc` WHERE `Proprietaire`=? AND `owner_id`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("ss", $user_name,$user_id);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getMyResp($user_name,$user_id){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_rc` WHERE `Proprietaire`=? AND `owner_id`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("ss", $user_name,$user_id);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
             public function getMyAutoNo($user_name,$user_id){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat` WHERE `Proprietaire`=? AND `owner_id`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("ss", $user_name,$user_id);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getMyAuto($user_name,$user_id){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat` WHERE `Proprietaire`=? AND `owner_id`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("ss", $user_name,$user_id);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getMyTransNo($user_name,$user_id){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_marine` WHERE `Proprietaire`=? AND `owner_id`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("ss", $user_name,$user_id);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getMyTrans($user_name,$user_id){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_marine` WHERE `Proprietaire`=? AND `owner_id`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("ss", $user_name,$user_id);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getMyIncNo($user_name,$user_id){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_fire` WHERE `Proprietaire`=? AND `owner_id`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("ss", $user_name,$user_id);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getMyInc($user_name,$user_id){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_fire` WHERE `Proprietaire`=? AND `owner_id`=? AND `DateEmission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("ss", $user_name,$user_id);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getMyAccNo($user_name,$user_id){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contrat FROM `agc_contrat_ac` WHERE `Proprietaire`=? AND `owner_id`=? AND `Date_emission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                 $stmt->bind_param("ss", $user_name,$user_id);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_contrat'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getMyAcc($user_name,$user_id){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat_ac` WHERE `Proprietaire`=? AND `owner_id`=? AND `Date_emission` BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("ss", $user_name,$user_id);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getMembersv2No(){
                 $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_clients FROM `code_users`");
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_clients'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getMembersAll(){
                $stmt = $this->con->prepare("SELECT * FROM `code_users` ORDER BY `Id` DESC");
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getMyCountry(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_countries`");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getMyProvince(){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_province` ORDER BY `province` ASC");
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getUidUpdated($var_username,$var_userId){
                 $stmt = $this->con->prepare("UPDATE `code_users` SET `username`=? WHERE `Id`=?");
                $stmt->bind_param("ss", $var_username,$var_userId);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getPassUpdated($var_password,$var_userId){
                 $pass = md5($var_password);
                 $stmt = $this->con->prepare("UPDATE `code_users` SET `password`=? WHERE `Id`=?");
                $stmt->bind_param("ss", $pass,$var_userId);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getContactUpdated($var_contact,$var_userId){
                 $stmt = $this->con->prepare("UPDATE `code_users` SET `contact`=? WHERE `Id`=?");
                $stmt->bind_param("ss", $var_contact,$var_userId);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getAddress($var_userId,$var_residence,$var_province,$var_country,$user_country){
                   $stmt = $this->con->prepare("UPDATE `code_users` SET `residence`=?,`province`=?,`country`=?,`countryId`=? WHERE `Id`=?");
                $stmt->bind_param("sssss", $var_residence,$var_province,$var_country,$user_country,$var_userId);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getUIDImageUpdate($var_userId,$eventImage,$ImagePath,$ImageData){
                    $stmt = $this->con->prepare("UPDATE `code_users` SET `img`=? WHERE `Id`=?");
                $stmt->bind_param("ss", $eventImage, $var_userId);
                 if ($stmt->execute()) {
                      file_put_contents($ImagePath,base64_decode($ImageData));
                        return 1;
                    } else {
                        return 2;
               }
            }
            
            public function getImgDataAcc($eventImage, $var_userId){
                  $stmt = $this->con->prepare("UPDATE `agc_social` SET `urlImg_profile`=? WHERE `event_uid`=?");
                $stmt->bind_param("ss", $eventImage, $var_userId);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getPublishv1($user_img,$user_details, $user_paysname, $var_content, $eventImagev1, $like, $love, $dislike, $var_date, $var_time, $var_userId,$ImagePathv1,$ImageData){
                    $stmt = $this->con->prepare("INSERT INTO `agc_social`(`urlImg_profile`, `event_name`, `event_country`, `event_content`, `event_image`, `event_like`, `event_love`, `event_dislike`, `event_date`, `event_time`, `event_uid`) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssssss", $user_img, $user_details, $user_paysname, $var_content, $eventImagev1, $like, $love, $dislike, $var_date, $var_time, $var_userId);
                    if ($stmt->execute()) {
                      file_put_contents($ImagePathv1,base64_decode($ImageData));
                        return 1;
                    } else {
                        return 2;
               }
            }
            
             public function getConfigAcc($acc_name,$acc_number,$var_userId,$var_date,$var_time){
              if (!$this->isAccCreated($var_userId)) {  
                    $stmt = $this->con->prepare("INSERT INTO `agc_mobile_account`(`AccName`, `AccountNo`, `AccOwnerId`, `date`, `time`) VALUES (?,?,?,?,?)");
                    $stmt->bind_param("sssss", $acc_name,$acc_number,$var_userId,$var_date,$var_time);
                    if ($stmt->execute()) {
                        return 1;  
                    } else {
                        return 2;  
                    }
                } else {
                    return 0;  
                }
            }
            
            private function isAccCreated($var_userId){
                $stmt = $this->con->prepare("SELECT `id` FROM `agc_mobile_account` WHERE `AccOwnerId`=?");
                $stmt->bind_param("s", $var_userId);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            public function getVisaAcc($cardClass,$serialId,$pincode,$acc_name,$accNumber,$var_userId,$codeKey,$var_date,$var_time){
                $stmt = $this->con->prepare("INSERT INTO `agc_card_payment`(`CardCategory`, `CardSerialId`, `AccCardPin`, `AccName`, `AccNumber`, `AccOwnerId`, `qrCard`, `date`, `time`) VALUES (?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssss", $cardClass,$serialId,$pincode,$acc_name,$accNumber,$var_userId,$codeKey,$var_date,$var_time);
                    if ($stmt->execute()) {
                        return 1;  
                    } else {
                        return 2;  
                } 
            }
            
            public function getMyAccNumber($userId, $status) {
                // Prepare the SQL statement
                $stmt = $this->con->prepare("
                    SELECT `AccountNo` AS max_acc 
                    FROM `agc_mobile_account` 
                    WHERE `AccOwnerId` = ? AND `statusId` = ?
                ");
                
                // Bind parameters to the statement
                $stmt->bind_param("ss", $userId, $status);
            
                // Execute the statement
                $stmt->execute();
            
                // Fetch the result
                $result = $stmt->get_result();
            
                // Check if a record exists
                if ($result && $result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['max_acc'];
                }
            
                // Default value when no record is found
                return 11111111;
            }
            
            public function getMyAccName($userId, $status) {
                $stmt = $this->con->prepare(
                    "SELECT `AccName` AS max_acc 
                     FROM `agc_mobile_account` 
                     WHERE `AccOwnerId` = ? AND `statusId` = ?"
                );
            
                // Check if the statement was prepared successfully
                if ($stmt === false) {
                    throw new Exception("Failed to prepare statement: " . $this->con->error);
                }
            
                $stmt->bind_param("ss", $userId, $status);
                $stmt->execute();
                $result = $stmt->get_result();
            
                if ($result && $result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['max_acc'];
                }
            
                // Default value if no results are found
                return "Event(Default)";
            }
            
            public function getBuyerUidv1($payer_Id){
              $stmt = $this->con->prepare("SELECT *  FROM `code_users` WHERE `id`=?");
              $stmt->bind_param("s",$payer_Id);
              $stmt->execute();
             return $stmt->get_result()->fetch_assoc();
            }
            
            public function getBuyerAccountNo($payer_Id){
              $status = 1;
              $stmt = $this->con->prepare("SELECT *  FROM `agc_mobile_account` WHERE `AccOwnerId`=? AND `statusId`=?");
              $stmt->bind_param("ss",$payer_Id,$status);
              $stmt->execute();
             return $stmt->get_result()->fetch_assoc();
            }
            
            public function getContrIdPol($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Numcontrat AS policeId FROM `agc_contrat` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['policeId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
            public function getInvoiceIdPol($assurance_Id){
                  $stmt = $this->con->prepare("SELECT facture AS invoiceId FROM `agc_contrat` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['invoiceId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
            public function getSellerId($assurance_Id){
                  $stmt = $this->con->prepare("SELECT agence AS agenceId FROM `agc_contrat` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['agenceId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
            public function getProprio($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Proprietaire AS proprio FROM `agc_contrat` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['proprio'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
             public function getSellerAccNumber($CompanyAccId){
                     $stmt = $this->con->prepare("SELECT AccountNo AS acc_uid FROM `agc_mobile_account` WHERE `AccOwnerId` = ?");
                     $stmt->bind_param("s",$CompanyAccId);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['acc_uid'];
                    } else {
                        $giss_getVar = '00000000';
                        return $giss_getVar;
                }  
             }
         
             public function getSellerAccName($CompanyAccId){
                 $stmt = $this->con->prepare("SELECT AccName AS acc_uid FROM `agc_mobile_account` WHERE `AccOwnerId` = ?");
                     $stmt->bind_param("s",$CompanyAccId);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['acc_uid'];
                    } else {
                        $giss_getVar = 'Uknown';
                        return $giss_getVar;
                }  
             }
             
             public function getIdPolice($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Numpol AS policeNo FROM `agc_contrat` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['policeNo'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
            public function getPolBalance($assurance_Id){
                  $stmt = $this->con->prepare("SELECT PB AS balance FROM `agc_contrat` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['balance'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
            
            public function getPoliceAchatInitiated($OperKey,$assurance_Id,$contratId,$invoiceId,$var_sellerId,$var_proprio,$varAccSellerNum,$varAccSellerName,$myAcccontact,$qtyBought,$Amount,$category,$policeId,$op_reference,$var_date,$var_time,$payer_Id){
             if (!$this->isHasAccount($payer_Id)) {  
                 return 0;  
               
             } else {
                 
                 if ($this->isInitiated($contratId)) {  
                 return 3;  
               
                } else {
                 
                
                        $stmt = $this->con->prepare("INSERT INTO `agc_purchase`(`op_key_id`,`police_id`,`payment_id`,`invoice_id`,`agence_id`,`assurance_pro`, `paidto_number`, `paidto_name`, `payer_number`, `product_qty`, `balance_paid`, `product_category`, `product_paid`, `op_reference`, `op_date`, `op_time`, `doneby`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                        $stmt->bind_param("sssssssssssssssss", $OperKey,$assurance_Id,$contratId,$invoiceId,$var_sellerId,$var_proprio,$varAccSellerNum,$varAccSellerName,$myAcccontact,$qtyBought,$Amount,$category,$policeId,$op_reference,$var_date,$var_time,$payer_Id);
                         if ($stmt->execute()) {
                                return 1;
                            } else {
                                return 2;
                       }
                    }
                }
            }
            
            private function isInitiated($contratId){
                    $stmt = $this->con->prepare("SELECT `id` FROM `agc_purchase` WHERE `payment_id`=?");
                    $stmt->bind_param("s", $contratId);
                    $stmt->execute();
                    $stmt->store_result();
                    return $stmt->num_rows > 0;
            }
        
            private function isHasAccount($payer_Id){
                    $stmt = $this->con->prepare("SELECT `id` FROM `agc_mobile_account` WHERE `AccOwnerId`=?");
                    $stmt->bind_param("s", $payer_Id);
                    $stmt->execute();
                    $stmt->store_result();
                    return $stmt->num_rows > 0;
            }
            
            public function getPoliceUpgraded($assurance_Id,$ins){
                $stmt = $this->con->prepare("UPDATE `agc_contrat` SET `facturation`=? WHERE `Id`=?");
                $stmt->bind_param("ss", $ins,$assurance_Id);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            public function getCartPending($status_var,$payer_Id){
                $card = "Mobile";
                $stmt = $this->con->prepare("SELECT * FROM agc_purchase WHERE `agence_id` =? AND `payment`=? AND `op_status` = ? ORDER BY `id` DESC");
                $stmt->bind_param("sss",$payer_Id,$card,$status_var);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
             public function getCartProcessed($payer_Id){
                 $card = "Mobile";
                $stmt = $this->con->prepare("SELECT * FROM agc_purchase WHERE `agence_id` = ? AND `payment`=? AND `op_status` IN (1, 2, 4)  ORDER BY `id` DESC");
                $stmt->bind_param("ss",$payer_Id,$card);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
            public function GetLogValues($company){
              $stmt = $this->con->prepare("SELECT *  FROM `agc_api_settings` WHERE `company_id`=?");
              $stmt->bind_param("s",$company);
              $stmt->execute();
             return $stmt->get_result()->fetch_assoc();
            }
            
            public function getPurchasedValues($order_Id){
              $stmt = $this->con->prepare("SELECT *  FROM `agc_purchase` WHERE `id`=?");
              $stmt->bind_param("s",$order_Id);
              $stmt->execute();
             return $stmt->get_result()->fetch_assoc();
            }
            
            public function customerPaymentv1($url,$datav1){
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    "Content-Type: application/json"
                ]);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($datav1));
                curl_setopt($ch, CURLOPT_SSLCERT, "../v3/certificate/STAR_cashtel_bi.crt"); 
                curl_setopt($ch, CURLOPT_SSLKEY, "../v3/certificate/private_key.pem");     
                curl_setopt($ch, CURLOPT_SSLCERTTYPE, 'PEM');             
                curl_setopt($ch, CURLOPT_SSLKEYTYPE, 'PEM');
                
                $response = curl_exec($ch);
              
               // var_dump($response);
                if (curl_errno($ch)) {
                    echo "cURL Error: " . curl_error($ch);
                }
                return $response;
                curl_close($ch);
                echo "Response: " . $response;

            }
            
            public function customerPaymentv2($token,$sessionId,$customerNumber){
                $msisdn = $customerNumber;
                $url = "https://payments.cashtel.bi:8443/cpgTest/CashTelService/customerLookUp/{$sessionId}/{$msisdn}";
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    "Authorization: ".$token
                ]);
                curl_setopt($ch, CURLOPT_SSLCERT, "../v3/certificate/STAR_cashtel_bi.crt"); 
                curl_setopt($ch, CURLOPT_SSLKEY, "../v3/certificate/private_key.pem");     
                curl_setopt($ch, CURLOPT_SSLCERTTYPE, 'PEM');             
                curl_setopt($ch, CURLOPT_SSLKEYTYPE, 'PEM');
                
                $response = curl_exec($ch);
                
                if (curl_errno($ch)) {
                    echo "cURL Error: " . curl_error($ch);
                }
                return $response;
                curl_close($ch);
                echo "Response: " . $response;

            }
            
            public function customerPaymentv3($token,$datav3){
                $url = "https://payments.cashtel.bi:8443/cpgTest/CashTelService/payBill";
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    "Authorization: ".$token,
                    "Content-Type: application/json"
                ]);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($datav3));
                curl_setopt($ch, CURLOPT_SSLCERT, "../v3/certificate/STAR_cashtel_bi.crt"); 
                curl_setopt($ch, CURLOPT_SSLKEY, "../v3/certificate/private_key.pem");     
                curl_setopt($ch, CURLOPT_SSLCERTTYPE, 'PEM');             
                curl_setopt($ch, CURLOPT_SSLKEYTYPE, 'PEM');
                
                $response = curl_exec($ch);
                
                if (curl_errno($ch)) {
                    echo "cURL Error: " . curl_error($ch);
                }
                return $response;
                curl_close($ch);
                echo "Response: " . $response;
            }
            
            public function getPaymentUpdTrans($order_Id,$narration,$partnerTrx,$nameCustomer,$responseCode,$description,$cashtelTrx,$statusValue){
               $stmt = $this->con->prepare("UPDATE `agc_purchase` SET `payer_name`=?,`narration`=?,`responseCode`=?, `description`=?, `cashTelTrxId`=?,`op_status`=? WHERE `id`=? AND `op_reference`=?");
                    $stmt->bind_param("ssssssss", $nameCustomer,$narration,$responseCode,$description,$cashtelTrx,$statusValue,$order_Id,$partnerTrx);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
             public function getMyOperations($userId){
                 $stmt = $this->con->prepare("SELECT COUNT(`id`) AS total_operations FROM `agc_purchase` WHERE `agence_id`=?");
                  $stmt->bind_param("s",$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_operations'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
             public function getPayment($userId){
                 $stat = 1;
                 $stmt = $this->con->prepare("SELECT SUM(`balance_paid`) AS total_income FROM `agc_purchase` WHERE `agence_id`=? AND `op_status`=?");
                  $stmt->bind_param("ss",$userId,$stat);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_income'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
              public function getAgency($userId){
                 $stat = 1;
                 $stmt = $this->con->prepare("SELECT SUM(`part_agence`) AS total_income FROM `agc_recette` WHERE `Agence`=? AND `status`=? AND YEAR(date) = YEAR(CURDATE())");
                  $stmt->bind_param("ss",$userId,$stat);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_income'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
              public function getCompany($userId){
                 $stat = 1;
                 $stmt = $this->con->prepare("SELECT SUM(`part_company`) AS total_income FROM `agc_recette` WHERE `Agence`=? AND `status`=? AND YEAR(date) = YEAR(CURDATE())");
                  $stmt->bind_param("ss",$userId,$stat);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_income'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getEbms(){
                $stmt = $this->con->prepare("SELECT * FROM agc_obr_agicoplus  ORDER BY `id` DESC");
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
             public function getTRContrIdPol($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Numcontrat AS policeId FROM `agc_contrat_marine` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['policeId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
             public function getTRInvoiceIdPol($assurance_Id){
                  $stmt = $this->con->prepare("SELECT facture AS invoiceId FROM `agc_contrat_marine` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['invoiceId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
              public function getTRSellerId($assurance_Id){
                  $stmt = $this->con->prepare("SELECT agence AS agenceId FROM `agc_contrat_marine` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['agenceId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
             public function getTRProprio($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Proprietaire AS proprio FROM `agc_contrat_marine` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['proprio'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
              public function getTRPolBalance($assurance_Id){
                  $stmt = $this->con->prepare("SELECT PB AS balance FROM `agc_contrat_marine` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['balance'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
              public function getTRIdPolice($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Numpol AS policeNo FROM `agc_contrat_marine` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['policeNo'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
              public function getTRPoliceUpgraded($assurance_Id,$ins){
                $stmt = $this->con->prepare("UPDATE `agc_contrat_marine` SET `facturation`=? WHERE `Id`=?");
                $stmt->bind_param("ss", $ins,$assurance_Id);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
             public function getACContrIdPol($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Numcontrat AS policeId FROM `agc_contrat_ac` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['policeId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
              public function getACInvoiceIdPol($assurance_Id){
                  $stmt = $this->con->prepare("SELECT facture AS invoiceId FROM `agc_contrat_ac` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['invoiceId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
              public function getACSellerId($assurance_Id){
                  $stmt = $this->con->prepare("SELECT agence AS agenceId FROM `agc_contrat_ac` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['agenceId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
              public function getACProprio($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Proprietaire AS proprio FROM `agc_contrat_ac` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['proprio'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
               public function getACPolBalance($assurance_Id){
                  $stmt = $this->con->prepare("SELECT PB AS balance FROM `agc_contrat_ac` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['balance'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
             public function getACIdPolice($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Numpol AS policeNo FROM `agc_contrat_ac` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['policeNo'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
              public function getACPoliceUpgraded($assurance_Id,$ins){
                $stmt = $this->con->prepare("UPDATE `agc_contrat_ac` SET `facturation`=? WHERE `Id`=?");
                $stmt->bind_param("ss", $ins,$assurance_Id);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
             
            public function getINCContrIdPol($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Numcontrat AS policeId FROM `agc_contrat_fire` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['policeId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
               public function getINCInvoiceIdPol($assurance_Id){
                  $stmt = $this->con->prepare("SELECT facture AS invoiceId FROM `agc_contrat_fire` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['invoiceId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
                public function getINCSellerId($assurance_Id){
                  $stmt = $this->con->prepare("SELECT agence AS agenceId FROM `agc_contrat_fire` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['agenceId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
              public function getINCProprio($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Proprietaire AS proprio FROM `agc_contrat_fire` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['proprio'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
                public function getINCPolBalance($assurance_Id){
                  $stmt = $this->con->prepare("SELECT PB AS balance FROM `agc_contrat_fire` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['balance'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
               public function getINCIdPolice($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Numpol AS policeNo FROM `agc_contrat_fire` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['policeNo'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             public function getINCPoliceUpgraded($assurance_Id,$ins){
                $stmt = $this->con->prepare("UPDATE `agc_contrat_fire` SET `facturation`=? WHERE `Id`=?");
                $stmt->bind_param("ss", $ins,$assurance_Id);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
             public function getRCContrIdPol($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Numcontrat AS policeId FROM `agc_contrat_rc` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['policeId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
            public function getRCInvoiceIdPol($assurance_Id){
                  $stmt = $this->con->prepare("SELECT facture AS invoiceId FROM `agc_contrat_rc` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['invoiceId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
                public function getRCSellerId($assurance_Id){
                  $stmt = $this->con->prepare("SELECT agence AS agenceId FROM `agc_contrat_rc` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['agenceId'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
               public function getRCProprio($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Proprietaire AS proprio FROM `agc_contrat_rc` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['proprio'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
                 public function getRCPolBalance($assurance_Id){
                  $stmt = $this->con->prepare("SELECT PB AS balance FROM `agc_contrat_rc` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['balance'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
                public function getRCIdPolice($assurance_Id){
                  $stmt = $this->con->prepare("SELECT Numpol AS policeNo FROM `agc_contrat_rc` WHERE `Id` = ?");
                     $stmt->bind_param("s",$assurance_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['policeNo'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
             }
             
              public function getRCPoliceUpgraded($assurance_Id,$ins){
                $stmt = $this->con->prepare("UPDATE `agc_contrat_rc` SET `facturation`=? WHERE `Id`=?");
                $stmt->bind_param("ss", $ins,$assurance_Id);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
            }
            
            // public function getCallBackUrl(){
            //     $sms = "You are very well connected";
            //     return $sms;
            // }
            
            public function getCustomerPayApproved($trxId,$cashtelTrxId,$trxStatus,$amount,$cMsisdn,$workStatus,$var_date,$var_time){
                $stmt = $this->con->prepare("INSERT INTO `agc_callback_tx`(`trxId`, `cashtelTrxId`, `trxStatus`, `amount`, `cMsisdn`, `evTrStatus`, `date`, `time`) VALUES (?,?,?,?,?,?,?,?)");
                $stmt->bind_param("ssssssss", $trxId,$cashtelTrxId,$trxStatus,$amount,$cMsisdn,$workStatus,$var_date,$var_time);
                 if ($stmt->execute()) {
                        return 1;
                    } else {
                        return 2;
               }
            }
            
            public function getlggdbyTsk($operation,$opState,$opTx,$opcTx,$opDate,$opTemps){
                $stmt = $this->con->prepare("INSERT INTO `agc_callback_errors`(`operation`, `etat`, `transation_id`, `cashtel_id`, `date`, `time`) VALUES (?,?,?,?,?,?)");
                $stmt->bind_param("ssssss", $operation,$opState,$opTx,$opcTx,$opDate,$opTemps);
                 if ($stmt->execute()) {
                        return 1;
                    } else {
                        return 2;
               }
            }
            
            public function getCstPrsCatTpVls($trxId){
              $stmt = $this->con->prepare("SELECT *  FROM `agc_purchase` WHERE `op_reference`=?");
              $stmt->bind_param("s",$trxId);
              $stmt->execute();
             return $stmt->get_result()->fetch_assoc();
            }
            
            public function getEvDetectedByIp($cartRef,$trxId,$cashtelTrxId,$trxStatus,$amount,$cMsisdn,$workStatus){
                   $stmt = $this->con->prepare("UPDATE `agc_purchase` SET `op_status`=?,`callback_trxId`=?, `callback_cashtelTrxId`=?, `callback_trxStatus`=?, `callback_amount`=?, `callback_cMsisdn`=? WHERE `op_reference`=?");
                    $stmt->bind_param("sssssss", $workStatus,$trxId,$cashtelTrxId,$trxStatus,$amount,$cMsisdn,$cartRef);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getEvDetectedByiPV4($cartContratId,$trxId,$cashtelTrxId,$workStatus){
                $stat = 1;
                   $stmt = $this->con->prepare("UPDATE `agc_contrat` SET `facturation`=?,`tx_reference`=?, `cashtelTrxId`=?, `situation`=?  WHERE `Id`=?");
                    $stmt->bind_param("sssss", $workStatus,$trxId,$cashtelTrxId,$stat,$cartContratId);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
        
            public function getEvDetectedByiPV5($cartPolice,$cartInvoice,$trxId,$cashtelTrxId,$workStatus){
                   $stmt = $this->con->prepare("UPDATE `agc_recette` SET `tx_reference`=?, `cashtelTrxId`=?, `status`=?  WHERE `NumPol`=? AND `Facture`=?");
                    $stmt->bind_param("ssss", $trxId,$cashtelTrxId,$workStatus,$cartPolice,$cartInvoice);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
             public function getEvDetectedTransByiPV4($cartContratId,$trxId,$cashtelTrxId,$workStatus){
                $stat = 1;
                   $stmt = $this->con->prepare("UPDATE `agc_contrat_marine` SET `facturation`=?,`tx_reference`=?, `cashtelTrxId`=?, `situation`=?  WHERE `Id`=?");
                    $stmt->bind_param("sssss", $workStatus,$trxId,$cashtelTrxId,$stat,$cartContratId);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getEvDetectedAccByiPV4($cartContratId,$trxId,$cashtelTrxId,$workStatus){
                $stat = 1;
                   $stmt = $this->con->prepare("UPDATE `agc_contrat_ac` SET `facturation`=?,`tx_reference`=?, `cashtelTrxId`=?, `Situation`=?  WHERE `Id`=?");
                    $stmt->bind_param("sssss", $workStatus,$trxId,$cashtelTrxId,$stat,$cartContratId);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
             public function getEvDetectedIncByiPV4($cartContratId,$trxId,$cashtelTrxId,$workStatus){
                $stat = 1;
                   $stmt = $this->con->prepare("UPDATE `agc_contrat_fire` SET `facturation`=?,`tx_reference`=?, `cashtelTrxId`=?, `situation`=?  WHERE `Id`=?");
                    $stmt->bind_param("sssss", $workStatus,$trxId,$cashtelTrxId,$stat,$cartContratId);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getEvDetectedResponsByiPV4($cartContratId,$trxId,$cashtelTrxId,$workStatus){
                $stat = 1;
                   $stmt = $this->con->prepare("UPDATE `agc_contrat_rc` SET `facturation`=?,`tx_reference`=?, `cashtelTrxId`=?, `situation`=?  WHERE `Id`=?");
                    $stmt->bind_param("sssss", $workStatus,$trxId,$cashtelTrxId,$stat,$cartContratId);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getListSocial($userId){
                 $stmt = $this->con->prepare("SELECT * FROM `agc_social` WHERE `event_uid`=? ORDER BY `id` DESC");
                   $stmt->bind_param("s",$userId);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $event_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $event_var[] = $row;
                }
                
                return $event_var;
            }
            
            public function getDelMySocial($social_uidId){
                 $stmt = $this->con->prepare("DELETE FROM `agc_social` WHERE `id`=?");
                $stmt->bind_param("s", $social_uidId);
                  if ($stmt->execute()) {
                         return 1;
                      }else {
                      return 2;
                }
           }
           
           public function getPrefixDetails($policeId){
               // Check if the input string has at least 4 characters
                if (strlen($policeId) >= 4) {
                    return substr($policeId, 0, 4);
                } else {
                    return ""; // Return an empty string if the input is too short
                }
           }
           
            public function getDetailsByIdv1($policeId,$certificateId){
                 $stmt = $this->con->prepare("SELECT `Proprietaire` AS owner_police FROM `agc_contrat` WHERE `Numpol`=? AND `NumCertificat`=?");
                 $stmt->bind_param("ss", $policeId,$certificateId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['owner_police'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getDetailsByIdv2($policeId,$certificateId){
                 $stmt = $this->con->prepare("SELECT `Proprietaire` AS owner_police FROM `agc_contrat_ac` WHERE `Numpol`=? AND `Numnoteprime`=?");
                 $stmt->bind_param("ss", $policeId,$certificateId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['owner_police'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
             public function getDetailsByIdv3($policeId,$certificateId){
                 $stmt = $this->con->prepare("SELECT `Proprietaire` AS owner_police FROM `agc_contrat_fire` WHERE `Numpol`=? AND `NumCertificat`=?");
                 $stmt->bind_param("ss", $policeId,$certificateId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['owner_police'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getDetailsByIdv4($policeId,$certificateId){
                 $stmt = $this->con->prepare("SELECT `Proprietaire` AS owner_police FROM `agc_contrat_marine` WHERE `Numpol`=? AND `NumCertificat`=?");
                 $stmt->bind_param("ss", $policeId,$certificateId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['owner_police'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getDetailsByIdv5($policeId,$certificateId){
                 $stmt = $this->con->prepare("SELECT `Proprietaire` AS owner_police FROM `agc_contrat_rc` WHERE `Numpol`=? AND `NumCertificat`=?");
                 $stmt->bind_param("ss", $policeId,$certificateId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['owner_police'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getUpdtv1($policeId,$certificateId,$proprio_Id,$user_Id){
                $stat = 1;
                   $stmt = $this->con->prepare("UPDATE `agc_contrat` SET `owner_id`=?  WHERE `Numpol`=? AND `NumCertificat`=? AND `Proprietaire`=? AND `facturation`=?");
                    $stmt->bind_param("sssss", $user_Id,$policeId,$certificateId,$proprio_Id,$stat);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getUpdtv2($policeId,$certificateId,$proprio_Id,$user_Id){
                $stat = 1;
                   $stmt = $this->con->prepare("UPDATE `agc_contrat_ac` SET `owner_id`=?  WHERE `Numpol`=? AND `Numnoteprime`=? AND `Proprietaire`=? AND `facturation`=?");
                    $stmt->bind_param("sssss", $user_Id,$policeId,$certificateId,$proprio_Id,$stat);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getUpdtv3($policeId,$certificateId,$proprio_Id,$user_Id){
                $stat = 1;
                   $stmt = $this->con->prepare("UPDATE `agc_contrat_fire` SET `owner_id`=?  WHERE `Numpol`=? AND `NumCertificat`=? AND `Proprietaire`=? AND `facturation`=?");
                    $stmt->bind_param("sssss", $user_Id,$policeId,$certificateId,$proprio_Id,$stat);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getUpdtv4($policeId,$certificateId,$proprio_Id,$user_Id){
                $stat = 1;
                   $stmt = $this->con->prepare("UPDATE `agc_contrat_marine` SET `owner_id`=?  WHERE `Numpol`=? AND `NumCertificat`=? AND `Proprietaire`=? AND `facturation`=?");
                    $stmt->bind_param("sssss", $user_Id,$policeId,$certificateId,$proprio_Id,$stat);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getUpdtv5($policeId,$certificateId,$proprio_Id,$user_Id){
                $stat = 1;
                   $stmt = $this->con->prepare("UPDATE `agc_contrat_rc` SET `owner_id`=?  WHERE `Numpol`=? AND `NumCertificat`=? AND `Proprietaire`=? AND `facturation`=?");
                    $stmt->bind_param("sssss", $user_Id,$policeId,$certificateId,$proprio_Id,$stat);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getCertificateValues($prefix,$stat_Id){
                  $stmt = $this->con->prepare("SELECT Certificat AS certificate_Id FROM `agc_certificat` WHERE `Id` = (SELECT MAX(Id) FROM `agc_certificat` WHERE `produit`=? AND `Status`=?)");
                     $stmt->bind_param("ss",$prefix,$stat_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['certificate_Id'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
            }
            
            public function getNotePrimeValues($prefix,$stat_Id){
                  $stmt = $this->con->prepare("SELECT NotePrime AS notprime_Id FROM `agc_notprime` WHERE `Id` = (SELECT MAX(Id) FROM `agc_notprime` WHERE `produit`=? AND `Status`=?)");
                     $stmt->bind_param("ss",$prefix,$stat_Id);
                    $stmt->execute();
                    $result = $stmt->get_result();
        
                    if ($result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        return  $row['notprime_Id'];
                    } else {
                        $giss_getVar = 'N/A';
                        return $giss_getVar;
                } 
            }
            
            public function getPoliceValues($insuranceId){
              $stmt = $this->con->prepare("SELECT *  FROM `agc_contrat` WHERE `Id`=?");
              $stmt->bind_param("s",$insuranceId);
              $stmt->execute();
             return $stmt->get_result()->fetch_assoc();
            }
            
            public function getUpdtSelfBuy($var_certificat,$userId,$var_userCode,$police,$proprietaire){
                   $stmt = $this->con->prepare("UPDATE `agc_contrat` SET `owner_id`=?  WHERE `Numpol`=? AND `NumCertificat`=? AND `Proprietaire`=? AND `user_code`=?");
                    $stmt->bind_param("sssss", $userId,$police,$var_certificat,$proprietaire,$var_userCode);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getMyCartPending($status_var,$payer_Id){
                $stmt = $this->con->prepare("SELECT * FROM agc_purchase WHERE `doneby` =? AND `op_status` = ? ORDER BY `id` DESC");
                $stmt->bind_param("ss",$payer_Id,$status_var);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
            public function getMyCartProcessed($payer_Id){
                $stmt = $this->con->prepare("SELECT * FROM agc_purchase WHERE `doneby` = ? AND `op_status` IN (1, 2, 4)  ORDER BY `id` DESC");
                $stmt->bind_param("s",$payer_Id);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
            public function getMyAutov2No($userId){
                 $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `agc_contrat` WHERE `owner_id`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE()");
                  $stmt->bind_param("s",$userId);
                $stmt->execute();
                $result = $stmt->get_result();
    
                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    return $row['total_balance'];
                } else {
                    $giss_getVar = 0;
                    return $giss_getVar;
                }
            }
            
            public function getMyAutoFina($user_agence){
                $stmt = $this->con->prepare("SELECT * FROM `agc_contrat` WHERE `owner_id`=? AND DateEmission BETWEEN DATE(CONCAT(YEAR(CURDATE()), '-01-01')) AND CURDATE() ORDER BY `Id` DESC");
                $stmt->bind_param("s", $user_agence);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
                return $data;
            }
            
            public function getCardDetails($userId) {
                $stmt = $this->con->prepare("SELECT * FROM agc_card_payment WHERE `AccOwnerId`=?");
                $stmt->bind_param("s", $userId);
                $stmt->execute();
                $result = $stmt->get_result();
        
                if ($result->num_rows > 0) {
                    return $result->fetch_assoc();  
                } else {
                    return null;  
                }
            }
            
            public function getCardAccValues($payer_Id){
              $stmt = $this->con->prepare("SELECT *  FROM `agc_card_payment` WHERE `AccOwnerId`=?");
              $stmt->bind_param("s",$payer_Id);
              $stmt->execute();
             return $stmt->get_result()->fetch_assoc();
            }
            
            public function getPaymentUpdCard($order_Id,$payment,$PayerName,$cardNumber,$cardName){
               $stmt = $this->con->prepare("UPDATE `agc_purchase` SET `payment`=?,`payer_name`=?,`card_number`=?,`card_name`=? WHERE `id`=?");
                    $stmt->bind_param("sssss", $payment,$PayerName,$cardNumber,$cardName,$order_Id);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
             public function getPayAccQrUpdCard($cardId,$codeKey){
               $stmt = $this->con->prepare("UPDATE `agc_card_payment` SET `qrCard`=? WHERE `id`=?");
                    $stmt->bind_param("ss", $codeKey,$cardId);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getPayAccBalUpdCard($cardId,$cardRemain){
               $stmt = $this->con->prepare("UPDATE `agc_card_payment` SET `balance`=? WHERE `id`=?");
                    $stmt->bind_param("ss", $cardRemain,$cardId);
                      if ($stmt->execute()) {
                             return 1;
                     }else {
                   return 2;
               } 
            }
            
            public function getCartCardPending($payer_Id){
                $card = "Card";
                $stmt = $this->con->prepare("SELECT * FROM agc_purchase WHERE `agence_id` =? AND `payment`=? AND `op_status` IN (2, 3) ORDER BY `id` DESC");
                $stmt->bind_param("ss",$payer_Id,$card);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
            public function getCardTrx($payer_Id){
                $card = "Card";
                $stmt = $this->con->prepare("SELECT * FROM agc_purchase WHERE `agence_id` = ? AND `payment`=? AND `op_status` IN (1, 2, 4)  ORDER BY `id` DESC");
                $stmt->bind_param("ss",$payer_Id,$card);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
              public function getCartCardProcessed($payer_Id){
                 $card = "Card";
                 $cardv1 = "APPROVED";
                $stmt = $this->con->prepare("SELECT * FROM agc_purchase WHERE `agence_id` = ? AND `payment`=? AND `callback_trxStatus`=? AND `op_status` IN (1, 2, 4)  ORDER BY `id` DESC");
                $stmt->bind_param("sss",$payer_Id,$card,$cardv1);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
            public function getCartCardCanceled($payer_Id){
                 $card = "Card";
                 $cardv1 = "CANCELED";
                $stmt = $this->con->prepare("SELECT * FROM agc_purchase WHERE `agence_id` = ? AND `payment`=? AND `callback_trxStatus`=? AND `op_status` IN (1, 2, 4)  ORDER BY `id` DESC");
                $stmt->bind_param("sss",$payer_Id,$card,$cardv1);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
            public function getCardTrxCust($payer_Id){
                $card = "Card";
                $stmt = $this->con->prepare("SELECT * FROM agc_purchase WHERE `doneby` = ? AND `payment`=? AND `op_status` IN (1, 2, 4)  ORDER BY `id` DESC");
                $stmt->bind_param("ss",$payer_Id,$card);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
            public function getCartCardProcessedCust($payer_Id){
                 $card = "Card";
                 $cardv1 = "APPROVED";
                $stmt = $this->con->prepare("SELECT * FROM agc_purchase WHERE `doneby` = ? AND `payment`=? AND `callback_trxStatus`=? AND `op_status` IN (1, 2, 4)  ORDER BY `id` DESC");
                $stmt->bind_param("sss",$payer_Id,$card,$cardv1);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
            
            public function getCartCardCanceledCust($payer_Id){
                 $card = "Card";
                 $cardv1 = "CANCELED";
                $stmt = $this->con->prepare("SELECT * FROM agc_purchase WHERE `doneby` = ? AND `payment`=? AND `callback_trxStatus`=? AND `op_status` IN (1, 2, 4)  ORDER BY `id` DESC");
                $stmt->bind_param("sss",$payer_Id,$card,$cardv1);
                $stmt->execute();
                $result = $stmt->get_result();
                $data = array();
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            
                return $data;
            }
        
 }
?>