<?php
session_start();
require_once('../includes/DbOperations.php');

$resp_data = array();
$Sign = 2;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   
   if (!isset($_POST['btnPostDataThroughMEdiaboXEndPoint'])) {
      http_response_code(400); // Bad Request
      $resp_data['error'] = 'Required field(s) are missing';
      echo json_encode($resp_data);
      return;
   }

   $mobic_ProId = $_POST['idProprio'];
   
   $db = new DbOperations();

   if (!$db->mobicMediaboxPsr($mobic_ProId)) {
      http_response_code(404); // Not Found
      $resp_data['error'] = 'Invalid Proprio';
      echo json_encode($resp_data);
      return;
   }

   $user = $db->getProprioById($mobic_ProId);

   // Process Data
   $resp_data['result'] = array(
      'NUMERO_PLAQUE'    => $user['NUMERO_PLAQUE'],
      'NUMERO_ASSURANCE' => $user['NUMERO_ASSURANCE'],
      'NOM_PROPRIETAIRE' => $user['NOM_PROPRIETAIRE'],
      'DATE_DEBUT'       => $user['DATE_DEBUT'],
      'DATE_VALIDITE'    => $user['DATE_VALIDITE'],
      'PLACES_ASSURES'   => $user['PLACES_ASSURES'],
      'TYPE_ASSURANCE'   => $user['TYPE_ASSURANCE']
   );

   // Send Data to Endpoint
   $ch = curl_init('https://prodev.mediabox.bi:25250/psr/assurances');
  //  $ch = curl_init('http://app.mediabox.bi:2522/psr/assurances');
   
   $token = $db->getTokenBySignIn();

   if(empty($token)) {
      http_response_code(401); // Unauthorized
      $resp_data['error'] = 'Invalid Token';
      echo json_encode($resp_data);
      return;
   }

   $authorization = 'Authorization: Bearer '. $token; 
   $post = json_encode($resp_data['result']);
   curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json' , $authorization )); 
   curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
   curl_setopt($ch, CURLOPT_POST, 1); 
   curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
   curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
   
   $result = curl_exec($ch);
   curl_close($ch);

   if(!$result) {
      http_response_code(500); // Internal Server Error
      $resp_data['error'] = 'Error processing request';
      echo json_encode($resp_data);
      return;
   }
  
   //http_response_code(200); // OK
   //echo $result;
      // If the API returns HTTP 200 status code
      if ( http_response_code() == 200 ) {
        // Get the feedback from getPsrSign function
        $feedBack = $db->getPsrSign($Sign,$mobic_ProId);
        // Check if the return value is 1 or 2 and update the response accordingly
        if ( $feedBack == 1 ) {
            //echo 'Success: Update and API'.$result;
            $_SESSION['success'] = "Success: Update and API".$result;
            header('Location: ../../main-mediabox-api');
        } else if ( $feedBack == 2 ) {
            $resp_data['error'] = 'Error';
        }
      } else {
        $resp_data['error'] = 'API Error';
      }

}
?>





<?php
/*require_once('../includes/DbOperations.php');

// Set default response status and message
$response = array(
  'status' => false,
  'message' => 'Something went wrong'
);
$Sign = 2;
// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  // Check if the required parameter is set
  if ( isset($_POST['btnPostDataThroughMEdiaboXEndPoint']) ) {
    // Get the property ID from POST data
    $mobic_ProId = $_POST['idProprio'];

    // Initialize DbOperations object
    $db = new DbOperations();

    // Check if the given property ID is valid
    if ( $db->mobicMediaboxPsr($mobic_ProId) ) {
      // Get the proprietor's details by ID
      $user = $db->getProprioById($mobic_ProId);
      
      // Prepare the response data
      $response_data = array(
        "NUMERO_PLAQUE" => $user['NUMERO_PLAQUE'],
        "NUMERO_ASSURANCE" => $user['NUMERO_ASSURANCE'],
        "NOM_PROPRIETAIRE" => $user['NOM_PROPRIETAIRE'],
        "DATE_DEBUT" => $user['DATE_DEBUT'],
        "DATE_VALIDITE" => $user['DATE_VALIDITE'],
        "PLACES_ASSURES" => $user['PLACES_ASSURES'],
        "TYPE_ASSURANCE" => $user['TYPE_ASSURANCE']
      );

      // Send the data to the Mediabox endpoint
      $ch = curl_init('http://app.mediabox.bi:2522/psr/assurances');
      $token = $db->getTokenBySignIn();
      if (!empty($token)) {
        $post = json_encode([$response_data]);
        $authorization = "Authorization: Bearer ".$token; 
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json' , $authorization )); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, 1); 
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
        $result = curl_exec($ch);
        curl_close($ch);
        // If the API returns HTTP 200 status code
        if ( http_response_code() == 200 ) {
          // Get the feedback from getPsrSign function
          $feedBack = $db->getPsrSign($Sign,$mobic_ProId);
          // Check if the return value is 1 or 2 and update the response accordingly
          if ( $feedBack == 1 ) {
            $response['status'] = true;
            $response['message'] = 'Success: Update and API'.$result;
          } else if ( $feedBack == 2 ) {
            $response['message'] = 'Error';
          }
        } else {
          $response['message'] = 'API Error';
        }
      } else {
        // If the token is invalid or empty
        $response['message'] = 'Invalid Token';
      } 
    } else {
      $response['message'] = 'Invalid Proprio';
    }             
  } else {
    $response['message'] = 'Required fields are missing';
  }
}

// Return the final response as JSON
echo json_encode( $response );*/
?>



<?php
/*
require_once('../includes/DbOperations.php');
$resp_data['result'] = array();
if ($_SERVER['REQUEST_METHOD']=='POST'){
   if ( isset($_POST['btnPostDataThroughMEdiaboXEndPoint'])){
         // operation getElement
         $mobic_ProId = $_POST['idProprio'];
         $db = new DbOperations();
         if($db->mobicMediaboxPsr($mobic_ProId)){
            $user = $db->getProprioById($mobic_ProId);
           
            array_push($resp_data['result'], array(
                "NUMERO_PLAQUE"    => $user['NUMERO_PLAQUE'],
                "NUMERO_ASSURANCE" => $user['NUMERO_ASSURANCE'],
                "NOM_PROPRIETAIRE" => $user['NOM_PROPRIETAIRE'],
                "DATE_DEBUT"       => $user['DATE_DEBUT'],
                "DATE_VALIDITE"    => $user['DATE_VALIDITE'],
                "PLACES_ASSURES"   => $user['PLACES_ASSURES'],
                "TYPE_ASSURANCE"   => $user['TYPE_ASSURANCE']
               ));
        
              // echo json_encode($resp_data['result']);
               $ch = curl_init('http://app.mediabox.bi:2522/psr/assurances');
               $token = $db->getTokenBySignIn();
              if (!empty($token)) {
               $post = json_encode($resp_data['result']);
               $authorization = "Authorization: Bearer ".$token; 
               curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json' , $authorization )); 
               curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
               curl_setopt($ch, CURLOPT_POST, 1); 
               curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
               curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
               $result = curl_exec($ch);
               curl_close($ch);
               echo json_encode($result);
            }else {
               
                $_SESSION['stata'] = "Invalid Token";
                header('Location: main-mediabox-api');
            } 

         }else {
            
            $_SESSION['stata'] = "Invalid Proprio";
            header('Location: main-mediabox-api');
        }             
   }else {
     $_SESSION['stata'] = "Required fields are missing";
    header('Location: main-mediabox-api');
   }
}

*/
?>