<?php
     class DbOperations
        {
            private $con;

            function __construct(){
                require_once dirname(__FILE__).'/DbConnect.php';
                $db = new DbConnect();

                $this->con = $db->connect();
            }
            /* CRUD -> c -> Create */
            public function mobicMediaboxPsr($mobic_ProId){
                $stmt = $this->con->prepare("SELECT id FROM `agc_agicoplus_psr` WHERE `id`=?");
                $stmt->bind_param("s",$mobic_ProId);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
            public function getProprioById($mobic_ProId){
                $stmt = $this->con->prepare("SELECT DateEffet AS DATE_DEBUT, DateEcheance AS DATE_VALIDITE, NumCertificat AS NUMERO_ASSURANCE, Plaque AS NUMERO_PLAQUE, PaleSeatCabine AS PLACES_ASSURES, UsageAuto AS TYPE_ASSURANCE, Proprietaire AS NOM_PROPRIETAIRE  FROM `agc_agicoplus_psr` WHERE `id`=?");
                $stmt->bind_param("s",$mobic_ProId);
                $stmt->execute();
                return $stmt->get_result()->fetch_array();
            }

            public function getTokenBySignIn(){
                $data = array(
                    'email'=>'bic@psr.bi',
                    'password'=>'bic@#_//**12'
                   );
                //    $data = array(
                //     'email'=>'nyamietienne@gmail.com',
                //     'password'=>'42b8db@2023'
                //    );
                $ch = curl_init('https://prodev.mediabox.bi:25250/users/login');
                // $ch = curl_init('http://app.mediabox.bi:2522/users/login');
                $post = json_encode($data);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, 1); 
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
                $result = curl_exec($ch);
                curl_close($ch);
                $access_token = json_decode($result);
                return $access_token->TOKEN;
            }

            public function getPsrSign($Sign,$mobic_ProId){
                $dateSend = date("Y-m-d");
                $stmt = $this->con->prepare("UPDATE `agc_agicoplus_psr` SET `psr`=?,`dateSend`=? WHERE `id`=?");
                $stmt->bind_param("sss", $Sign,$dateSend,$mobic_ProId);
                if ($stmt->execute()) {
                return 1;
                }else {
                 return 2;
                }
            }


            public function mobicProcessAPI($bic_idPro){
                $stmt = $this->con->prepare("SELECT id FROM `agc_mediabox_psr` WHERE `id`=?");
                $stmt->bind_param("s",$bic_idPro);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }

           public function getProcess($bic_idPro){
                $stmt = $this->con->prepare("SELECT *  FROM `agc_mediabox_psr` WHERE `id`=?");
                $stmt->bind_param("s",$bic_idPro);
                $stmt->execute();
                return $stmt->get_result()->fetch_assoc();
            }

            public function getProcessContr($varPSR,$dateSentVal,$factureVal){
                if ($this->isContractExist($factureVal)) {
                    $stmt = $this->con->prepare("UPDATE `agc_contrat` SET `psr`=?,`psr_date`=? WHERE `facture`=?");
                    $stmt->bind_param("sss", $varPSR,$dateSentVal,$factureVal);
                    if ($stmt->execute()) {
                        return 1;
                    }else {
                        return 2;
                    }
                  
                }else {
           
                    return 0;
                }
            }

            private function isContractExist($factureVal){
                $stmt = $this->con->prepare("SELECT `Id` FROM `agc_contrat` WHERE `facture`=?");
                $stmt->bind_param("s", $factureVal);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }

            public function getMediaboxProcessed($varPSR,$bic_idPro){
                $stmt = $this->con->prepare("UPDATE `agc_mediabox_psr` SET `psr_pro`=? WHERE `id`=?");
                $stmt->bind_param("ss", $varPSR,$bic_idPro);
                if ($stmt->execute()) {
                return 1;
                }else {
                 return 2;
                }
            }


        }
 ?>