<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../includes/Developers.php';

$response = array();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Validate all required POST parameters
    $requiredFields = ['userUid', 'ass_id', 'category'];
    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            $response['error'] = true;
            $response['message'] = "Missing required field";
            echo json_encode($response);
            exit;
        }
    }

    // Sanitize input
    $payer_Id = trim($_POST['userUid']);
    $assurance_Id = trim($_POST['ass_id']);
    $proCategory  = trim($_POST['category']);
    // Validate quantity
    $qtyBought = 1; // Static or fetched as needed
    if ($qtyBought <= 0) {
        $response['error'] = true;
        $response['message'] = "La quantité doit être supérieure à 0";
        echo json_encode($response);
        exit;
    }

    $db = new Developers();
    $var_date = date("Y-m-d");
    $var_time = date("H:i:s");
    $CompanyAccId = 11; // Static or fetched as needed
    

    // Fetch buyer account details
    $buyerQuery = $db->getBuyerUidv1($payer_Id);
    if (!$buyerQuery || !isset($buyerQuery['Id'], $buyerQuery['img'], $buyerQuery['fullname'], $buyerQuery['username'], $buyerQuery['contact'])) {
        $response['error'] = true;
        $response['message'] = "Compte introuvable.";
        echo json_encode($response);
        exit;
    }
    
 
    // Extract buyer details
    $myAccId = $buyerQuery['Id'];
    $myAccImg = $buyerQuery['img'];
    $myFullName = $buyerQuery['fullname'];
    
    //Initiate local var
    //$proCategory = "Ass_Automobile"; // Static or fetched as needed
    //$productName = "Ass. Automobile"; // Static or fetched as needed

    // Fetch buyer contact number
    $buyerAccountNo = $db->getBuyerAccountNo($payer_Id);
    if (!$buyerAccountNo || !isset($buyerAccountNo['AccountNo'])) {
        $response['error'] = true;
        $response['message'] = "Compte de paiement introuvable et/ou n'est pas configurer.";
        echo json_encode($response);
        exit;
    }
    $myAcccontact = $buyerAccountNo['AccountNo'];
    
    
    
    if ($proCategory === "Ass_Automobile") {
        
         // Process each police
    
         for ($i = 0; $i < $qtyBought; $i++) {
        $j = 1; // Assuming this is a static value
        $ins = 2;
        $op_reference_v1 = $db->getPinCodeNumber(10, false, false, true);
        $op_reference_v2 = $db->getMixedRandomId(4, false, true, true);
        $op_reference = $op_reference_v2.$op_reference_v1;
        $op_key = $db->getNumberLevPinNo(5, false, false, true);
        
        // Purchase police
        $police_qrv2 = $db->getPoliceAchatInitiated(
            $op_key,
            $assurance_Id,
            $db->getContrIdPol($assurance_Id),
            $db->getInvoiceIdPol($assurance_Id),
            $db->getSellerId($assurance_Id),
            $db->getProprio($assurance_Id),
            $db->getSellerAccNumber($CompanyAccId),
            $db->getSellerAccName($CompanyAccId),
             $myAcccontact,
            $j,
            $db->getPolBalance($assurance_Id),
            $proCategory,
            $db->getIdPolice($assurance_Id),
            $op_reference,
            $var_date,
            $var_time,
            $payer_Id
        );

        if ($police_qrv2 != 1) {
            $response['error'] = true;
            $response['message'] = "La police est deja initie et/ou il'y a erreur lors de l'initiation du paiement";
            echo json_encode($response);
            exit;
        }
        
        $contact_qrv3 = $db->getPoliceUpgraded(
            $assurance_Id,
            $ins
        );

        if ($contact_qrv3 != 1) {
            $response['error'] = true;
            $response['message'] = "Il'y a erreur lors de l'initiation du paiement";
            echo json_encode($response);
            exit;
        } 

    }
        
        
    } elseif ($proCategory === "Ass_Transport") {
        
         // Process each police
    
         for ($i = 0; $i < $qtyBought; $i++) {
        $j = 1; // Assuming this is a static value
        $ins = 2;
        $op_reference_v1 = $db->getPinCodeNumber(10, false, false, true);
        $op_reference_v2 = $db->getMixedRandomId(4, false, true, true);
        $op_reference = $op_reference_v2.$op_reference_v1;
        $op_key = $db->getNumberLevPinNo(5, false, false, true);
        
        // Purchase police
        $police_qrv2 = $db->getPoliceAchatInitiated(
            $op_key,
            $assurance_Id,
            $db->getTRContrIdPol($assurance_Id),
            $db->getTRInvoiceIdPol($assurance_Id),
            $db->getTRSellerId($assurance_Id),
            $db->getTRProprio($assurance_Id),
            $db->getSellerAccNumber($CompanyAccId),
            $db->getSellerAccName($CompanyAccId),
             $myAcccontact,
            $j,
            $db->getTRPolBalance($assurance_Id),
            $proCategory,
            $db->getTRIdPolice($assurance_Id),
            $op_reference,
            $var_date,
            $var_time,
            $payer_Id
        );

        if ($police_qrv2 != 1) {
            $response['error'] = true;
            $response['message'] = "La police est deja initie et/ou il'y a erreur lors de l'initiation du paiement";
            echo json_encode($response);
            exit;
        }
        
        $contact_qrv3 = $db->getTRPoliceUpgraded(
            $assurance_Id,
            $ins
        );

        if ($contact_qrv3 != 1) {
            $response['error'] = true;
            $response['message'] = "Il'y a erreur lors de l'initiation du paiement";
            echo json_encode($response);
            exit;
        } 

    }
        
    } elseif ($proCategory === "Ass_Accident") {
       
       // Process each police
    
         for ($i = 0; $i < $qtyBought; $i++) {
        $j = 1; // Assuming this is a static value
        $ins = 2;
        $op_reference_v1 = $db->getPinCodeNumber(10, false, false, true);
        $op_reference_v2 = $db->getMixedRandomId(4, false, true, true);
        $op_reference = $op_reference_v2.$op_reference_v1;
        $op_key = $db->getNumberLevPinNo(5, false, false, true);
        
        // Purchase police
        $police_qrv2 = $db->getPoliceAchatInitiated(
            $op_key,
            $assurance_Id,
            $db->getACContrIdPol($assurance_Id),
            $db->getACInvoiceIdPol($assurance_Id),
            $db->getACSellerId($assurance_Id),
            $db->getACProprio($assurance_Id),
            $db->getSellerAccNumber($CompanyAccId),
            $db->getSellerAccName($CompanyAccId),
             $myAcccontact,
            $j,
            $db->getACPolBalance($assurance_Id),
            $proCategory,
            $db->getACIdPolice($assurance_Id),
            $op_reference,
            $var_date,
            $var_time,
            $payer_Id
        );

        if ($police_qrv2 != 1) {
            $response['error'] = true;
            $response['message'] = "La police est deja initie et/ou il'y a erreur lors de l'initiation du paiement";
            echo json_encode($response);
            exit;
        }
        
        $contact_qrv3 = $db->getACPoliceUpgraded(
            $assurance_Id,
            $ins
        );

        if ($contact_qrv3 != 1) {
            $response['error'] = true;
            $response['message'] = "Il'y a erreur lors de l'initiation du paiement";
            echo json_encode($response);
            exit;
        } 

    }
       
    }  elseif ($proCategory === "Ass_Incendie") {
        
        // Process each police
    
         for ($i = 0; $i < $qtyBought; $i++) {
        $j = 1; // Assuming this is a static value
        $ins = 2;
        $op_reference_v1 = $db->getPinCodeNumber(10, false, false, true);
        $op_reference_v2 = $db->getMixedRandomId(4, false, true, true);
        $op_reference = $op_reference_v2.$op_reference_v1;
        $op_key = $db->getNumberLevPinNo(5, false, false, true);
        
        // Purchase police
        $police_qrv2 = $db->getPoliceAchatInitiated(
            $op_key,
            $assurance_Id,
            $db->getINCContrIdPol($assurance_Id),
            $db->getINCInvoiceIdPol($assurance_Id),
            $db->getINCSellerId($assurance_Id),
            $db->getINCProprio($assurance_Id),
            $db->getSellerAccNumber($CompanyAccId),
            $db->getSellerAccName($CompanyAccId),
             $myAcccontact,
            $j,
            $db->getINCPolBalance($assurance_Id),
            $proCategory,
            $db->getINCIdPolice($assurance_Id),
            $op_reference,
            $var_date,
            $var_time,
            $payer_Id
        );

        if ($police_qrv2 != 1) {
            $response['error'] = true;
            $response['message'] = "La police est deja initie et/ou il'y a erreur lors de l'initiation du paiement";
            echo json_encode($response);
            exit;
        }
        
        $contact_qrv3 = $db->getINCPoliceUpgraded(
            $assurance_Id,
            $ins
        );

        if ($contact_qrv3 != 1) {
            $response['error'] = true;
            $response['message'] = "Il'y a erreur lors de l'initiation du paiement";
            echo json_encode($response);
            exit;
        } 

    }
        
    } elseif ($proCategory === "Ass_Respons_Civile") {
        
        // Process each police
    
         for ($i = 0; $i < $qtyBought; $i++) {
        $j = 1; // Assuming this is a static value
        $ins = 2;
        $op_reference_v1 = $db->getPinCodeNumber(10, false, false, true);
        $op_reference_v2 = $db->getMixedRandomId(4, false, true, true);
        $op_reference = $op_reference_v2.$op_reference_v1;
        $op_key = $db->getNumberLevPinNo(5, false, false, true);
        
        // Purchase police
        $police_qrv2 = $db->getPoliceAchatInitiated(
            $op_key,
            $assurance_Id,
            $db->getRCContrIdPol($assurance_Id),
            $db->getRCInvoiceIdPol($assurance_Id),
            $db->getRCSellerId($assurance_Id),
            $db->getRCProprio($assurance_Id),
            $db->getSellerAccNumber($CompanyAccId),
            $db->getSellerAccName($CompanyAccId),
             $myAcccontact,
            $j,
            $db->getRCPolBalance($assurance_Id),
            $proCategory,
            $db->getRCIdPolice($assurance_Id),
            $op_reference,
            $var_date,
            $var_time,
            $payer_Id
        );

        if ($police_qrv2 != 1) {
            $response['error'] = true;
            $response['message'] = "La police est deja initie et/ou il'y a erreur lors de l'initiation du paiement";
            echo json_encode($response);
            exit;
        }
        
        $contact_qrv3 = $db->getRCPoliceUpgraded(
            $assurance_Id,
            $ins
        );

        if ($contact_qrv3 != 1) {
            $response['error'] = true;
            $response['message'] = "Il'y a erreur lors de l'initiation du paiement";
            echo json_encode($response);
            exit;
        } 

    }
        
    }else {
        // Default action for unknown categories
        $response['error'] = true;
        $response['message'] = "Category not recognized. Perform default action.";
    }


   

    $response['error'] = false;
    $response['message'] = "Police ajoutés au panier avec succès. Continuer pour payer.";
} else {
    $response['error'] = true;
    $response['message'] = "Méthode de requête non prise en charge.";
}

echo json_encode($response);
?>
