<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../includes/Developers.php';

$response = array();

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        $response['error'] = true;
        $response['message'] = "Méthode de requête invalide. Veuillez utiliser POST.";
        echo json_encode($response);
        exit;
    }
    
    // 'autoValeurAssure','typePayment', 'assGaranti','assPrimeNet',
    
    $requiredFields = [
        'assur_preneurId', 'assur_preneurFirst','assur_preneurSecond','assur_catPreneur', 'assur_police','assur_note_Prme', 'assur_effet','assur_echeance', 'assur_emballage', 'assur_voie',
        'assur_transit', 'assur_numeroFacture','assur_dateFacture', 'assur_detailArticle','assur_portOrigine', 'assur_portDestination','assur_currencyDevise', 'assur_valeurDevise', 'assur_tauxChange', 
        'assur_garanti', 'assur_taux_Cotation', 'assur_valeurAssurerObj', 'assur_payment','assur_responsable','ass_user_fullname', 'ass_agence_name', 'ass_username', 'ass_user_code'
    ];
    
    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            $response['error'] = true;
            $response['message'] = "Champ obligatoire manquant : $field";
            echo json_encode($response);
            exit;
        }
    }
    
    // Extract and sanitize input data
    $client_Id   = $_POST['assur_preneurId'];
    $AssProprio   = $_POST['assur_preneurFirst'];
    $AssProprioSec   = $_POST['assur_preneurSecond'];
    $AssClientCategory   = $_POST['assur_catPreneur'];
    $AssVarPolice   = $_POST['assur_police'];
    $AssVarNotePrime   = $_POST['assur_note_Prme'];
    $AssEffet   = $_POST['assur_effet'];
    $AssEcheance   = $_POST['assur_echeance'];
    $AssEmballage   = $_POST['assur_emballage'];
    $AssTransVoie   = $_POST['assur_voie'];
    $AssTransTransit   = $_POST['assur_transit'];
    $AssInvoiceNo   = $_POST['assur_numeroFacture'];
    $AssDateInvoice   = $_POST['assur_dateFacture'];
    $AssDetaisMse   = $_POST['assur_detailArticle'];
    $AssPortStart   = $_POST['assur_portOrigine'];
    $AssPortEnd   = $_POST['assur_portDestination'];
    $AssCurrForeign   = $_POST['assur_currencyDevise'];
    $AssForeignBalance   = $_POST['assur_valeurDevise'];
    $AssRateChangeFromForeignCurr   = $_POST['assur_tauxChange'];
    $AssGaranty   = $_POST['assur_garanti'];
    $AssQuotationRate   = $_POST['assur_taux_Cotation'];
    $AssValAssurer   = $_POST['assur_valeurAssurerObj'];
    $AssTyPayment   = $_POST['assur_payment'];
    $SouscName   = $_POST['assur_responsable'];
    $fullname = $_POST['ass_user_fullname'];
    $SouscAgency   = $_POST['ass_agence_name'];
    $SouscUserName   = $_POST['ass_username'];
    $SouscUserId   = $_POST['ass_user_code'];
    
    $db = new Developers();
    $currentDate = date("Y-m-d");
    $currentTime = date("H:i:s");
    $date_operation = date("Y-m-d");
    $date_facture = date("Y-m-d h:i:s");
    $date_facture_signature = date("Ymdhis");
    $Year2 = date("y");
    
    // Get QR Code Unique Id
        $date = date("Ymd");   // Outputs: 20250404
        $time = date("His");   // Outputs: 112714
        $timestamp = time();
        $op_reference_v1 = $db->getPinCodeNumber(20, false, false, true);
        //$op_reference_v2 = $db->getMixedRandomId(4, false, true, true);
        //$op_reference = 'B'.$op_reference_v2.$op_reference_v1.'D'.$date.'T'.$time.'IC';
        $url_qr_reference = $op_reference_v1.$timestamp.'.'.$date.'.'.$time;
    
    // Fetch Client details
    $clientLogDetails = $db->GetClientValuesById($client_Id);
    if (!$clientLogDetails) {
        $response['error'] = true;
        $response['message'] = "Informations du client introuvable.";
        echo json_encode($response);
        exit;
    }

    $ClientName             = $clientLogDetails['Nomprenom'];
    $ClientNIF              = $clientLogDetails['Categorie'];
    $ClientPhone            = $clientLogDetails['Phone'];
    $ClientResidence        = $clientLogDetails['AddresResidence'];
    $clientProvince         = $clientLogDetails['province'];
    $clientPays             = $clientLogDetails['country'];
    $SouscAgence            = $clientLogDetails['Agence'];
    
     // Fetch Agence details
    $agencyLogDetails = $db->GetAgenceValuesByName($SouscAgency);
    if (!$agencyLogDetails) {
        $response['error'] = true;
        $response['message'] = "Informations de l'Agence introuvable.";
        echo json_encode($response);
        exit;
    }

    $AgenceId               = $agencyLogDetails['Id'];
    $AgenceAccount         = $agencyLogDetails['Compte'];
    $Motif = "Creation contrat Marchandise - Police [".$AssVarPolice."]";
    
    /*
    
       SELECT `Id`, `Numcontrat`, `id_contrat`, `Numpol`, `DateEmission`, `payment_date`, `DateEffet`, `DateEcheance`, `periode_cov`, 
       `facture`, `id_facture`, `NumCertificat`, `nature_marchandise`, `type_voie`, `type_transit`, `NumeroFacture`, `dateFActuration`,
       `natureEmballage`, `datailArticle`, `pays_port_origine`, `pays_port_destination`, `devise`, `valeur_devise`, `taux_de_change`, 
       `taux_cotation`, `preneur`, `Proprietaire`, `proprio_id`, `NIF`, `phone`, `residence`, `province`, `country`, `CatProprietaire`,
       `Garantie`, `valeur_assure`, `PN`, `RAB`, `FDSA`, `TF`, `FDIGITAL`, `ARCA`, `FAPS`, `FRAIS`, `CD`, `TVA`, `PB`, `Creator`, 
       `user_code`, `date`, `timeCreation`, `expiry_time`, `company_name`, `company_NIF`, `assurance`, `NotePrime`, `facturation`, 
       `tx_reference`, `cashtelTrxId`, `agence_id`, `agence`, `agence_account`, `renouvellement`, `control`, `situation`, 
       `cashier_situation`, `cashier_task`, `cashier_receipt`, `mode_payment`, `cashier_fullname`, `psr`, `psr_date`, `obr`, 
       `signature`, `date_signature`, `date_obr`, `commission`, `idcommussion`, `part_agence`, `part_company`, `username`, 
       `owner_id`, `detailsqrCode` FROM `agc_contrat_marine` WHERE 1
       
        
    */
    $var_agenceName = $SouscAgency;
    $var_username = $SouscUserName;
    
    //$AssValAssurer,$AssGaranty,$AssTyPayment,$AssPrimeNet getAutomobileV1
  
     $transport_ds = $db->getTransportDetailsV1($AssVarPolice,$AssEffet,$AssEcheance,$AssVarNotePrime,$AssTransVoie,$AssTransTransit,$AssInvoiceNo,
                                                $AssDateInvoice,$AssEmballage,$AssDetaisMse,$AssPortStart,$AssPortEnd,$AssCurrForeign,$AssForeignBalance,
                                                $AssRateChangeFromForeignCurr,$AssQuotationRate,$AssProprioSec,$AssProprio,$client_Id,$ClientName,
                                                $ClientNIF,$ClientPhone,$ClientResidence,$clientProvince,$clientPays,$AssClientCategory,$AssGaranty,
                                                $AssValAssurer,$AssTyPayment,$Year2,$SouscName,$fullname,$SouscUserId,$SouscAgency,$SouscUserName,
                                                $AgenceId,$AgenceAccount,$date_facture,$date_facture_signature,$url_qr_reference);
     if($transport_ds == 1){
        $response['error'] = false;
        $Query_1 = $db->getReport($Motif,$var_agenceName,$var_username,$date_operation);
      if($Query_1 == 1){
            $response['error'] = false;
            $response['message'] = "Le contrat est enregistré, continuer pour payer";
       }elseif($Query_1 == 2){
             $response['error'] = true;
             $response['message'] = "Une erreur s'est produite, veuillez réessayer ou contactez le service informatique";
        }
                      
       }elseif($transport_ds == 2){
            $response['error'] = true;
             $response['message'] = "Une erreur s'est produite. Veuillez réessayer ou contactez le service informatique";
        }elseif($transport_ds == 0){
              $response['error'] = true;
               $response['message'] = "Le contrat que vous souhaitez créer avec ce numero de police existe déjà";
         }elseif($transport_ds == 4){
                        $response['error'] = true;
                        $response['message'] = "Le contrat que vous souhaitez créer avec ce numero de note de prime existe déjà";
        }elseif($transport_ds == 5){
                        $response['error'] = true;
                        $response['message'] = "Le contrat que vous souhaitez créer avec ce numero de facture existe déjà";
        }
        
    echo json_encode($response);
?>