<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../includes/Developers.php';

$response = array();

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        $response['error'] = true;
        $response['message'] = "Méthode de requête invalide. Veuillez utiliser POST.";
        echo json_encode($response);
        exit;
    }
    
    // 'autoValeurAssure','typePayment', 'assGaranti','assPrimeNet',
    
    $requiredFields = [
        'assur_preneurId', 'assur_preneurFirst','assur_preneurSecond','assur_catPreneur', 'assur_police','assur_note_Prme', 'assur_effet','assur_echeance', 'assur_object', 'assur_qty',
        'assur_batiment', 'assur_usage','assur_prevention', 'assur_construct','assur_foncier', 'assur_parcel','assur_adresse', 'assur_authoriz', 'assur_nivoBuild', 
        'assur_responsable','ass_user_fullname', 'ass_agence_name', 'ass_username', 'ass_user_code'
    ];
    
    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            $response['error'] = true;
            $response['message'] = "Champ obligatoire manquant : $field";
            echo json_encode($response);
            exit;
        }
    }
    
    // Extract and sanitize input data
    $client_Id   = $_POST['assur_preneurId'];
    $AssProprio   = $_POST['assur_preneurFirst'];
    $AssProprioSec   = $_POST['assur_preneurSecond'];
    $AssClientCategory   = $_POST['assur_catPreneur'];
    $AssVarPolice   = $_POST['assur_police'];
    $AssVarNotePrime   = $_POST['assur_note_Prme'];
    $AssEffet   = $_POST['assur_effet'];
    $AssEcheance   = $_POST['assur_echeance'];
    $AssObject   = $_POST['assur_object'];
    $AssQty   = $_POST['assur_qty'];
    $AssBuilding   = $_POST['assur_batiment'];
    $AssUsage   = $_POST['assur_usage'];
    $AssPrevention   = $_POST['assur_prevention'];
    $AssConstruct   = $_POST['assur_construct'];
    $AssFoncier   = $_POST['assur_foncier'];
    $AssParcel   = $_POST['assur_parcel'];
    $AssAdresse   = $_POST['assur_adresse'];
    $AssAuthorized   = $_POST['assur_authoriz'];
    $AssNivoBuilding   = $_POST['assur_nivoBuild'];
   
    $SouscName   = $_POST['assur_responsable'];
    $fullname = $_POST['ass_user_fullname'];
    $SouscAgency   = $_POST['ass_agence_name'];
    $SouscUserName   = $_POST['ass_username'];
    $SouscUserId   = $_POST['ass_user_code'];
    
    $db = new Developers();
    
    $currentDate = date("Y-m-d");
    $currentTime = date("H:i:s");
    $date_operation = date("Y-m-d");
    $date_facture = date("Y-m-d h:i:s");
    $date_facture_signature = date("Ymdhis");
    $Year2 = date("y");
    
    // Get QR Code Unique Id
    
        $date = date("Ymd");   // Outputs: 20250404
        $time = date("His");   // Outputs: 112714
        $timestamp = time();
        $op_reference_v1 = $db->getPinCodeNumber(20, false, false, true);
        $url_qr_reference = $op_reference_v1.$timestamp.'.'.$date.'.'.$time;
    
    // Fetch Client details
    
    $clientLogDetails = $db->GetClientValuesById($client_Id);
    if (!$clientLogDetails) {
        $response['error'] = true;
        $response['message'] = "Informations du client introuvable.";
        echo json_encode($response);
        exit;
    }

    $ClientName             = $clientLogDetails['Nomprenom'];
    $ClientNIF              = $clientLogDetails['Categorie'];
    $ClientPhone            = $clientLogDetails['Phone'];
    $ClientResidence        = $clientLogDetails['AddresResidence'];
    $clientProvince         = $clientLogDetails['province'];
    $clientPays             = $clientLogDetails['country'];
    $SouscAgence            = $clientLogDetails['Agence'];
    
     // Fetch Agence details
    $agencyLogDetails = $db->GetAgenceValuesByName($SouscAgency);
    if (!$agencyLogDetails) {
        $response['error'] = true;
        $response['message'] = "Informations de l'Agence introuvable.";
        echo json_encode($response);
        exit;
    }

    $AgenceId               = $agencyLogDetails['Id'];
    $AgenceAccount         = $agencyLogDetails['Compte'];
    $Motif = "Creation contrat Marchandise - Police [".$AssVarPolice."]";
    
    /*
    
        SELECT `Id`, `Numcontrat`, `id_contrat`, `Numpol`, `DateEffet`, `DateEcheance`, `facture`, 
        `id_facture`, `NumCertificat`, `Garantie`, `valeur_assure`, `qty`, `type_batiment`, `usage`, `mode_prevention`, 
        `numeroTitreFoncier`, `numeroParcelle`, `situationGeo`, `numeroAutorisationBatir`, `modeConstruction`, `Proprietaire`, 
        `proprio_id`, `NIF`, `phone`, `residence`, `province`, `country`, `nombreNiveau`, `objet_assure`, `tauxCotation`, 
        `PN`, `RAB`, `FDSA`, `TF`, `FDIGITAL`, `ARCA`, `FAPS`, `FRAIS`, `CD`, `TVA`, `PB`, `Creator`, `user_code`, 
        `date`, `timeCreation`, `assurance`, `NotePrime`, `facturation`, `tx_reference`, `cashtelTrxId`, 
        `tx_date`, `tx_time`, `agence`, `renouvellement`, `control`, `situation`, `commission`, 
        `idcommussion`, `part_agence`, `part_company`, `username`, 
        `owner_id` FROM `agc_contrat_fire` 
        WHERE 1
    
    */
    
 
    $var_agenceName = $SouscAgency;
    $var_username = $SouscUserName;
    
    //$AssValAssurer,$AssGaranty,$AssTyPayment,$AssPrimeNet getAutomobileV1
  
    $incendie_ds = $db->getIncendieDetails($client_Id,$ClientName,$AssProprio,$ClientNIF,$ClientPhone,$ClientResidence,$clientProvince,$clientPays,$AssClientCategory,
                                            $AssVarPolice,$AssEffet,$AssEcheance,$AssVarNotePrime,$AssObject,$AssQty,$AssBuilding,$AssUsage,$AssPrevention,$AssConstruct,
                                            $AssFoncier,$AssParcel,$AssAdresse,$AssAuthorized,$AssNivoBuilding,$Year2,$SouscName,$SouscUserName,
                                            $SouscUserId,$SouscAgency,$AgenceId,$AgenceAccount,$date_facture,$date_facture_signature,$url_qr_reference);
     if($incendie_ds == 1){
        $response['error'] = false;
        $Query_1 = $db->getReport($Motif,$var_agenceName,$var_username,$date_operation);
      if($Query_1 == 1){
            $response['error'] = false;
            $response['message'] = "Le contrat est enregistré, continuer et ajouter des garentis";
       }elseif($Query_1 == 2){
             $response['error'] = true;
             $response['message'] = "Une erreur s'est produite, veuillez réessayer ou contactez le service informatique";
        }
                      
       }elseif($incendie_ds == 2){
            $response['error'] = true;
             $response['message'] = "Une erreur s'est produite. Veuillez réessayer ou contactez le service informatique";
        }elseif($incendie_ds == 0){
              $response['error'] = true;
               $response['message'] = "Le contrat que vous souhaitez créer avec ce numero de police existe déjà";
        }elseif($incendie_ds == 4){
               $response['error'] = true;
               $response['message'] = "Le contrat que vous souhaitez créer avec ce numero de note de prime existe déjà";
        }elseif($incendie_ds == 5){
             $response['error'] = true;
             $response['message'] = "Le contrat que vous souhaitez créer avec ce numero de titre existe déjà";
        }
        
    echo json_encode($response);
?>