<?php
 header('Content-Type: application/json; charset=utf-8');
 require_once('../includes/Developers.php');
$response = array();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!empty($_GET['user_id']) && !empty($_GET['receiver_id'])) {
        // Sanitize input to prevent SQL injection
        $userId = intval($_GET['user_id']);
        $friends_id = intval($_GET['receiver_id']);

        // Database instance
        $db = new Developers();

        // Fetch chat details
        $chatDetails = $db->getChat($userId, $friends_id);

        // Check if chat data is retrieved
        if (!empty($chatDetails)) {
            $response = [
                'success' => true,
                'ChatMedia' => $chatDetails
            ];
        } else {
            $response = [
                'success' => true, // Keep success true but return an empty array
                'ChatMedia' => []
            ];
        }
    } else {
        $response = [
            'success' => false,
            'message' => 'Required parameters are missing'
        ];
    }
} else {
    $response = [
        'success' => false,
        'message' => 'Invalid request method'
    ];
}

// Send JSON response
//header('Content-Type: application/json');
echo json_encode($response);

?>