<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../includes/Developers.php';

$response = array();

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        $response['error'] = true;
        $response['message'] = "Méthode de requête invalide. Veuillez utiliser POST.";
        echo json_encode($response);
        exit;
    }
    
    // 'autoValeurAssure','typePayment', 'assGaranti','assPrimeNet',
    
    $requiredFields = [
        'preneurId', 'prenCategory','assProprio','assPolice', 'assCertificat','assNotePrime', 'assCatAutomobile','autoPlate', 'autoCatPlate', 'autoModelClass',
        'autoChassis', 'dateCarteRose','dateFabrication', 'autoPuissance','autoCabine', 'autoPlateau','autoUsage', 'assEffet', 'assCouverture', 
        'assEcheance', 'responsable', 'agence_name','username', 'user_code'
    ];
    
    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            $response['error'] = true;
            $response['message'] = "Champ obligatoire manquant : $field";
            echo json_encode($response);
            exit;
        }
    }
    
    // Extract and sanitize input data
    $client_Id   = $_POST['preneurId'];
    $AssClientCategory   = $_POST['prenCategory'];
    $AssProprio   = $_POST['assProprio'];
    $AssVarPolice   = $_POST['assPolice'];
    $AssVarCertificate   = $_POST['assCertificat'];
    $AssVarNotePrime   = $_POST['assNotePrime'];
    $AssVehCategory   = $_POST['assCatAutomobile'];
    $AssVehPlate   = $_POST['autoPlate'];
    $AssVehCatPlate   = $_POST['autoCatPlate'];
    $AssVehMCM   = $_POST['autoModelClass'];
    $AssVehChassis   = $_POST['autoChassis'];
    $CarteDoD   = $_POST['dateCarteRose'];
    $CarteDoM   = $_POST['dateFabrication'];
    $AssVehPower   = $_POST['autoPuissance'];
    $AssVehCabine   = $_POST['autoCabine'];
    $AssVehPlateua   = $_POST['autoPlateau'];
    $AssUsage   = $_POST['autoUsage'];
    // $AssValAssurer   = $_POST['autoValeurAssure'];
    // $AssTyPayment   = $_POST['typePayment'];
    // $AssGaranty   = $_POST['assGaranti'];
    // $AssPrimeNet   = $_POST['assPrimeNet'];
    $AssEffet   = $_POST['assEffet'];
    $AssCouverture   = $_POST['assCouverture'];
    $AssEcheance   = $_POST['assEcheance'];
    $SouscName   = $_POST['responsable'];
    $SouscAgency   = $_POST['agence_name'];
    $SouscUserName   = $_POST['username'];
    $SouscUserId   = $_POST['user_code'];
    
    $db = new Developers();
    $currentDate = date("Y-m-d");
    $currentTime = date("H:i:s");
    $date_operation = date("Y-m-d");
    $date_facture = date("Y-m-d h:i:s");
    $date_facture_signature = date("Ymdhis");
    $Year2 = date("y");
    
    // Get QR Code Unique Id
        $date = date("Ymd");   // Outputs: 20250404
        $time = date("His");   // Outputs: 112714
        $timestamp = time();
        $op_reference_v1 = $db->getPinCodeNumber(20, false, false, true);
        //$op_reference_v2 = $db->getMixedRandomId(4, false, true, true);
        //$op_reference = 'B'.$op_reference_v2.$op_reference_v1.'D'.$date.'T'.$time.'IC';
        $url_qr_reference = $op_reference_v1.$timestamp.'.'.$date.'.'.$time;
    
    // Fetch Client details
    $clientLogDetails = $db->GetClientValuesById($client_Id);
    if (!$clientLogDetails) {
        $response['error'] = true;
        $response['message'] = "Informations du client introuvable.";
        echo json_encode($response);
        exit;
    }

    $ClientName             = $clientLogDetails['Nomprenom'];
    $ClientNIF              = $clientLogDetails['Categorie'];
    $ClientPhone            = $clientLogDetails['Phone'];
    $ClientResidence        = $clientLogDetails['AddresResidence'];
    $clientProvince         = $clientLogDetails['province'];
    $clientPays             = $clientLogDetails['country'];
    $SouscAgence            = $clientLogDetails['Agence'];
    
     // Fetch Agence details
    $agencyLogDetails = $db->GetAgenceValuesByName($SouscAgency);
    if (!$agencyLogDetails) {
        $response['error'] = true;
        $response['message'] = "Informations de l'Agence introuvable.";
        echo json_encode($response);
        exit;
    }

    $AgenceId               = $agencyLogDetails['Id'];
    $AgenceAccount         = $agencyLogDetails['Compte'];
    $Motif = "Creation contrat Automobile - Police [".$AssVarPolice."]";
    
    /*
    
       SELECT `Id`, `Numcontrat`, `id_contrat`, `Numpol`, `DateEmission`, `payment_date`, `DateEffet`, `DateEcheance`, `facture`, 
       `id_facture`, `NumCertificat`, `NumPrime`, `Plaque`, `PlaqueCategor`, `ClassMarkModel`, `NumChasis`, `FabricaYear`, 
       `PuissanceCV`, `PaleSeatCabine`, `SeatPlacePlato`, `UsageAuto`, `Proprietaire`, `proprio_id`, `NIF`, `phone`, `residence`, 
       `province`, `country`, `CatProprietaire`, `DateDelivrCarteRose`, `Garantie`, `valeur_assure`, `PN`, `RAB`, `FDSA`, `TF`, 
       `FDIGITAL`, `ARCA`, `FAPS`, `FRAIS`, `CD`, `TVA`, `PB`, `Creator`, `user_code`, `date`, `timeCreation`, `expiry_time`, 
       `company_name`, `assurance`, `CroseCertf`, `agence`, `agence_account`, `facturation`, `tx_reference`, `cashtelTrxId`, 
       `renouvellement`, `control`, `situation`, `cashier_situation`, `cashier_task`, `cashier_receipt`, `mode_payment`, `cashier_fullname`, 
       `psr`, `psr_date`, `obr`, `date_obr`, `commission`, `idcommussion`, `part_agence`, `part_company`, `username`, `owner_id` 
       FROM `agc_contrat` WHERE 1
       
        
    */
    $var_agenceName = $SouscAgency;
    $var_username = $SouscUserName;
    
    //$AssValAssurer,$AssGaranty,$AssTyPayment,$AssPrimeNet getAutomobileV1
  
     $automobile_ds = $db->getAutomobileDetails($client_Id,$ClientName,$AssProprio,$ClientNIF,$ClientPhone,$ClientResidence,$clientProvince,$clientPays,$AssClientCategory,
                                            $AssVarPolice,$AssVehCategory,$CarteDoD,$AssEffet,$AssEcheance,$AssVarCertificate,$AssVarNotePrime,$AssVehPlate,$AssVehCatPlate,
                                            $AssVehChassis,$CarteDoM,$AssVehMCM,$AssVehPower,$AssVehCabine,$AssVehPlateua,$AssUsage,$AssCouverture,$Year2,$SouscName,$SouscUserName,$SouscUserId,$SouscAgency,$AgenceId,$AgenceAccount,
                                            $date_facture,$date_facture_signature,$url_qr_reference);
     if($automobile_ds == 1){
        $response['error'] = false;
        $Query_1 = $db->getReport($Motif,$var_agenceName,$var_username,$date_operation);
      if($Query_1 == 1){
            $response['error'] = false;
            $response['message'] = "Le contrat est enregistré, continuer et ajouter des garentis";
       }elseif($Query_1 == 2){
             $response['error'] = true;
             $response['message'] = "Une erreur s'est produite, veuillez réessayer ou contactez le service informatique";
        }
                      
       }elseif($automobile_ds == 2){
            $response['error'] = true;
             $response['message'] = "Une erreur s'est produite. Veuillez réessayer ou contactez le service informatique";
        }elseif($automobile_ds == 0){
              $response['error'] = true;
               $response['message'] = "Le contrat que vous souhaitez créer avec ce numero de police existe déjà";
        }elseif($automobile_ds == 3){
              $response['error'] = true;
              $response['message'] = "Le contrat que vous souhaitez créer avec ce numero de certificat existe déjà";
        }elseif($automobile_ds == 4){
                        $response['error'] = true;
                        $response['message'] = "Le contrat que vous souhaitez créer avec ce numero de note de prime existe déjà";
        }elseif($automobile_ds == 5){
                        $response['error'] = true;
                        $response['message'] = "Le contrat que vous souhaitez créer avec ce numero plaque existe déjà";
        }
        
    echo json_encode($response);
?>