<?php
header('Content-Type: application/json; charset=utf-8');
require_once('../includes/Developers.php');

$response = [];

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!empty($_GET['agence'])) {
        $user_agence = $_GET['agence'];
        $db = new Developers();
        $autoContrat = $db->getAutoFina($user_agence);

        if (!empty($autoContrat)) {
            // check if error came from query
            if (isset($autoContrat['error'])) {
                echo json_encode([
                    'success' => false,
                    'message' => 'Database error: ' . $autoContrat['error']
                ]);
            } else {
                echo json_encode([
                    'success' => true,
                    'ContratsFinance' => $autoContrat
                ]);
            }
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Contrat Introuvable.'
            ]);
        }
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Required parameter "agence" is missing'
        ]);
    }
}
/*header('Content-Type: application/json; charset=utf-8');
 require_once('../includes/Developers.php');
 $response = array();
 if ($_SERVER['REQUEST_METHOD'] === 'GET') {
      if (isset($_GET['agence'])) {
            $user_agence = $_GET['agence'];
//$var_date = date("Y-m-d");,$var_date
        $db = new Developers();
        $autoContrat = $db->getAutoFina($user_agence);
    
    if (!empty($autoContrat)) {
        echo json_encode([
            'success' => true,
            'ContratsFinance' => $autoContrat
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'No police found.'
        ]);
    }
      } else {
            $response['error'] = true;
            $response['message'] = 'Required parameters are missing';
            echo json_encode($response);
        }
}*/

/*
header('Content-Type: application/json; charset=utf-8');

// Strict error reporting (for debugging)
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once('../includes/Developers.php');

$response = [];

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!empty($_GET['agence'])) {
        $user_agence = trim($_GET['agence']);

        try {
            $db = new Developers();
            $autoContrat = $db->getAutoFina($user_agence);

            if (!empty($autoContrat)) {
                $response = [
                    'success' => true,
                    'ContratsFinance' => $autoContrat
                ];
            } else {
                $response = [
                    'success' => false,
                    'message' => 'No contracts found for the given agence.'
                ];
            }
        } catch (Exception $e) {
            // Catch database or class-related issues
            $response = [
                'success' => false,
                'error' => 'Database error',
                'details' => $e->getMessage()
            ];
        }
    } else {
        $response = [
            'success' => false,
            'error' => 'Missing parameter',
            'message' => 'The "agence" parameter is required'
        ];
    }
} else {
    $response = [
        'success' => false,
        'error' => 'Invalid request method',
        'message' => 'Only GET requests are allowed'
    ];
}

echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
*/
?>