<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../includes/Developers.php';

$response = array();

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        $response['error'] = true;
        $response['message'] = "Méthode de requête invalide. Veuillez utiliser POST.";
        echo json_encode($response);
        exit;
    }
    
    $requiredFields = [
        'assContratId', 'assValeurAssure','assTypePayment', 'assGaranti',
        'assTauxCotation', 'assResponsable','assAgence_name', 'assUsername', 'assUser_code'
    ];
    
    
    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            $response['error'] = true;
            $response['message'] = "Champ obligatoire manquant : $field";
            echo json_encode($response);
            exit;
        }
    }
    
    // Extract and sanitize input data
    $contrat_Id   = $_POST['assContratId'];
    $AssValAssurer   = $_POST['assValeurAssure'];
    $AssTyPayment   = $_POST['assTypePayment'];
    $AssGaranty   = $_POST['assGaranti'];
    $AssTauxCot   = $_POST['assTauxCotation'];
    $SouscName   = $_POST['assResponsable'];
    $SouscAgency   = $_POST['assAgence_name'];
    $SouscUserName   = $_POST['assUsername'];
    $SouscUserId   = $_POST['assUser_code'];
    
    $db = new Developers();
    $currentDate = date("Y-m-d");
    $currentTime = date("H:i:s");
    $date_operation = date("Y-m-d");
    $Year2 = date("y");
    
    // Fetch Contrat details
    $contratLogDetails = $db->GetContratAccValuesById($contrat_Id);
    if (!$contratLogDetails) {
        $response['error'] = true;
        $response['message'] = "Informations du contrat introuvable";
        echo json_encode($response);
        exit;
    }
    
    $contrat_Id   = $contratLogDetails['Id'];
    $contratNum_Id   = $contratLogDetails['Numcontrat'];
    $id_contrat   = $contratLogDetails['id_contrat'];
    $police   = $contratLogDetails['Numpol'];
    $emission   = $contratLogDetails['Date_emission'];
    $effet   = $contratLogDetails['Date_effet'];
    $echeance   = $contratLogDetails['Date_Echeance'];
    $facture   = $contratLogDetails['Facture'];
    $facture_id   = $contratLogDetails['idfacture'];
    $primeId   = $contratLogDetails['Numnoteprime'];
    
    $Address   = $contratLogDetails['localisation'];
    $Effectif   = $contratLogDetails['Nbretete'];
    $Nature   = $contratLogDetails['natureExploitation'];
    $Plafond   = $contratLogDetails['indeminite'];
    $Description   = $contratLogDetails['descriptionNature'];
    
    
    $preneur   = $contratLogDetails['preneur'];
    $proprio   = $contratLogDetails['Proprietaire'];
    $proprioId   = $contratLogDetails['proprio_id'];
    $NIF   = $contratLogDetails['NIF'];
    $contact   = $contratLogDetails['phone'];
    $residence   = $contratLogDetails['residence'];
    $province   = $contratLogDetails['province'];
    $pays   = $contratLogDetails['country'];
    $CatProprio   = $contratLogDetails['CatProprietaire'];
    //$garanty   = $contratLogDetails['Garantie'];
    $garanty = $contratLogDetails['Typegarantie'] ?? null;  // Safe extraction
    
    
    $Creator   = $contratLogDetails['Creator'];
    $UserCode   = $contratLogDetails['user_code'];
    $timeCreation   = $contratLogDetails['timecreation'];
    $agenceId   = $contratLogDetails['agence_id'];
    $agence   = $contratLogDetails['agence'];
    $accountAgence   = $contratLogDetails['agence_account'];
   
    $signature   = $contratLogDetails['signature'];
    $signature_date   = $contratLogDetails['date_signature'];
    $userName   = $contratLogDetails['username'];
    $url_qr_reference   = $contratLogDetails['detailsqrCode'];
   
    /*
    
    
      SELECT 
      
      `Numcontrat`, `id_contrat`, `Numpol`, `Date_emission`, `payment_date`, `Date_effet`, `Date_Echeance`, `Facture`, `idfacture`,
      `Numnoteprime`, `Designation_valeur`, `occupation`, `localisation`, `usage`, `product`, `Typegarantie`, `Nbretete`, `juridiction`, 
      `natureExploitation`, `indeminite`, `descriptionNature`, `Valeur_Assure`, `preneur`, `Proprietaire`, `proprio_id`, `NIF`, 
      `phone`, `residence`, `province`, `country`, `CatProprietaire`, `Taux_cotation`, `PN`, `RAB`, `FDSA`, `TF`, `FDIGITAL`, 
      `ARCA`, `FAPS`, `FRAIS`, `CD`, `TVA`, `PB`, `Creator`, `user_code`, `date`, `timecreation`, `expiry_time`, `company_name`, 
      `company_NIF`, `assurance`, `CroseCertf`, `agence_id`, `agence`, `agence_account`, `renouvellement`, `facturation`, 
      `tx_reference`, `cashtelTrxId`, `tx_date`, `tx_time`, `control`, `situation`, `cashier_situation`, `cashier_task`, `cashier_receipt`, 
      `mode_payment`, `cashier_fullname`, `signature`, `date_signature`, `commission`, `idcommussion`, `part_agence`, `part_company`, 
      `username`, `owner_id`, `detailsqrCode` FROM `agc_contrat_ac` WHERE 1
        
    
    */
   
    $Motif = "Creation contrat Accident - Police [".$police."]";
    

    $var_agenceName = $SouscAgency;
    $var_username   = $SouscUserName;
    

    if (!empty($garanty)) {
    
        // Clean and safe concatenation
        $assNewGaranty = rtrim($garanty, '+') . '+' . $AssGaranty;
    
        // Set initiator
       // $initiatorGarenti = $garanty;,$initiatorGarenti
        $accident_ds = $db->getAccidentWarantyV2($contrat_Id,$preneur,$proprioId,$proprio,$NIF,$contact,$residence,$province,$pays,$CatProprio,$contratNum_Id,$id_contrat,$police,
                                                        $emission,$effet,$echeance,$facture,$facture_id,$primeId,$Address,$Effectif,$Nature,$Plafond,$Description,
                                                        $AssValAssurer,$AssGaranty,$AssTyPayment,$AssTauxCot,$Year2,$Creator,$userName,
                                                        $UserCode,$timeCreation,$agence,$agenceId,$accountAgence,$signature,$signature_date,
                                                        $url_qr_reference,$assNewGaranty);
                 if($accident_ds == 1){
                    $response['error'] = false;
                    $Query_1 = $db->getReport($Motif,$var_agenceName,$var_username,$date_operation);
                  if($Query_1 == 1){
                        $response['error'] = false;
                        $response['message'] = "La garantie est très bien ajoutée, augmenter d'autre garenti ou continuer pour payer";
                   }elseif($Query_1 == 2){
                         $response['error'] = true;
                         $response['message'] = "Une erreur s'est produite, veuillez réessayer";
                    }
                                  
                   }elseif($accident_ds == 2){
                        $response['error'] = true;
                         $response['message'] = "Une erreur s'est produite. Veuillez réessayer";
                    }elseif($accident_ds == 0){
                          $response['error'] = true;
                           $response['message'] = "La garantie que vous souhaitez ajouter fait reference a une police inconnu";
                    }elseif($accident_ds == 4){
                           $response['error'] = true;
                           $response['message'] = "La garantie que vous souhaitez ajouter fait reference a un numero de note de prime inconnu";
                    }elseif($accident_ds == 5){
                           $response['error'] = true;
                           $response['message'] = "La garantie que vous souhaitez ajouter fait reference a un contrat inconnu";
                    }elseif($accident_ds == 6){
                           $response['error'] = true;
                           $response['message'] = "La garantie que vous souhaitez ajouter exist deja";
                    }
        
    
    } else {
    
                    // If null or empty, start clean with only the new value
                    $assNewGaranty = $AssGaranty;
                   // $initiatorGarenti = "IEFCA"; // Or leave empty if needed
                    $accident_ds = $db->getAccidentWarantyV1($contrat_Id,$preneur,$proprioId,$proprio,$NIF,$contact,$residence,$province,$pays,$CatProprio,$contratNum_Id,$id_contrat,$police,
                                                        $emission,$effet,$echeance,$facture,$facture_id,$primeId,$Address,$Effectif,$Nature,$Plafond,$Description,$AssValAssurer,
                                                        $AssGaranty,$AssTyPayment,$AssTauxCot,$Year2,$Creator,$userName,
                                                        $UserCode,$timeCreation,$agence,$agenceId,$accountAgence,
                                                        $signature,$signature_date,$url_qr_reference);
                 if($accident_ds == 1){
                    $response['error'] = false;
                    $Query_1 = $db->getReport($Motif,$var_agenceName,$var_username,$date_operation); 
                  if($Query_1 == 1){
                        $response['error'] = false;
                        $response['message'] = "La garantie est très bien ajoutée, augmenter d'autre garenti ou continuer pour payer";
                   }elseif($Query_1 == 2){
                         $response['error'] = true;
                         $response['message'] = "Une erreur s'est produite, veuillez réessayer";
                    }
                                  
                   }elseif($accident_ds == 2){
                        $response['error'] = true;
                         $response['message'] = "Une erreur s'est produite. Veuillez réessayer";
                    }elseif($accident_ds == 0){
                          $response['error'] = true;
                           $response['message'] = "La garantie que vous souhaitez ajouter fait reference a une police inconnu";
                    }elseif($accident_ds == 4){
                           $response['error'] = true;
                           $response['message'] = "La garantie que vous souhaitez ajouter fait reference a un numero de note de prime inconnu";
                    }elseif($accident_ds == 5){
                           $response['error'] = true;
                           $response['message'] = "La garantie que vous souhaitez ajouter fait reference a un contrat inconnu";
                    }elseif($accident_ds == 6){
                           $response['error'] = true;
                           $response['message'] = "La garantie que vous souhaitez ajouter exist deja";
                    }
                    
        
    }
    
    echo json_encode($response);
?>