<?php
 header('Content-Type: application/json; charset=utf-8');
 require_once('../includes/Developers.php');
$response = array();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!empty($_GET['user_id'])) {
        // Sanitize input to prevent SQL injection
        $userId = intval($_GET['user_id']);
        
        // Database instance
        $db = new Developers();

        // Fetch chat details
        $chatDetails = $db->getChatNewMessages($userId);

        // Check if chat data is retrieved
        if (!empty($chatDetails)) {
            $response = [
                'success' => true,
                'messages' => $chatDetails
            ];
        } else {
            $response = [
                'success' => true, // Keep success true but return an empty array
                'messages' => []
            ];
        }
    } else {
        $response = [
            'success' => false,
            'message' => 'Required parameters are missing'
        ];
    }
} else {
    $response = [
        'success' => false,
        'message' => 'Invalid request method'
    ];
}

// Send JSON response
//header('Content-Type: application/json');
echo json_encode($response);

?>