<?php 
header('Content-Type: application/json; charset=utf-8');
require_once '../includes/Developers.php'; // Assuming this contains the DB connection

$response = array();

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['user_id'])) {
        $userId = $_GET['user_id'];
        $var_date = date("Y-m-d");
        $var_time = date("H:m:s");
        $db = new Developers();
        
        $marketDetails = $db->getCardDetails($userId);     
        if ($marketDetails) {
            
                $response['error'] = false;
                $response['CardSerialId'] = $marketDetails['CardSerialId'];
                $response['AccCardPin'] = $marketDetails['AccCardPin'];
                $response['AccName'] = $marketDetails['AccName'];
                $response['AccNumber'] = $marketDetails['AccNumber'];
                $response['balance'] = $marketDetails['balance'];
                $response['qrCard'] = $marketDetails['qrCard'];
                $response['statusId'] = $marketDetails['statusId'];
                $response['date'] = $marketDetails['date'];
                $response['effet'] = $marketDetails['effet'];
                $response['expiration'] = $marketDetails['expiration'];
                        
        } else {
                
                $response['error'] = false;
                $response['CardSerialId'] = "********************";
                $response['AccCardPin'] = "N/A";
                $response['AccName'] = "N/A";
                $response['AccNumber'] = "N/A";
                $response['balance'] = "0.00";
                $response['qrCard'] = "N/A";
                $response['statusId'] = 3;
                $response['date'] = "0000-00-00";
                $response['effet'] = "0000-00-00";
                $response['expiration'] = "0000-00-00";
                        
        } 

    
    } else {
        $response['error'] = true;
        $response['message'] = 'User ID is missing';
    }
} else {
    $response['error'] = true;
    $response['message'] = 'Invalid request method';
}

echo json_encode($response);
?>