<?php

class Developers
{
    private $con;

    public function __construct()
    {
        require_once dirname(__FILE__) . '/DbConnect.php';

        // Use the optimized Singleton DB connection
        $db = new DbConnect();
        $this->con = $db->connect();
    }
    
     /* ----------------------------------------------
     * SAFE & OPTIMIZED: GET ALL COUNTRIES
     * ---------------------------------------------- */
    public function getCountry() {
        // Get the shared database connection (Singleton pattern)
        $db = DbConnect::getInstance();
        $con = $db->getConnection();
    
        $sql = "SELECT * FROM agc_countries";
        $stmt = $con->prepare($sql);
    
        // If prepare fails, return structured error
        if (!$stmt) {
            return [
                "status" => false,
                "error" => "Prepare failed: " . $con->error
            ];
        }
    
        // Execute SQL safely
        $stmt->execute();
        $result = $stmt->get_result();
    
        // Fetch all rows
        $countries = [];
        while ($row = $result->fetch_assoc()) {
            $countries[] = $row;
        }
    
        // Release SQL resources
        $stmt->close();
    
        return $countries;
    }


    
    

    /* ----------------------------------------------
     * SAFE & OPTIMIZED: GET CONTRACT RENEWALS
     * ---------------------------------------------- */
    public function getRenewAutov0($user_plate)
    {
        if ($this->con === null) {
            error_log("Database connection unavailable.");
            return [];
        }

        $sql = "SELECT * 
                FROM `agc_contrat` 
                WHERE `situation` = ? 
                  AND `Plaque` = ? 
                  AND `DateEcheance` <= CURDATE() + INTERVAL 3 DAY
                ORDER BY `Id` DESC";

        $stat = 1;

        $stmt = $this->con->prepare($sql);
        if (!$stmt) {
            error_log("SQL Prepare Error: " . $this->con->error);
            return [];
        }

        $stmt->bind_param("is", $stat, $user_plate);
        $stmt->execute();

        $result = $stmt->get_result();
        if (!$result) {
            error_log("SQL Execution Error: " . $stmt->error);
            return [];
        }

        $data = [];
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }

        $stmt->close();  // Cleanup prepared statement

        return $data;
    }

    /* ----------------------------------------------
     * ADD MORE METHODS HERE USING SAME PATTERN...
     * ---------------------------------------------- */
}
?>
