<?php  
   session_start();
   if (!$_SESSION["auth"]) {
     # redirect to login page
     header('Location: index');
   }else {
     # destroy session and redirect to login page
     $currentTime = time();
     if ($currentTime > $_SESSION["expire"]){
       session_unset();
       session_destroy();
       header('Location: index');
     }else{
         
     require_once('settings/config.php');
     require('fpdfLib/fpdf.php');

    /*if(isset($_GET['karangamuntu'])){
        $_SESSION['karangamuntu'] = $_GET['karangamuntu'];
    }else{
        include('get-contrat-bill-agc.php');
    }*/
    
    //$code_get = $_SESSION['karangamuntu'];


    
       
        // Include the FPDF library
        require('fpdf/fpdf.php'); // Adjust the path to where FPDF is located
        
        // Database connection
        $servername = "localhost";
        $username = "your_username";
        $password = "your_password";
        $dbname = "your_database";
        
        $conn = new mysqli($servername, $username, $password, $dbname);
        
        // Check connection
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }
        
        // Function to fetch invoice data by ID
        function getInvoiceData($conn, $invoice_id) {
            $data = [];
        
            // Fetch invoice details
            $sql = "SELECT i.*, c.name AS client_name, c.telephone AS client_telephone, c.address AS client_address, c.tva_status AS client_tva_status
                    FROM invoices i
                    JOIN clients c ON i.client_id = c.id
                    WHERE i.invoice_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("s", $invoice_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $data['invoice'] = $result->fetch_assoc();
        
            // Fetch company details
            $sql = "SELECT * FROM company WHERE id = 1"; // Assuming AGICO is the only company, adjust as needed
            $result = $conn->query($sql);
            $data['company'] = $result->fetch_assoc();
        
            $stmt->close();
            return $data;
        }
        
        // Create a class extending FPDF to customize the invoice
        class InvoicePDF extends FPDF {
            function Header() {
                // Add company logo (optional, if you have one)
                // $this->Image('logo.png', 10, 6, 30);
        
                // Company name
                $this->SetFont('Arial', 'B', 14);
                $this->Cell(0, 10, 'AGICO', 0, 1, 'C');
                
                // Company address and date
                $this->SetFont('Arial', '', 10);
                $this->Cell(0, 5, 'Bujumbura, le ' . date('d-m-Y'), 0, 1, 'R');
                $this->Ln(5);
            }
        
            function Footer() {
                $this->SetY(-15);
                $this->SetFont('Arial', 'I', 8);
                $this->Cell(0, 10, 'Page ' . $this->PageNo(), 0, 0, 'C');
            }
        
            function CompanyDetails($company) {
                $this->SetFont('Arial', '', 10);
                $this->Cell(0, 5, 'Societe Anonyme au capital social de ' . number_format($company['capital'], 0, ',', ' ') . '.', 0, 1);
                $this->Cell(0, 5, 'Entreprise regie par le code des assurances burundais.', 0, 1);
                $this->Ln(5);
        
                $this->SetFont('Arial', 'B', 10);
                $this->Cell(0, 5, 'IDENTIFICATION DU VENDEUR', 0, 1);
                $this->SetFont('Arial', '', 10);
                $this->Cell(0, 5, 'Nom/Raison Social: ' . $company['name'], 0, 1);
                $this->Cell(0, 5, 'NIF: ' . $company['nif'], 0, 1);
                $this->Cell(0, 5, 'R)C N' . chr(176) . ': ' . $company['rc_number'], 0, 1);
                $this->Cell(0, 5, 'B.P: ' . $company['bp'], 0, 1);
                $this->Cell(0, 5, 'Telephone: ' . $company['telephone'], 0, 1);
                $this->Cell(0, 5, 'Adresse: ' . $company['address'], 0, 1);
                $this->Cell(0, 5, 'Assujetti a la TVA: ' . $company['tva_status'], 0, 1);
                $this->Ln(5);
            }
        
            function ClientDetails($client) {
                $this->SetFont('Arial', 'B', 10);
                $this->Cell(0, 5, 'Le Client', 0, 1);
                $this->SetFont('Arial', '', 10);
                $this->Cell(0, 5, 'Nom/Raison social: ' . $client['client_name'], 0, 1);
                $this->Cell(0, 5, 'Telephone: ' . $client['client_telephone'], 0, 1);
                $this->Cell(0, 5, 'Adresse: ' . $client['client_address'], 0, 1);
                $this->Cell(0, 5, 'Assujetti a la TVA: ' . $client['client_tva_status'], 0, 1);
                $this->Cell(0, 5, 'Facture No: ' . $client['invoice_id'], 0, 1);
                $this->Ln(5);
            }
        
            function InvoiceDetails($invoice) {
                $this->SetFont('Arial', 'B', 10);
                $this->Cell(100, 5, 'DESIGNATION', 1, 0);
                $this->Cell(50, 5, 'MONTANT', 1, 1);
                $this->SetFont('Arial', '', 10);
                $this->Cell(100, 5, $invoice['designation'], 1, 0);
                $this->Cell(50, 5, number_format($invoice['prime_nette'], 0, ',', ' ') . ' BIF', 1, 1);
                $this->Cell(100, 5, 'Frais', 1, 0);
                $this->Cell(50, 5, number_format($invoice['frais'], 0, ',', ' ') . ' BIF', 1, 1);
                $this->Cell(100, 5, 'TOTAL HTVA', 1, 0);
                $this->Cell(50, 5, number_format($invoice['total_htva'], 0, ',', ' ') . ' BIF', 1, 1);
                $this->Cell(100, 5, 'TVA', 1, 0);
                $this->Cell(50, 5, number_format($invoice['tva'], 0, ',', ' ') . ' BIF', 1, 1);
                $this->Cell(100, 5, 'TOTAL', 1, 0);
                $this->Cell(50, 5, number_format($invoice['total'], 0, ',', ' ') . ' BIF', 1, 1);
                $this->Ln(10);
            }
        
            function Signature() {
                $this->SetFont('Arial', '', 10);
                $this->Cell(0, 5, 'ID: 4001447277/ws1400144727700418/20250307064647/000270', 0, 1);
                $this->Ln(5);
                $this->Cell(0, 5, 'Pour la societe d\'assurance AGICO', 0, 1);
            }
        }
        
        // Get the invoice ID from the request (e.g., via GET or POST)
        $invoice_id = isset($_GET['invoice_id']) ? $_GET['invoice_id'] : '000270';
        
        // Fetch the data
        $data = getInvoiceData($conn, $invoice_id);
        
        if (!$data['invoice']) {
            die("Invoice not found.");
        }
        
        // Create PDF
        $pdf = new InvoicePDF();
        $pdf->AddPage();
        $pdf->CompanyDetails($data['company']);
        $pdf->ClientDetails($data['invoice']);
        $pdf->InvoiceDetails($data['invoice']);
        $pdf->Signature();
        
        // Output the PDF
        $pdf->Output('I', 'invoice_' . $invoice_id . '.pdf'); // 'I' for inline display, 'D' for download
        
        // Close the database connection
        $conn->close();
       
    }
}
?>


