<?php
// ============================================================================
// ENVIRONMENT DETECTION
// ============================================================================

// Detect if we're on localhost
$isLocalhost = ($_SERVER['HTTP_HOST'] === 'localhost' || 
                $_SERVER['HTTP_HOST'] === '127.0.0.1' || 
                substr($_SERVER['HTTP_HOST'], -6) === '.local');

// Set environment
define('ENVIRONMENT', $isLocalhost ? 'development' : 'production');
define('DEBUG_MODE', ENVIRONMENT === 'development');
define('FORCE_HTTPS', ENVIRONMENT === 'production');
define('SECURE_COOKIES', ENVIRONMENT === 'production');

// config/environment.php - NEW file for environment settings
//define('ENVIRONMENT', 'development'); // Change to 'production' when deploying

// Set base configuration based on environment
if (ENVIRONMENT === 'production') {
    // Production settings
    define('FORCE_HTTPS', true);
    define('SECURE_COOKIES', true);
    define('DEBUG_MODE', false);
    define('BASE_URL', 'https://bicnv-sa.com/MGlobal/live');
    
    // Production database credentials (optional - separate from dev)
    define('DB_HOST', 'production_host');
    define('DB_USER', 'production_user');
    define('DB_PASS', 'production_password');
    define('DB_NAME', 'production_database');
    
} else {
    // Development settings
    define('FORCE_HTTPS', false);
    define('SECURE_COOKIES', false);
    define('DEBUG_MODE', true);
    define('BASE_URL', 'http://localhost/FullStack/live_v2/live');
    
    // Development database credentials
    define('DB_HOST', 'localhost');
    define('DB_USER', 'root');
    define('DB_PASS', '');
    define('DB_NAME', 'live_2');
}

/*

// config/environment.php
define('ENVIRONMENT', 'development'); // Change to 'production' when deploying

// Set base configuration based on environment
if (ENVIRONMENT === 'production') {
    // Production settings
    define('FORCE_HTTPS', true);
    define('SECURE_COOKIES', true);
    define('DEBUG_MODE', false);
    define('BASE_URL', 'https://bicnv-sa.com/MGlobal/live');
} else {
    // Development settings
    define('FORCE_HTTPS', false);
    define('SECURE_COOKIES', false);
    define('DEBUG_MODE', true);
    define('BASE_URL', 'http://localhost/FullStack/live_v2/live');
}

*/
