<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../includes/Developers.php';

$response = array();

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        $response['error'] = true;
        $response['message'] = "Méthode de requête invalide. Veuillez utiliser POST.";
        echo json_encode($response);
        exit;
    }

    $requiredFields = [
        'purchase_id', 'userUid'
    ];

    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            $response['error'] = true;
            $response['message'] = "Champ obligatoire manquant : $field";
            echo json_encode($response);
            exit;
        }
    }

    // Extract and sanitize input data
    $order_Id       = $_POST['purchase_id'];
    $payer_Id  = $_POST['userUid'];
    
    $db = new Developers();
    $currentDate = date("Y-m-d");
    $currentTime = date("H:i:s");

    // Fetch purchase details
    $typeCartDetails = $db->getPurchasedValues($order_Id);
    if (!$typeCartDetails) {
        $response['error'] = true;
        $response['message'] = "Référence de facture introuvable.";
        echo json_encode($response);
        exit;
    }

        $cartContratId    = $typeCartDetails['police_id'];
        $Ins_category   = $typeCartDetails['product_category'];
        $PayerName      = $typeCartDetails['payer_name'];
        $initiatorCode  = $typeCartDetails['paidto_number'];
        $cartQty        = $typeCartDetails['product_qty'];
        $amount         = $typeCartDetails['balance_paid'];
        $cartInvoice      = $typeCartDetails['invoice_id'];
        $cartPolice       = $typeCartDetails['product_paid'];
        $customerNumber = $typeCartDetails['payer_number'];
        $cartRef        = $typeCartDetails['op_reference'];
        $cashtelTrxId   = $typeCartDetails['cashTelTrxId'];
        $codeKey        = $db->getMixedRandomId(15, false, true, true);
        
        $narration      = $cartInvoice .'_'. $cartPolice;
        $trxId          = $cartRef .'_'. $codeKey;
        
        
         // Fetch purchase details
        $typeCardDetails = $db->getCardAccValues($payer_Id);
        if (!$typeCardDetails) {
            $response['error'] = true;
            $response['message'] = "Référence de carte introuvable.";
            echo json_encode($response);
            exit;
        }

        $cardId         = $typeCardDetails['id'];
        $cardNumber     = $typeCardDetails['CardSerialId'];
        $cardName       = $typeCardDetails['AccName'];
        $AccBalance      = $typeCardDetails['balance'];
        $cMsisdn        = $typeCardDetails['AccNumber'];
        $cardPIN        = $typeCardDetails['AccCardPin'];
        
        $trxStatus = "CANCELED";
        $workStatus = 4;

        global $response;

        // Update transaction status

        $updateStatus = $db->getEvDetectedByIp($cartRef,$trxId,$cashtelTrxId,$trxStatus,$amount,$cMsisdn,$workStatus);
    
        if ($updateStatus !== 1) {
            $response['error'] = true;
            $response['message'] = "Échec de la mise à jour d'assurance.";
            return;
        }
       
        $response['error'] = false;
        $response['message'] = "Annulation du paiement effectué et confirmé !";
       // $response['message'] = $description;
        
    
echo json_encode($response);
?>