<?php
     class DbOperations
        {
            private $con;

            function __construct(){
                require_once dirname(__FILE__).'/DbConnect.php';
                $db = new DbConnect();

                $this->con = $db->connect();
            }
            
            /* CRUD -> c -> Create */
            
                        
              public function userLogin($bic_username,$bic_password){
                $pass = md5($bic_password);
                $stmt = $this->con->prepare("SELECT id_log FROM `code_users` WHERE `username`=? AND `password`=?");
                $stmt->bind_param("ss",$bic_username,$pass);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
            public function getUserByUsername($bic_username){
                $stmt = $this->con->prepare("SELECT *  FROM `code_users` WHERE `username`=?");
                $stmt->bind_param("s",$bic_username);
                $stmt->execute();
                return $stmt->get_result()->fetch_assoc();
            }
            
             public function createPreneur($bic_fullname,$bic_contact,$bic_residence,
            $bic_categorie, $bic_province, $bic_userFullname, $bic_agenceName, $bic_userCode,$date_operation){
                if ($this->isPreneurExist($bic_fullname,$bic_contact)) {
                   return 0;
                }else {

                    $stmt = $this->con->prepare("INSERT INTO `bic_preneur`(`Nomprenom`, `Categorie`, `Phone`, `AddresResidence`,`province`, `Agence`, `username`, `code_user`, `date`) VALUES (?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssss", $bic_fullname,$bic_categorie,$bic_contact,$bic_residence,$bic_province,$bic_agenceName,$bic_userFullname
                    ,$bic_userCode,$date_operation);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isPreneurExist($bic_fullname,$bic_contact){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_preneur` WHERE `Nomprenom`=? OR `Phone`=?");
                $stmt->bind_param("ss", $bic_fullname,$bic_contact);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            // $bic_frais,,$bic_frais
            
              public function createContratAuto($bic_preneur,$bic_categoryPreneur,$bic_police,$bic_dateCarteRose,$bic_dateEffet,
                    $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
                    $bic_plateau,$bic_usage,$bic_primeNet,$bic_valeurAssure,$bic_garanti,$Year2,
                    $bic_userFullname,$bic_userCode,$bic_agenceName){
                if ($this->isContratAutoExist($bic_certificat,$bic_police)) {
                   return 0;
                }else {

                    $stmt = $this->con->prepare("CALL getContratAuto(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssssssssssssssssss", $bic_preneur,$bic_categoryPreneur,$bic_police,$bic_dateCarteRose,$bic_dateEffet,
                    $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
                    $bic_plateau,$bic_usage,$bic_primeNet,$bic_valeurAssure,$bic_garanti,$Year2,
                    $bic_userFullname,$bic_userCode,$bic_agenceName);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isContratAutoExist($bic_certificat,$bic_police){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat` WHERE `NumCertificat`=? OR `Numpol`=?");
                $stmt->bind_param("ss", $bic_certificat,$bic_police);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
             public function createContratFire($bic_preneur,$bic_tauxCotation,$bic_police,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_ObjetAssurer,$bic_quantite,
            $bic_typebatiment,$bic_modePrevention,$bic_modeConstruction,
            $bic_numeroTitre,$bic_numeroParcelle,$bic_emplacement,$bic_nombreNiveau,
            $bic_numeroAutorisation,$bic_usage,$bic_garanti,$bic_valeurAssure,
            $bic_primeNet,$Year2,$bic_userFullname,
            $bic_userCode,$bic_agenceName){
                if ($this->isContratFireExist($bic_certificat,$bic_police)) {
                   return 0;
                }else {

                    $stmt = $this->con->prepare("CALL getContratFire(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("ssssssssssssssssssssssss", $bic_preneur,$bic_police,$bic_dateEffet,
                    $bic_dateEcheance,$bic_certificat,$bic_ObjetAssurer,$bic_quantite,$bic_typebatiment,$bic_usage,$bic_modePrevention,$bic_numeroTitre,$bic_numeroParcelle,
                    $bic_emplacement,$bic_numeroAutorisation,$bic_modeConstruction,$bic_nombreNiveau,$bic_tauxCotation,$bic_primeNet,$bic_valeurAssure,$bic_garanti,$Year2,
                    $bic_userFullname,$bic_userCode,$bic_agenceName);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isContratFireExist($bic_certificat,$bic_police){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_fire` WHERE `NumCertificat`=? OR `Numpol`=?");
                $stmt->bind_param("ss", $bic_certificat,$bic_police);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            
               public function createContratMarine($bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
            $bic_certificat,$bic_natureMarchandise,$bic_taux_Cotation,$bic_numeroFacture,$bic_dateFacture,$bic_DetailArticle,
            $bic_valeurDevise,$bic_tauxChange,$bic_voie,$bic_transit,$bic_emballage,$bic_portOrigine,
            $bic_portDestination,$bic_devise,$bic_garanti,$bic_userFullname,
            $bic_agenceName,$bic_userCode,$Year2){
                if ($this->isContratMarineExist($bic_certificat,$bic_police)) {
                   return 0;
                }else {

                    $stmt = $this->con->prepare("CALL getContratMarine(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssssssssssssssssss", $bic_preneur,$bic_police,$bic_dateEffet,
                    $bic_dateEcheance,$bic_certificat,$bic_natureMarchandise,$bic_numeroFacture,$bic_dateFacture,$bic_DetailArticle,$bic_valeurDevise,$bic_tauxChange,$bic_taux_Cotation,
                    $bic_voie,$bic_transit,$bic_emballage,$bic_portOrigine,$bic_portDestination,$bic_devise,$bic_garanti,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isContratMarineExist($bic_certificat,$bic_police){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_marine` WHERE `NumCertificat`=? OR `Numpol`=?");
                $stmt->bind_param("ss", $bic_certificat,$bic_police);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            /*
            $bic_juridiction,$bic_natureExploitation,$bic_descrNature,
            $bic_juridiction,$bic_natureExploitation,$bic_descrNature,
            */
            
                        public function createContratRC($bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
            $bic_certificat,$bic_designation,$bic_occupation,$bic_localisation,
            $bic_descrValeur,$bic_tauxCotation,$bic_usage,$bic_garanti,$bic_ValeurAssurer,
            $bic_primeNet,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2){
                if ($this->isContratRCExist($bic_certificat,$bic_police)) {
                   return 0;
                }else {

                    $stmt = $this->con->prepare("CALL getContratRC(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("ssssssssssssssssss", $bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
                    $bic_certificat,$bic_designation,$bic_occupation,$bic_localisation,
                    $bic_descrValeur,$bic_tauxCotation,$bic_usage,$bic_garanti,$bic_ValeurAssurer,
                    $bic_primeNet,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isContratRCExist($bic_certificat,$bic_police){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_rc` WHERE `NumCertificat`=? OR `Numpol`=?");
                $stmt->bind_param("ss", $bic_certificat,$bic_police);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            
            
            public function createContratFlotteAuto($bic_preneur,$bic_categoryPreneur,$bic_police,$bic_dateCarteRose,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
            $bic_plateau,$bic_usage,$bic_primeNet,$bic_numeroFacture,$bic_idFacture,$bic_valeurAssure,$bic_garanti,
            $bic_userFullname,$bic_userCode,$bic_agenceName){
        if ($this->isContratFlotteAutoExist($bic_certificat)) {
           return 0;
        }else {

            $stmt = $this->con->prepare("CALL getContratFlotteAuto(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("ssssssssssssssssssssssss", $bic_preneur,$bic_categoryPreneur,$bic_police,$bic_dateCarteRose,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
            $bic_plateau,$bic_usage,$bic_primeNet,$bic_numeroFacture,$bic_idFacture,$bic_valeurAssure,$bic_garanti,
            $bic_userFullname,$bic_userCode,$bic_agenceName);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
        }

    }
    
        private function isContratFlotteAutoExist($bic_certificat){
        $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat` WHERE `NumCertificat`=?");
        $stmt->bind_param("s", $bic_certificat);
        $stmt->execute();
        $stmt->store_result();
        return $stmt->num_rows > 0;
    }
    
    
     public function createContratFlotteAutoIncorporation($bic_preneur,$bic_categoryPreneur,$bic_police,$bic_dateCarteRose,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
            $bic_plateau,$bic_usage,$bic_primeNet,$bic_valeurAssure,$bic_garanti,
            $bic_userFullname,$bic_userCode,$bic_agenceName,$Year2){
        if ($this->isContratFlotteAutoIncorpExist($bic_certificat)) {
           return 0;
        }else {

            $stmt = $this->con->prepare("CALL getContratFlotteAutoIncorporation(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("sssssssssssssssssssssss", $bic_preneur,$bic_categoryPreneur,$bic_police,$bic_dateCarteRose,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
            $bic_plateau,$bic_usage,$bic_primeNet,$bic_valeurAssure,$bic_garanti,
            $bic_userFullname,$bic_userCode,$bic_agenceName,$Year2);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
        }

    }
    
    
    private function isContratFlotteAutoIncorpExist($bic_certificat){
        $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat` WHERE `NumCertificat`=?");
        $stmt->bind_param("s", $bic_certificat);
        $stmt->execute();
        $stmt->store_result();
        return $stmt->num_rows > 0;
    }
    
    // $bic_frais,,$bic_frais
    
     public function changeContratAuto($bic_contrat,$bic_preneur,$bic_categoryPreneur,$bic_dateCarteRose,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
            $bic_plateau,$bic_usage,$bic_primeNet,$bic_valeurAssure,$bic_garanti,
            $bic_userFullname,$bic_userCode,$bic_agenceName){
        if ($this->isContratChangeAutoExist($bic_contrat)) {
            
               $stmt = $this->con->prepare("CALL getContratChangeAuto(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("ssssssssssssssssssssss", $bic_preneur,$bic_categoryPreneur,$bic_dateCarteRose,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
            $bic_plateau,$bic_usage,$bic_primeNet,$bic_valeurAssure,$bic_garanti,
            $bic_userFullname,$bic_userCode,$bic_agenceName,$bic_contrat);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
            
        }else {
            return 0;
         }
    }

    private function isContratChangeAutoExist($bic_contrat){
        $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat` WHERE `Numcontrat`=?");
        $stmt->bind_param("s", $bic_contrat);
        $stmt->execute();
        $stmt->store_result();
        return $stmt->num_rows > 0;
    }
    
    
    
    // CONFIRMATION CONTRACT START 2024
    
        public function getConfirmAuto($contratId,$sit){
           $stmt = $this->con->prepare("UPDATE `bic_contrat` SET `situation`=? WHERE `Id`=?");
           $stmt->bind_param("ss",$sit,$contratId);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        
        public function BICvarCertByNo($contratId){
            $stmt = $this->con->prepare("SELECT `NumCertificat` AS max_product FROM `bic_contrat` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
        public function BICvarPoliceByNo($contratId){
            $stmt = $this->con->prepare("SELECT `Numpol` AS max_product FROM `bic_contrat` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
        public function getCertTaken($gissCertificat,$varTaken,$gissAgence){
           $stmt = $this->con->prepare("UPDATE `bic_certificat` SET `Status`=? WHERE `certificat_countor`=? AND `Agence`=?");
           $stmt->bind_param("sss",$varTaken,$gissCertificat,$gissAgence);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        
         public function getPolTaken($gissPolice,$varTaken,$gissAgence){
           $stmt = $this->con->prepare("UPDATE `bic_chargement` SET `Status`=? WHERE `Numpol`=? AND `Agence`=?");
           $stmt->bind_param("sss",$varTaken,$gissPolice,$gissAgence);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        
        public function BICvarUsageByNo($contratId){
            $stmt = $this->con->prepare("SELECT `UsageAuto` AS max_product FROM `bic_contrat` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
       public function BICvarPrimeNetByNo($contratId){
            $stmt = $this->con->prepare("SELECT `PN` AS max_product FROM `bic_contrat` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
        public function getPrimeTaken($primeId,$varTaken,$gissAgence){
           $stmt = $this->con->prepare("UPDATE `bic_notPrime` SET `Status`=? WHERE `Id`=? AND `Agence`=?");
           $stmt->bind_param("sss",$varTaken,$primeId,$gissAgence);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        
        public function BICvarAgenceByNo($contratId){
            $stmt = $this->con->prepare("SELECT `agence` AS max_product FROM `bic_contrat` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
        public function getComVarComV1($contratId,$gissCom_1,$gissAgentCom_1v,$gissCompPart_1v){
           $stmt = $this->con->prepare("UPDATE `bic_contrat` SET `commission`=?,`part_agence`=?,`part_bic`=? WHERE `Id`=?");
           $stmt->bind_param("ssss",$gissCom_1,$gissAgentCom_1v,$gissCompPart_1v,$contratId);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        
        public function getComVarComV2($contratId,$gissCom_2,$gissAgentCom_2v,$gissCompPart_2v){
           $stmt = $this->con->prepare("UPDATE `bic_contrat` SET `commission`=?,`part_agence`=?,`part_bic`=? WHERE `Id`=?");
           $stmt->bind_param("ssss",$gissCom_2,$gissAgentCom_2v,$gissCompPart_2v,$contratId);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        
          public function getAgenceBalanceNo($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `bic_contrat` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
        public function getAgenceClientNo($agenceId){
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_client FROM `bic_preneur` WHERE `Agence`=?");
            $stmt->bind_param("s",$agenceId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_client'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
         public function getAgenceCNVNo($agenceId,$situation){
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contratNV FROM `bic_contrat` WHERE `agence`=? AND `situation`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_contratNV'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
        public function getAgenceCVNo($agenceId,$situation){
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contratV FROM `bic_contrat` WHERE `agence`=? AND `situation`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_contratV'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
         public function getConfirmFire($contratId,$sit){
           $stmt = $this->con->prepare("UPDATE `bic_contrat_fire` SET `situation`=? WHERE `Id`=?");
           $stmt->bind_param("ss",$sit,$contratId);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
         public function BICvarPoliceFiByNo($contratId){
            $stmt = $this->con->prepare("SELECT `Numpol` AS max_product FROM `bic_contrat_fire` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
       public function BICvarAgenceFiByNo($contratId){
            $stmt = $this->con->prepare("SELECT `agence` AS max_product FROM `bic_contrat_fire` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        public function BICvarNotePrimeFiByNo($contratId){
            $stmt = $this->con->prepare("SELECT `NumCertificat` AS max_product FROM `bic_contrat_fire` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
         public function BICvarPrimeNetFiByNo($contratId){
            $stmt = $this->con->prepare("SELECT `PN` AS max_product FROM `bic_contrat_fire` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        public function getComVarFiComV1($contratId,$gissCom_1,$gissAgentCom_1v,$gissCompPart_1v){
           $stmt = $this->con->prepare("UPDATE `bic_contrat_fire` SET `commission`=?,`part_agence`=?,`part_bic`=? WHERE `Id`=?");
           $stmt->bind_param("ssss",$gissCom_1,$gissAgentCom_1v,$gissCompPart_1v,$contratId);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        public function getAgenceFiBalanceNo($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `bic_contrat_fire` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        public function getAgenceFiCNVNo($agenceId,$situation){
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contratNV FROM `bic_contrat_fire` WHERE `agence`=? AND `situation`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_contratNV'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        public function getAgenceFiCVNo($agenceId){
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contratV FROM `bic_contrat_fire` WHERE `agence`=? AND `situation`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_contratV'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
          public function getConfirmMarine($contratId,$sit){
           $stmt = $this->con->prepare("UPDATE `bic_contrat_marine` SET `situation`=? WHERE `Id`=?");
           $stmt->bind_param("ss",$sit,$contratId);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        
          public function BICvarPoliceMaByNo($contratId){
            $stmt = $this->con->prepare("SELECT `Numpol` AS max_product FROM `bic_contrat_marine` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
            public function BICvarNotePrimeMaByNo($contratId){
            $stmt = $this->con->prepare("SELECT `NumCertificat` AS max_product FROM `bic_contrat_marine` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
         public function BICvarAgenceMaByNo($contratId){
            $stmt = $this->con->prepare("SELECT `agence` AS max_product FROM `bic_contrat_marine` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
       public function BICvarPrimeNetMaByNo($contratId){
            $stmt = $this->con->prepare("SELECT `PN` AS max_product FROM `bic_contrat_marine` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        public function getComVarMaComV1($contratId,$gissCom_1,$gissAgentCom_1v,$gissCompPart_1v){
           $stmt = $this->con->prepare("UPDATE `bic_contrat_marine` SET `commission`=?,`part_agence`=?,`part_bic`=? WHERE `Id`=?");
           $stmt->bind_param("ssss",$gissCom_1,$gissAgentCom_1v,$gissCompPart_1v,$contratId);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        
        public function getAgenceMaBalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `bic_contrat_marine` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
        public function getAgenceMaCNVNo($agenceId){
            $situation = 0; 
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contratNV FROM `bic_contrat_marine` WHERE `agence`=? AND `situation`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_contratNV'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
        public function getAgenceMaCVNo($agenceId){
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contratV FROM `bic_contrat_marine` WHERE `agence`=? AND `situation`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_contratV'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
        public function getConfirmresponseCiv($contratId,$sit){
           $stmt = $this->con->prepare("UPDATE `bic_contrat_rc` SET `situation`=? WHERE `Id`=?");
           $stmt->bind_param("ss",$sit,$contratId);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        public function BICvarPoliceRcByNo($contratId){
            $stmt = $this->con->prepare("SELECT `Numpol` AS max_product FROM `bic_contrat_rc` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        public function BICvarNotePrimeRcByNo($contratId){
            $stmt = $this->con->prepare("SELECT `NumCertificat` AS max_product FROM `bic_contrat_rc` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        public function BICvarAgenceRcByNo($contratId){
            $stmt = $this->con->prepare("SELECT `agence` AS max_product FROM `bic_contrat_rc` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        public function getAgenceRcBalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `bic_contrat_rc` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        public function getAgenceRcCNVNo($agenceId){
            $situation = 0; 
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contratNV FROM `bic_contrat_rc` WHERE `agence`=? AND `situation`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_contratNV'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        public function getAgenceRcCVNo($agenceId){
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contratV FROM `bic_contrat_rc` WHERE `agence`=? AND `situation`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_contratV'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
        public function getConfirmAcc($contratId,$sit){
           $stmt = $this->con->prepare("UPDATE `bic_contrat_ac` SET `Situation`=? WHERE `Id`=?");
           $stmt->bind_param("ss",$sit,$contratId);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        public function BICvarPoliceAccByNo($contratId){
            $stmt = $this->con->prepare("SELECT `Numpol` AS max_product FROM `bic_contrat_ac` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        public function BICvarNotePrimeAccByNo($contratId){
            $stmt = $this->con->prepare("SELECT `Numnoteprime` AS max_product FROM `bic_contrat_ac` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
         public function BICvarAgenceAccByNo($contratId){
            $stmt = $this->con->prepare("SELECT `agence` AS max_product FROM `bic_contrat_ac` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        public function BICvarPrimeNetAccByNo($contratId){
            $stmt = $this->con->prepare("SELECT `PN` AS max_product FROM `bic_contrat_ac` WHERE `Id`=?");
            $stmt->bind_param("s",$contratId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['max_product'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
         public function getComVarAccComV1($contratId,$gissCom_1,$gissAgentCom_1v,$gissCompPart_1v){
           $stmt = $this->con->prepare("UPDATE `bic_contrat_ac` SET `commission`=?,`part_agence`=?,`part_bic`=? WHERE `Id`=?");
           $stmt->bind_param("ssss",$gissCom_1,$gissAgentCom_1v,$gissCompPart_1v,$contratId);
           if ($stmt->execute()){
               return 1;
           }else {
               return 2;
           }
        }
        
        public function getAgenceAccBalanceNo($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `bic_contrat_ac` WHERE `agence`=? AND `Situation`=? AND `Date_emission`=? AND YEAR(`Date_emission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
        public function getAgenceAccCNVNo($agenceId,$situation){
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contratNV FROM `bic_contrat_ac` WHERE `agence`=? AND `Situation`=? AND YEAR(`Date_emission`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_contratNV'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
         public function getAgenceAccCVNo($agenceId,$situation){
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_contratV FROM `bic_contrat_ac` WHERE `agence`=? AND `Situation`=? AND YEAR(`Date_emission`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_contratV'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
        public function getAgencePoliceNo($agenceId,$gissReady){
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_police FROM `bic_chargement` WHERE `Status`=? AND `Agence`=?");
            $stmt->bind_param("ss",$gissReady,$agenceId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_police'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
       public function getAgenceCertifNo($agenceId,$gissReady){
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_certif FROM `bic_certificat` WHERE `Agence`=? AND `Status`=?");
            $stmt->bind_param("ss",$agenceId,$gissReady);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_certif'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
         public function getAgencePrimeNotNo($agenceId,$gissReady){
            $stmt = $this->con->prepare("SELECT COUNT(`Id`) AS total_prime FROM `bic_notPrime` WHERE `Agence`=? AND `Status`=?");
            $stmt->bind_param("ss",$agenceId,$gissReady);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_prime'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
        public function getComVarComVar1($gissAgence,$contratId,$gissPolice,$gissPrimeNet,$gissCom_1,$gissAgentCom_1v,$gissCompPart_1v,$date_operation){
            if ($this->isComExist($contratId)) {
                return 0;
            }else{
                $stmt = $this->con->prepare("INSERT INTO `bic_commission`(`Agence`, `ContratId`, `NumPol`, `PN`, `commission`, `part_agence`, `part_bic`,`CreatedAt`) VALUES (?,?,?,?,?,?,?,?)");
                $stmt->bind_param("ssssssss",$gissAgence,$contratId,$gissPolice,$gissPrimeNet,$gissCom_1,$gissAgentCom_1v,$gissCompPart_1v,$date_operation);
                if ($stmt->execute()){
                    return 1;
                }else {
                    return 2;
                }
            }
        }
        public function getComVarComVar2($gissAgence,$contratId,$gissPolice,$gissPrimeNet,$gissCom_2,$gissAgentCom_2v,$gissCompPart_2v,$date_operation){
              if ($this->isComExist($contratId)) {
                return 0;
            }else{
                $stmt = $this->con->prepare("INSERT INTO `bic_commission`(`Agence`, `ContratId`, `NumPol`, `PN`, `commission`, `part_agence`, `part_bic`,`CreatedAt`) VALUES (?,?,?,?,?,?,?,?)");
                $stmt->bind_param("ssssssss",$gissAgence,$contratId,$gissPolice,$gissPrimeNet,$gissCom_2,$gissAgentCom_2v,$gissCompPart_2v,$date_operation);
                if ($stmt->execute()){
                    return 1;
                }else {
                    return 2;
                }
            }
        }
        private function isComExist($contratId){
            $stmt = $this->con->prepare("SELECT `Id` FROM `bic_commission` WHERE `ContratId`= ?");
            $stmt->bind_param("s", $contratId);
            $stmt->execute();
            $stmt->store_result();
            return $stmt->num_rows > 0;
        }
          public function getAgAutoPbBalance($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `bic_contrat` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
         public function getAgAutoPNBalance($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`PN`) AS total_balance FROM `bic_contrat` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
             public function getAgAutoTVABalance($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`TVA`) AS total_balance FROM `bic_contrat` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
           public function getAgAutoFraisBalance($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`FRAIS`) AS total_balance FROM `bic_contrat` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
          public function getAgFiPbBalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `bic_contrat_fire` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
             public function getAgFiPNBalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`PN`) AS total_balance FROM `bic_contrat_fire` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
        public function getAgFiTVABalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`TVA`) AS total_balance FROM `bic_contrat_fire` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
        public function getAgFiFraisBalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`FRAIS`) AS total_balance FROM `bic_contrat_fire` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
           public function getAgenceMaPbBalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `bic_contrat_marine` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
          public function getAgenceMaPNBalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`PN`) AS total_balance FROM `bic_contrat_marine` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
            public function getAgenceMaTVABalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`TVA`) AS total_balance FROM `bic_contrat_marine` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
         public function getAgenceMaFraisBalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`FRAIS`) AS total_balance FROM `bic_contrat_marine` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
          public function getAgenceRcPbBalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `bic_contrat_rc` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
            public function getAgenceRcPNBalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`PN`) AS total_balance FROM `bic_contrat_rc` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
           public function getAgenceRcTVABalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`TVA`) AS total_balance FROM `bic_contrat_rc` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
            public function getAgenceRcFraisBalanceNo($agenceId){
            $date_operation = date("Y-m-d");
            $situation = 1; 
            $stmt = $this->con->prepare("SELECT SUM(`FRAIS`) AS total_balance FROM `bic_contrat_rc` WHERE `agence`=? AND `situation`=? AND `DateEmission`=? AND YEAR(`DateEmission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = "Pas de données disponibles";
                return $giss_getVar;
            }
        }
        
          public function getAgenceAccPbBalanceNo($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`PB`) AS total_balance FROM `bic_contrat_ac` WHERE `agence`=? AND `Situation`=? AND `Date_emission`=? AND YEAR(`Date_emission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
         public function getAgenceAccPNBalanceNo($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`PN`) AS total_balance FROM `bic_contrat_ac` WHERE `agence`=? AND `Situation`=? AND `Date_emission`=? AND YEAR(`Date_emission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
         public function getAgenceAccTVABalanceNo($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`TVA`) AS total_balance FROM `bic_contrat_ac` WHERE `agence`=? AND `Situation`=? AND `Date_emission`=? AND YEAR(`Date_emission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
       public function getAgenceAccFraisBalanceNo($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`FRAIS`) AS total_balance FROM `bic_contrat_ac` WHERE `agence`=? AND `Situation`=? AND `Date_emission`=? AND YEAR(`Date_emission`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation,$date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
            public function getAgenceCom1No($agenceId,$situation){
            $stmt = $this->con->prepare("SELECT SUM(`part_agence`) AS total_balance FROM `bic_commission` WHERE `agence`=? AND `Status`=? AND YEAR(`CreatedAt`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
           public function getAgenceCom2No($agenceId,$situation){
            $stmt = $this->con->prepare("SELECT SUM(`part_agence`) AS total_balance FROM `bic_commission` WHERE `Agence`=? AND `Status`=? AND YEAR(`CreatedAt`) = YEAR(CURDATE())");
            $stmt->bind_param("ss",$agenceId,$situation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
       public function getAgenceCom3No($agenceId){
            $stmt = $this->con->prepare("SELECT SUM(`part_agence`) AS total_balance FROM `bic_commission` WHERE `Agence`=?  AND YEAR(`CreatedAt`) = YEAR(CURDATE())");
            $stmt->bind_param("s",$agenceId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
        
           public function getAgenceCom4No($agenceId,$situation,$date_operation){
            $stmt = $this->con->prepare("SELECT SUM(`part_agence`) AS total_balance FROM `bic_commission` WHERE `Agence`=? AND `Status`=? AND  `CreatedAt`=? AND YEAR(`CreatedAt`) = YEAR(CURDATE())");
            $stmt->bind_param("sss",$agenceId,$situation, $date_operation);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                return $row['total_balance'];
            } else {
                $giss_getVar = 0;
                return $giss_getVar;
            }
        }
    
    // CONFIRMATION CONTRACT END
    
            
      
     public function paymentContratAuto($bic_comptenNumber,$bic_factureNumero,$bic_NumeroTransaction,$bic_compteSenderNumero,$bic_montantPayer,
$bic_username,$bic_agence,$bic_codeUser,$date_operation){
if ($this->isFacturationcontratAutoExist($bic_factureNumero)) {
    return 0;
}else {
$stmt = $this->con->prepare("CALL getContratFacturationAuto(?,?,?,?,?,?,?,?,?)");
$stmt->bind_param("sssssssss", $bic_comptenNumber,$bic_factureNumero,$bic_NumeroTransaction,$bic_compteSenderNumero,$bic_montantPayer,
$bic_username,$bic_agence,$bic_codeUser,$date_operation);
if ($stmt->execute()) {
   return 1;
}else {
    return 2;
}
}
}

private function isFacturationcontratAutoExist($bic_factureNumero){
$stmt = $this->con->prepare("SELECT Id FROM `bic_payment` WHERE `idFacture`=?");
$stmt->bind_param("s", $bic_factureNumero);
$stmt->execute();
$stmt->store_result();
return $stmt->num_rows > 0;
} 

     public function paymentBankAuto($bic_facture,$bic_balance,$bic_bank,$bic_bankId,$bic_bordereau,
        $bic_motif,$bic_employe,$bic_username,$bic_codeUser,$bic_agence){
if ($this->isFacturationBankAutoExist($bic_facture)) {
    return 0;
}else {
$stmt = $this->con->prepare("CALL getbankPayment(?,?,?,?,?,?,?,?,?,?)");
$stmt->bind_param("ssssssssss", $bic_facture,$bic_balance,$bic_bank,$bic_bankId,$bic_bordereau,
        $bic_motif,$bic_employe,$bic_username,$bic_codeUser,$bic_agence);
if ($stmt->execute()) {
   return 1;
}else {
    return 2;
}
}
}

private function isFacturationBankAutoExist($bic_facture){
$stmt = $this->con->prepare("SELECT Id FROM `bic_bank_payment` WHERE `facture`=?");
$stmt->bind_param("s", $bic_facture);
$stmt->execute();
$stmt->store_result();
return $stmt->num_rows > 0;
} 


             public function changeContratFire($bic_contrat,$bic_preneur,$bic_tauxCotation,$bic_police,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_ObjetAssurer,$bic_quantite,
            $bic_typebatiment,$bic_modePrevention,$bic_modeConstruction,
            $bic_numeroTitre,$bic_numeroParcelle,$bic_emplacement,$bic_nombreNiveau,
            $bic_numeroAutorisation,$bic_usage,$bic_garanti,$bic_valeurAssure,
            $bic_primeNet,$Year2,$bic_userFullname,
            $bic_userCode,$bic_agenceName){
                if ($this->isContratChangeFireExist($bic_contrat)) {
                     $stmt = $this->con->prepare("CALL getContratChangeFire(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssssssssssssssssssss", $bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,
                    $bic_dateEcheance,$bic_certificat,$bic_ObjetAssurer,$bic_quantite,$bic_typebatiment,$bic_usage,$bic_modePrevention,$bic_numeroTitre,$bic_numeroParcelle,
                    $bic_emplacement,$bic_numeroAutorisation,$bic_modeConstruction,$bic_nombreNiveau,$bic_tauxCotation,$bic_primeNet,$bic_valeurAssure,$bic_garanti,$Year2,
                    $bic_userFullname,$bic_userCode,$bic_agenceName);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                   
                }else {

                  return 0;
                }

            }

            private function isContratChangeFireExist($bic_contrat){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_fire` WHERE `Numcontrat`=?");
                $stmt->bind_param("s", $bic_contrat);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }

      
               public function changeContratMarine($bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
            $bic_certificat,$bic_natureMarchandise,$bic_taux_Cotation,$bic_numeroFacture,$bic_dateFacture,$bic_DetailArticle,
            $bic_valeurDevise,$bic_tauxChange,$bic_voie,$bic_transit,$bic_emballage,$bic_portOrigine,
            $bic_portDestination,$bic_devise,$bic_garanti,$bic_userFullname,
            $bic_agenceName,$bic_userCode,$Year2){
                if ($this->isContratChangeMarineExist($bic_contrat)) {
                       $stmt = $this->con->prepare("CALL getContratChangeMarine(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("ssssssssssssssssssssssss", $bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,
                    $bic_dateEcheance,$bic_certificat,$bic_natureMarchandise,$bic_numeroFacture,$bic_dateFacture,$bic_DetailArticle,$bic_valeurDevise,$bic_tauxChange,$bic_taux_Cotation,
                    $bic_voie,$bic_transit,$bic_emballage,$bic_portOrigine,$bic_portDestination,$bic_devise,$bic_garanti,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                   
                }else {

                 return 0;
                }

            }

            private function isContratChangeMarineExist($bic_contrat){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_marine` WHERE `Numcontrat`=?");
                $stmt->bind_param("s", $bic_contrat);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            } 
            
          /*
          $bic_juridiction,$bic_natureExploitation,$bic_descrNature,
          $bic_juridiction,$bic_natureExploitation,$bic_descrNature,
          */
             public function changeContratRC($bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
            $bic_certificat,$bic_designation,$bic_occupation,$bic_localisation,
            $bic_descrValeur,$bic_tauxCotation,$bic_usage,$bic_garanti,$bic_ValeurAssurer,
            $bic_primeNet,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2){
                if ($this->isContratChangeRCExist($bic_contrat)) {
                     $stmt = $this->con->prepare("CALL getContratChangeRC(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssssssssssssss", $bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
                    $bic_certificat,$bic_designation,$bic_occupation,$bic_localisation,
                    $bic_descrValeur,$bic_tauxCotation,$bic_usage,$bic_garanti,$bic_ValeurAssurer,
                    $bic_primeNet,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                   
                }else {

                   return 0;
                }

            }

            private function isContratChangeRCExist($bic_contrat){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_rc` WHERE `Numcontrat`=?");
                $stmt->bind_param("s", $bic_contrat);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }  
            
    public function changePreneur($bic_idPreneur,$bic_fullname,$bic_contact,$bic_residence,
        $bic_categorie, $bic_province, $bic_userFullname, $bic_agenceName, $bic_userCode){
    if ($this->isChangePreneurExist($bic_idPreneur)) {
        
         $stmt = $this->con->prepare("UPDATE `bic_preneur` SET `Nomprenom`=?,`Categorie`=?,`Phone`=?,`AddresResidence`=?,`province`=?,`Agence`=?,`username`=?,`code_user`=? WHERE `Id`=?");
        $stmt->bind_param("sssssssss", $bic_fullname,$bic_categorie,$bic_contact,$bic_residence,$bic_province,$bic_agenceName,$bic_userFullname
        ,$bic_userCode,$bic_idPreneur);
        if ($stmt->execute()) {
           return 1;
        }else {
            return 2;
        }
       
    }else {
       
        return 0;
    }

}

private function isChangePreneurExist($bic_idPreneur){
    $stmt = $this->con->prepare("SELECT Id FROM `bic_preneur` WHERE `Id`=?");
    $stmt->bind_param("s", $bic_idPreneur);
    $stmt->execute();
    $stmt->store_result();
    return $stmt->num_rows > 0;
}
            
        /*
        $bic_juridique,$bic_descriptionnature,
        $bic_juridique,$bic_descriptionnature,
        */
        public function createContratAccident($bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance, $bic_certificat,
        $bic_statio,$bic_occupation,$bic_localisation,$bic_usagio,$bic_effectif,
        $bic_nature, $bic_indeminite,$bic_tocotation,
        $bic_garanti,$bic_plafond,$bic_userFullname,$bic_userAgence,$bic_userCode,$Year2){
                if ($this->isContratAccidentExist($bic_certificat,$bic_police)) {
                   return 0;
                }else {

                    $stmt = $this->con->prepare("CALL getContratAccident(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("sssssssssssssssssss", $bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance, $bic_certificat,$bic_statio,
                    $bic_occupation,$bic_localisation,$bic_usagio,$bic_effectif,$bic_nature, $bic_indeminite,
                    $bic_tocotation,$bic_garanti,$bic_plafond,$bic_userFullname,$bic_userAgence,$bic_userCode,$Year2);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isContratAccidentExist($bic_certificat,$bic_police){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_ac` WHERE `Numnoteprime`=? OR `Numpol`=?");
                $stmt->bind_param("ss", $bic_certificat,$bic_police);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            /*
            $bic_juridique,$bic_descriptionnature,
            $bic_juridique,$bic_descriptionnature,
            */
        public function changeContratAccident($bic_contratID,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance, $bic_certificat,
        $bic_statio,$bic_occupation,$bic_localisation,$bic_usagio,$bic_effectif,
        $bic_nature, $bic_indeminite,$bic_tocotation,
        $bic_garanti,$bic_plafond,$bic_userFullname,$bic_userAgence,$bic_userCode,$Year2){
                if ($this->isContratChangeAccidentExist($bic_contratID)) {
                    
                    $stmt = $this->con->prepare("CALL getContratChangeAccident(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("ssssssssssssssssssss", $bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance, $bic_certificat,$bic_statio,
                    $bic_occupation,$bic_localisation,$bic_usagio,$bic_effectif,$bic_nature, $bic_indeminite,
                    $bic_tocotation,$bic_garanti,$bic_plafond,$bic_userFullname,$bic_userAgence,$bic_userCode,$Year2,$bic_contratID);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                   
                }else {
                    return 0;
                }

            }
            
              private function isContratChangeAccidentExist($bic_contratID){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_ac` WHERE `Numcontrat`=?");
                $stmt->bind_param("s", $bic_contratID);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }  
            
            
                function changeChangerPassword($bic_oldPass ,$bic_newPass, $bic_userCode, $date_operation){
                    $newPassword = md5($bic_newPass);
                     if ($this->isPasswordExist($bic_oldPass)) {
                $stmt = $this->con->prepare("UPDATE `code_users` SET `password`=?,`date`=? WHERE `user_id`=?");
                  $stmt->bind_param("sss", $newPassword, $date_operation, $bic_userCode);
                  if($stmt->execute()){
                      return 1;
                  }else{
                      return 2;
                 }
                     }else {
                    return 0;
                }
            }
            
            private function isPasswordExist($bic_oldPass){
                $oldPassword = md5($bic_oldPass);
                $stmt = $this->con->prepare("SELECT id_log FROM `code_users` WHERE `password`=?");
                $stmt->bind_param("s", $oldPassword);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }  
            
             function changeChangerUsername($bic_oldUser, $bic_newUser, $bic_userCode, $date_operation){
                     if ($this->isUsernameExist($bic_oldUser)) {
                $stmt = $this->con->prepare("UPDATE `code_users` SET `username`=?,`date`=? WHERE `user_id`=?");
                  $stmt->bind_param("sss", $bic_newUser, $date_operation,  $bic_userCode);
                  if($stmt->execute()){
                      return 1;
                  }else{
                      return 2;
                 }
                     }else {
                    return 0;
                }
            }
            
            private function isUsernameExist($bic_oldUser){
                $stmt = $this->con->prepare("SELECT id_log FROM `code_users` WHERE `username`=?");
                $stmt->bind_param("s", $bic_oldUser);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }  
            
            
            /* renouvellement des contrat */
            
            
             public function contratAutomobileRenouvellement($bic_contrat,$bic_preneur,$bic_categoryPreneur,$bic_dateCarteRose,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
            $bic_plateau,$bic_usage,$bic_primeNet,$bic_valeurAssure,$bic_garanti,
            $bic_userFullname,$bic_userCode,$bic_agenceName,$bic_police,$bic_exDateEcheanc,$bic_IDContrat,$Year2,$date_operation){
           $timestamp1 = strtotime($bic_exDateEcheanc); 
           $timestamp2 = strtotime($bic_dateEffet); 
           if ($timestamp1 < $timestamp2) {
           
            if ($this->isContratRenewAuto($bic_police, $date_operation)) {
                    return 3;
                }else {
            
               
                   
               $stmt = $this->con->prepare("CALL getContratAutoRenew(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("ssssssssssssssssssssssssss", $bic_preneur,$bic_categoryPreneur,$bic_police,$bic_dateCarteRose,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
            $bic_plateau,$bic_usage,$bic_primeNet,$bic_valeurAssure,$bic_garanti,$Year2,
            $bic_userFullname,$bic_userCode,$bic_agenceName,$bic_contrat,$bic_exDateEcheanc,$bic_IDContrat);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
              
         
        } 
                }else {
            return 0;
         }
     }
     
      private function isContratRenewAuto($bic_police, $date_operation){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat` WHERE `Numpol`=? AND `DateEmission`=?");
                $stmt->bind_param("ss", $bic_police, $date_operation);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
     
     
      public function contratMarineRenouvellement($bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
       $bic_certificat,$bic_natureMarchandise,$bic_taux_Cotation,$bic_numeroFacture,$bic_dateFacture,$bic_DetailArticle,
       $bic_valeurDevise,$bic_tauxChange,$bic_voie,$bic_transit,$bic_emballage,$bic_portOrigine,
       $bic_portDestination,$bic_devise,$bic_garanti,$bic_userFullname,
       $bic_agenceName,$bic_userCode,$Year2,$bic_contrat_Id,$bic_ExDateEcheance,$date_operation){
           $timestamp1 = strtotime($bic_ExDateEcheance); 
           $timestamp2 = strtotime($bic_dateEffet); 
            if ($timestamp1 < $timestamp2) {
           if ($this->isContratRenewMarine($bic_police, $date_operation)) {
                    return 3;
                }else {
                
            
              
                   
               $stmt = $this->con->prepare("CALL getContratMarineRenew(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("sssssssssssssssssssssssss", $bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,
                    $bic_dateEcheance,$bic_certificat,$bic_natureMarchandise,$bic_numeroFacture,$bic_dateFacture,$bic_DetailArticle,$bic_valeurDevise,$bic_tauxChange,$bic_taux_Cotation,
                    $bic_voie,$bic_transit,$bic_emballage,$bic_portOrigine,$bic_portDestination,$bic_devise,$bic_garanti,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2,$bic_contrat_Id);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
              
              
              
         
         
         
        } 
            }else {
            return 0;
         }
        
     }
     
     
private function isContratRenewMarine($bic_police, $date_operation){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_marine` WHERE `Numpol`=? AND `DateEmission`=?");
                $stmt->bind_param("ss", $bic_police,$date_operation);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            
            
            public function contratFireRenouvellement($bic_contrat,$bic_preneur,$bic_tauxCotation,$bic_police,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_ObjetAssurer,$bic_quantite,
            $bic_typebatiment,$bic_modePrevention,$bic_modeConstruction,
            $bic_numeroTitre,$bic_numeroParcelle,$bic_emplacement,$bic_nombreNiveau,
            $bic_numeroAutorisation,$bic_usage,$bic_garanti,$bic_valeurAssure,
            $bic_primeNet,$Year2,$bic_userFullname,
            $bic_userCode,$bic_agenceName,$bic_contrat_Id,$bic_ExDateEcheance,$date_operation){
           $timestamp1 = strtotime($bic_ExDateEcheance); 
           $timestamp2 = strtotime($bic_dateEffet); 
            if ($timestamp1 < $timestamp2) {
                
           if ($this->isContratRenewFire($bic_police, $date_operation)) {
                    return 3;
                }else {
             
               $stmt = $this->con->prepare("CALL getContratFireRenou(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("ssssssssssssssssssssssssss", $bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,
                    $bic_dateEcheance,$bic_certificat,$bic_ObjetAssurer,$bic_quantite,$bic_typebatiment,$bic_usage,$bic_modePrevention,$bic_numeroTitre,$bic_numeroParcelle,
                    $bic_emplacement,$bic_numeroAutorisation,$bic_modeConstruction,$bic_nombreNiveau,$bic_tauxCotation,$bic_primeNet,$bic_valeurAssure,$bic_garanti,$Year2,
                    $bic_userFullname,$bic_userCode,$bic_agenceName,$bic_contrat_Id);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
    
        } 
        
        
            }else {
            return 0;
         }
        
     }
     
    
            private function isContratRenewFire($bic_police, $date_operation){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_fire` WHERE `Numpol`=? AND `DateEmission`=?");
                $stmt->bind_param("ss", $bic_police,$date_operation);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            } 
            
            
        /*
        $bic_juridiction,$bic_natureExploitation,$bic_descrNature,
        $bic_juridiction,$bic_natureExploitation,$bic_descrNature,
        */
        public function ContratRCRenouvellement($bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
            $bic_certificat,$bic_designation,$bic_occupation,$bic_localisation,
            $bic_descrValeur,$bic_tauxCotation,$bic_usage,$bic_garanti,$bic_ValeurAssurer,
            $bic_primeNet,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2,$bic_contrat_Id,$bic_ExDateEcheance,$date_operation){
        $timestamp1 = strtotime($bic_ExDateEcheance); 
           $timestamp2 = strtotime($bic_dateEffet); 
            if ($timestamp1 < $timestamp2) {
        if ($this->isContratRenewRC($bic_police, $date_operation)) {
            return 3;
        }else {
            
           $stmt = $this->con->prepare("CALL getContratRCRenou(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("ssssssssssssssssssss", $bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
                    $bic_certificat,$bic_designation,$bic_occupation,$bic_localisation,
                    $bic_descrValeur,$bic_tauxCotation,$bic_usage,$bic_garanti,$bic_ValeurAssurer,
                    $bic_primeNet,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2,$bic_contrat_Id);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
            
            
        }
         
            }else {
            return 0;
         }
         
    }

    private function isContratRenewRC($bic_police, $date_operation){
        $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_rc` WHERE `Numpol`=? AND `DateEmission`=?");
        $stmt->bind_param("ss", $bic_police, $date_operation);
        $stmt->execute();
        $stmt->store_result();
        return $stmt->num_rows > 0;
    }    
           
           
           /*
           $bic_juridique,$bic_descriptionnature,
           ,$bic_juridique,$bic_descriptionnature
           */
           
               public function contratAccidentRenouvellement($bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance, $bic_certificat,
        $bic_statio,$bic_occupation,$bic_localisation,$bic_usagio,$bic_effectif,
        $bic_nature, $bic_indeminite,$bic_tocotation,
        $bic_garanti,$bic_plafond,$bic_userFullname,$bic_userAgence,$bic_userCode,$Year2,$bic_contrat_Id,$bic_ExDateEcheance,$date_operation){
        $timestamp1 = strtotime($bic_ExDateEcheance); 
           $timestamp2 = strtotime($bic_dateEffet); 
            if ($timestamp1 < $timestamp2) {
        if ($this->isContratRenewAccident($bic_police, $date_operation)) {
            return 3;
        }else {
            
           $stmt = $this->con->prepare("CALL getContratAccidentRenou(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("sssssssssssssssssssss", $bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance, $bic_certificat,$bic_statio,
                    $bic_occupation,$bic_localisation,$bic_usagio,$bic_effectif,$bic_nature, $bic_indeminite,
                    $bic_tocotation,$bic_garanti,$bic_plafond,$bic_userFullname,$bic_userAgence,$bic_userCode,$Year2,$bic_contrat_Id);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
            
            
        }
         
            }else {
            return 0;
         }
         
    }
    

    private function isContratRenewAccident($bic_police, $date_operation){
        $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_ac` WHERE `Numpol`=? AND `Date_emission`=?");
        $stmt->bind_param("ss", $bic_police, $date_operation);
        $stmt->execute();
        $stmt->store_result();
        return $stmt->num_rows > 0;
    }        
           
           
           
           
            
            
      
     
     
     
     public function changeContratAutoRenouveller($bic_contrat,$bic_preneur,$bic_categoryPreneur,$bic_dateCarteRose,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
            $bic_plateau,$bic_usage,$bic_primeNet,$bic_valeurAssure,$bic_garanti, $bic_userFullname,$bic_userCode,$bic_agenceName
            ,$bic_police,$bic_IDContrat,$Year2,$date_operation,$bic_ContratNumDATA){
        if ($this->isContratChangeAutoRenouvellerExist($bic_police, $date_operation)) {
            
            // if ($bic_exDateEcheanc < $bic_dateEffet) {
            
               $stmt = $this->con->prepare("CALL getContratChangeAutoRenew(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("ssssssssssssssssssssssssss", $bic_preneur,$bic_categoryPreneur,$bic_police,$bic_dateCarteRose,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_plaque,$bic_categoryPlaque,$bic_chassis,$bic_dateFabrication,$bic_model,$bic_puissance,$bic_cabine,
            $bic_plateau,$bic_usage,$bic_primeNet,$bic_valeurAssure,$bic_garanti,$Year2,
            $bic_userFullname,$bic_userCode,$bic_agenceName,$bic_contrat,$bic_IDContrat,$bic_ContratNumDATA);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
            
            /* }else {
            return 0;
         } */
            
        }else {
            return 3;
         }
    }

    private function isContratChangeAutoRenouvellerExist($bic_police, $date_operation){
        $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat` WHERE `Numpol`=? AND `DateEmission`=?");
        $stmt->bind_param("ss", $bic_police, $date_operation);
        $stmt->execute();
        $stmt->store_result();
        return $stmt->num_rows > 0;
    }
    
    
    
     public function changeContratMarineRenouveller($bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
       $bic_certificat,$bic_natureMarchandise,$bic_taux_Cotation,$bic_numeroFacture,$bic_dateFacture,$bic_DetailArticle,
       $bic_valeurDevise,$bic_tauxChange,$bic_voie,$bic_transit,$bic_emballage,$bic_portOrigine,
       $bic_portDestination,$bic_devise,$bic_garanti,$bic_userFullname,
       $bic_agenceName,$bic_userCode,$Year2,$bic_contrat_Id,$bic_ContratNumDATA,$date_operation){
        if ($this->isContratChangeMarineRenouvellerExist($bic_police, $date_operation)) {
            
            // if ($bic_exDateEcheanc < $bic_dateEffet) {
            
               $stmt = $this->con->prepare("CALL getContratChangeMarineRenew(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("ssssssssssssssssssssssssss", $bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,
                    $bic_dateEcheance,$bic_certificat,$bic_natureMarchandise,$bic_numeroFacture,$bic_dateFacture,$bic_DetailArticle,$bic_valeurDevise,$bic_tauxChange,$bic_taux_Cotation,
                    $bic_voie,$bic_transit,$bic_emballage,$bic_portOrigine,$bic_portDestination,$bic_devise,$bic_garanti,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2,$bic_contrat_Id,$bic_ContratNumDATA);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
            
            /* }else {
            return 0;
         } */
            
        }else {
            return 3;
         }
    }

    private function isContratChangeMarineRenouvellerExist($bic_police, $date_operation){
        $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_marine` WHERE `Numpol`=? AND `DateEmission`=?");
        $stmt->bind_param("ss", $bic_police, $date_operation);
        $stmt->execute();
        $stmt->store_result();
        return $stmt->num_rows > 0;
    }
    

    
      public function changeContratFireRenouveller($bic_contrat,$bic_preneur,$bic_tauxCotation,$bic_police,$bic_dateEffet,
            $bic_dateEcheance,$bic_certificat,$bic_ObjetAssurer,$bic_quantite,
            $bic_typebatiment,$bic_modePrevention,$bic_modeConstruction,
            $bic_numeroTitre,$bic_numeroParcelle,$bic_emplacement,$bic_nombreNiveau,
            $bic_numeroAutorisation,$bic_usage,$bic_garanti,$bic_valeurAssure,
            $bic_primeNet,$Year2,$bic_userFullname,
            $bic_userCode,$bic_agenceName,$bic_contrat_Id,$bic_ContratNumDATA,$date_operation){
        if ($this->isContratChangeFireRenouvellerExist($bic_police, $date_operation)) {
            
            // if ($bic_exDateEcheanc < $bic_dateEffet) {
            
               $stmt = $this->con->prepare("CALL getContratChangeFireRenew(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("sssssssssssssssssssssssssss", $bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,
                    $bic_dateEcheance,$bic_certificat,$bic_ObjetAssurer,$bic_quantite,$bic_typebatiment,$bic_usage,$bic_modePrevention,$bic_numeroTitre,$bic_numeroParcelle,
                    $bic_emplacement,$bic_numeroAutorisation,$bic_modeConstruction,$bic_nombreNiveau,$bic_tauxCotation,$bic_primeNet,$bic_valeurAssure,$bic_garanti,$Year2,
                    $bic_userFullname,$bic_userCode,$bic_agenceName,$bic_contrat_Id,$bic_ContratNumDATA);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
            
            /* }else {
            return 0;
         } */
            
        }else {
            return 3;
         }
    }

    private function isContratChangeFireRenouvellerExist($bic_police, $date_operation){
        $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_fire` WHERE `Numpol`=? AND `DateEmission`=?");
        $stmt->bind_param("ss", $bic_police, $date_operation);
        $stmt->execute();
        $stmt->store_result();
        return $stmt->num_rows > 0;
    }
     
     /*
     $bic_juridiction,$bic_natureExploitation,$bic_descrNature,
     $bic_juridiction,$bic_natureExploitation,$bic_descrNature,
     */
     
           public function changeContratRCRenouveller($bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
       $bic_certificat,$bic_designation,$bic_occupation,$bic_localisation,
       $bic_descrValeur,$bic_tauxCotation,$bic_usage,$bic_garanti,$bic_ValeurAssurer,
       $bic_primeNet,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2,$bic_contrat_Id,$bic_ContratNumDATA,$date_operation){
        if ($this->isContratChangeRCRenouvellerExist($bic_police, $date_operation)) {
            
            // if ($bic_exDateEcheanc < $bic_dateEffet) {
            
             
             
               $stmt = $this->con->prepare("CALL getContratChangeRCRenew(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("sssssssssssssssssssss", $bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance,
                    $bic_certificat,$bic_designation,$bic_occupation,$bic_localisation,
                    $bic_descrValeur,$bic_tauxCotation,$bic_usage,$bic_garanti,$bic_ValeurAssurer,
                    $bic_primeNet,$bic_userFullname,$bic_agenceName,$bic_userCode,$Year2,$bic_contrat_Id,$bic_ContratNumDATA);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
            
            /* }else {
            return 0;
         } */
            
        }else {
           
            
            return 3;
             
            
         }
    }

    private function isContratChangeRCRenouvellerExist($bic_police, $date_operation){
        $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_rc` WHERE `Numpol`=? AND `DateEmission`=?");
        $stmt->bind_param("ss", $bic_police, $date_operation);
        $stmt->execute();
        $stmt->store_result();
        return $stmt->num_rows > 0;
    }
     
    /*
    $bic_juridique,$bic_descriptionnature,
    $bic_juridique,$bic_descriptionnature,
    */
               public function changeContratAccidentRenouveller($bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance, $bic_certificat,
        $bic_statio,$bic_occupation,$bic_localisation,$bic_usagio,$bic_effectif,
        $bic_nature, $bic_indeminite,$bic_tocotation,
        $bic_garanti,$bic_plafond,$bic_userFullname,$bic_userAgence,$bic_userCode,$Year2,$bic_contrat_Id,$bic_ContratNumDATA,$date_operation){
        if ($this->isContratChangeAccidentRenouvellerExist($bic_police, $date_operation)) {
            
            // if ($bic_exDateEcheanc < $bic_dateEffet) {
            
             
             
               $stmt = $this->con->prepare("CALL getContratChangeAccidentRenew(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("ssssssssssssssssssssss", $bic_contrat,$bic_preneur,$bic_police,$bic_dateEffet,$bic_dateEcheance, $bic_certificat,$bic_statio,
                    $bic_occupation,$bic_localisation,$bic_usagio,$bic_effectif,$bic_nature, $bic_indeminite,
                    $bic_tocotation,$bic_garanti,$bic_plafond,$bic_userFullname,$bic_userAgence,$bic_userCode,$Year2,$bic_contrat_Id,$bic_ContratNumDATA);
            if ($stmt->execute()) {
               return 1;
            }else {
                return 2;
            }
            
            /* }else {
            return 0;
         } */
            
        }else {
           
            
            return 3;
             
            
         }
    }

    private function isContratChangeAccidentRenouvellerExist($bic_police, $date_operation){
       $stmt = $this->con->prepare("SELECT Id FROM `bic_contrat_ac` WHERE `Numpol`=? AND `Date_emission`=?");
        $stmt->bind_param("ss", $bic_police, $date_operation);
        $stmt->execute();
        $stmt->store_result();
        return $stmt->num_rows > 0;
    } 
       public  function initDesiredYear() {
            $desired_year = date('Y'); 
             return $desired_year;
        }
        public function mobicGetListPolice($aganceName,$situation,$desired_year){
                 $stmt = $this->con->prepare("SELECT * FROM `bic_contrat` WHERE YEAR(`DateEmission`)=? AND `agence`=? AND `situation`=?");
                 $stmt->bind_param("sss", $desired_year,$aganceName, $situation);
                 $stmt->execute();
                 $result = $stmt->get_result();
                 $police_var = array();
                 while ($row = $result->fetch_assoc()) {
                        $police_var[] = $row;
                }
                
                return $police_var;
            }
    

     
            
     /*    
              function deleteMember($ibanga_userName,$ibanga_codeUser,$ibanga_from){
                $stmt = $this->con->prepare("DELETE FROM `members` WHERE `id_log`=? AND `user_name`=? AND `code_user`=?");
                  $stmt->bind_param("sss", $ibanga_from, $ibanga_userName, $ibanga_codeUser);
                  if($stmt->execute()){
                      return 1;
                  }else{
                      return 2;
                          }
            }
            
               function updateMemmber($ibanga_fullname, $ibanga_adresses, $ibanga_contact,$ibanga_userName,$ibanga_codeUser,$ibanga_from){
                $stmt = $this->con->prepare("UPDATE `members` SET `fullname`=?,`adresses`=?,`contact`=? WHERE `id_log`=? AND `user_name`=? AND `code_user`=?");
                  $stmt->bind_param("ssssss", $ibanga_fullname, $ibanga_adresses, $ibanga_contact, $ibanga_from, $ibanga_userName, $ibanga_codeUser);
                  if($stmt->execute()){
                      return 1;
                  }else{
                      return 2;
                 }
            }
            
             function createOperationCreditTx($ibanga_to, $ibanga_target, $ibanga_balance, $ibanga_situation, $ibanga_username, $ibanga_userCode,$ibanga_from){
             
             $stmt = $this->con->prepare("INSERT INTO `operation_credit_tx`(`member`, `description`, `process`, `situation`, `user_name`, `user_code`) 
                VALUES (?,?,?,?,?,?)");
                  $stmt->bind_param("ssssss",$ibanga_to, $ibanga_target, $ibanga_balance, $ibanga_situation, $ibanga_username, $ibanga_userCode);
                  
                  $stmtUp = $this->con->prepare("UPDATE `operation_credit` SET `remain`= `remain` - ?,`process`= `process` + ?, `situation`=? WHERE `id_log`=?");
                  $stmtUp->bind_param("ssss",$ibanga_balance, $ibanga_balance, $ibanga_situation, $ibanga_from);

                  if($stmt->execute() && $stmtUp->execute()){
                      return 1;
                  }else{
                      return 2;
                 }
           }
            
             function createOperationDebtTx($ibanga_to, $ibanga_target, $ibanga_balance, $ibanga_situation, $ibanga_username, $ibanga_userCode,$ibanga_from){
             
             $stmt = $this->con->prepare("INSERT INTO `operation_debt_tx`(`member`, `description`, `process`, `situation`, `user_name`, `user_code`) 
                VALUES (?,?,?,?,?,?)");
                  $stmt->bind_param("ssssss",$ibanga_to, $ibanga_target, $ibanga_balance, $ibanga_situation, $ibanga_username, $ibanga_userCode);
                  
                  $stmtUp = $this->con->prepare("UPDATE `operation` SET `remain`= `remain` - ?,`process`= `process` + ?, `situation`=? WHERE `id_log`=?");
                  $stmtUp->bind_param("ssss",$ibanga_balance, $ibanga_balance, $ibanga_situation, $ibanga_from);

                  if($stmt->execute() && $stmtUp->execute()){
                      return 1;
                  }else{
                      return 2;
                 }
           }
            
            
             function updateCreditOperation($ibanga_member, $ibanga_target, $ibanga_balance,$ibanga_from){
                $stmt = $this->con->prepare("UPDATE `operation_credit` SET `member`=?,`description`=?,`balance`=?,`remain`=?  WHERE `id_log`=?");
                  $stmt->bind_param("sssss",$ibanga_member, $ibanga_target, $ibanga_balance, $ibanga_balance, $ibanga_from);
                  if($stmt->execute()){
                      return 1;
                  }else{
                      return 2;
                          }
            }
            
               function updateDebtOperation($ibanga_member, $ibanga_target, $ibanga_balance, $ibanga_from){
                $stmt = $this->con->prepare("UPDATE `operation` SET `member`=?,`description`=?,`balance`=? ,`remain`=? WHERE `id_log`=?");
                  $stmt->bind_param("sssss",$ibanga_member, $ibanga_target, $ibanga_balance, $ibanga_balance, $ibanga_from);
                  if($stmt->execute()){
                      return 1;
                  }else{
                      return 2;
                          }
            }
            
            function createOperationCredit($ibanga_member, $ibanga_target, $ibanga_balance, $ibanga_situation, $ibanga_username, $ibanga_userCode){
                $stmt = $this->con->prepare("INSERT INTO `operation_credit`(`member`, `description`, `balance`, `remain`, `situation`, `user_name`, `user_code`) 
                VALUES (?,?,?,?,?,?,?)");
                  $stmt->bind_param("sssssss",$ibanga_member, $ibanga_target, $ibanga_balance, $ibanga_balance, $ibanga_situation, $ibanga_username, $ibanga_userCode);
                  if($stmt->execute()){
                      return 1;
                  }else{
                      return 2;
                          }
                 }
            
              function createOperation($ibanga_member, $ibanga_target, $ibanga_balance, $ibanga_situation, $ibanga_username, $ibanga_userCode){
                $stmt = $this->con->prepare("INSERT INTO `operation`(`member`, `description`, `balance`, `remain`, `situation`, `user_name`, `user_code`) 
                VALUES (?,?,?,?,?,?,?)");
                  $stmt->bind_param("sssssss",$ibanga_member, $ibanga_target, $ibanga_balance, $ibanga_balance, $ibanga_situation, $ibanga_username, $ibanga_userCode);
                  if($stmt->execute()){
                      return 1;
                  }else{
                      return 2;
                          }
                 }
            
             function createMember($ibanga_fullname, $ibanga_addresses, $ibanga_phone, $ibanga_username, $ibanga_userCode){
                if($this->isMemberExist($ibanga_fullname)){
                        return 0;
                }else{
               $stmt = $this->con->prepare("INSERT INTO `members`(`fullname`, `adresses`, `contact`, `user_name`, `code_user`) 
               VALUES (?,?,?,?,?)");
                 $stmt->bind_param("sssss",$ibanga_fullname, $ibanga_addresses, $ibanga_phone, $ibanga_username, $ibanga_userCode);
                 if($stmt->execute()){
                     return 1;
                 }else{
                     return 2;
                         }
                     }
                }
            private function isMemberExist($ibanga_fullname, $ibanga_addresses, $ibanga_phone){
                $stmt = $this->con->prepare("SELECT id_log FROM `members` WHERE `fullname`=? OR `contact`=? OR `adresses`=?");
                $stmt->bind_param("sss", $ibanga_fullname, $ibanga_phone, $ibanga_addresses);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }
            
            private function isMemberExist($ibanga_fullname){
                $stmt = $this->con->prepare("SELECT id_log FROM `members` WHERE `fullname`=?");
                $stmt->bind_param("s", $ibanga_fullname);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }

            
            function createUser($ibanga_username, $ibanga_password,$ibanga_phone,$ibanga_fullname,$random_ibanga_code){
                if($this->isUserExist($ibanga_username, $ibanga_phone, $ibanga_fullname)){
                        return 0;
                }else{
                $password = md5($ibanga_password);
                $stmt = $this->con->prepare("INSERT INTO `code_user`(`username`, `password`, `phone`, `fullname`, `code`)
                 VALUES (?,?,?,?,?);");
                 $stmt->bind_param("sssss",$ibanga_username, $password,$ibanga_phone, $ibanga_fullname, $random_ibanga_code);
                 if($stmt->execute()){
                     return 1;
                 }else{
                     return 2;
                 }
            }
        }
            private function isUserExist($ibanga_username, $ibanga_phone, $ibanga_fullname){
                $stmt = $this->con->prepare("SELECT id_log FROM `code_user` WHERE `username`=? OR `phone`=? OR `fullname`=?");
                $stmt->bind_param("sss", $ibanga_username, $ibanga_phone, $ibanga_fullname);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }*/
        }
?>