<?php
require_once('../fpdfLib/fpdf.php');
//require_once('../config/db_connection.php'); // Include your database connection
require_once('../includes/DGenerators.php');

class InsuranceCardPDF extends FPDF {
    private $cardData;
    
    public function __construct($data) {
        parent::__construct('P', 'mm', 'A4'); // Portrait A4 (210x297mm)
        $this->cardData = $data;
    }
    
    public function generate() {
        $this->AddPage();
        
        // Left card (10mm from left edge)
        $this->addCard(10);
        
        // Right card (100mm from left edge - adjust spacing as needed)
        $this->addCard(100);
        
        return $this->Output('S');
    }
    
    private function addCard($xOffset) {
        $this->SetFont('Arial', '', 10);
        $lh = 6; // Line height
        
        // Company Header
        $this->SetXY($xOffset + 20, 20);
        $this->Cell(36, $lh, strtoupper($this->cardData['company_name']), 0, 1);
        
        // Dates
        $this->SetXY($xOffset + 20, 30);
        $this->Cell(30, $lh, $this->formatDate($this->cardData['DateEffet']), 0, 0);
        $this->Cell(30, $lh, $this->formatDate($this->cardData['DateEcheance']), 0, 1);
        
        // Times
        $this->SetXY($xOffset + 20, 36);
        $this->Cell(30, $lh, $this->cardData['timeCreation'], 0, 0);
        $this->Cell(30, $lh, $this->cardData['expiry_time'], 0, 1);
        
        // Client Information
        $this->SetXY($xOffset + 20, 45);
        $this->Cell(60, $lh, strtoupper($this->cardData['Proprietaire']), 0, 1);
        
        $this->SetXY($xOffset + 20, 55);
        $this->Cell(60, $lh, strtoupper($this->cardData['province']), 0, 1);
        
        // Policy Information
        $this->SetXY($xOffset + 20, 65);
        $this->Cell(60, $lh, $this->cardData['Numpol'], 0, 1);
        
        // Vehicle Information
        $this->SetXY($xOffset + 20, 71);
        $this->Cell(30, $lh, strtoupper($this->cardData['ClassMarkModel']), 0, 0);
        $this->Cell(30, $lh, '', 0, 1);
        
        // Plate Number
        $this->SetXY($xOffset + 20, 77);
        $this->Cell(60, $lh, $this->cardData['Plaque'], 0, 1);
        
        // Chassis Number
        $this->SetXY($xOffset + 20, 83);
        $this->Cell(80, $lh, $this->cardData['NumChasis'], 0, 1);
        
        // Insurance Type
        $this->SetXY($xOffset + 20, 89);
        $this->Cell(60, $lh, $this->cardData['UsageAuto'], 0, 1);
        
        // Card Count
        $this->SetXY($xOffset + 20, 97);
        $this->Cell(20, $lh, $this->cardData['PaleSeatCabine'], 0, 0);
        $this->Cell(20, $lh, $this->cardData['SeatPlacePlato'], 0, 1);
    }
    
    private function formatDate($dateString) {
        return date('d/m/Y', strtotime($dateString));
    }
}

// Database Connection and Data Fetching
try {
    $id = $_GET['id'] ?? 0;
    $dbOps = new DGenerators();
    $cardData = $dbOps->getInsuranceCardData($id);
    
    // Generate PDF
    $pdfGenerator = new InsuranceCardPDF($cardData);
    $pdfContent = $pdfGenerator->generate();
    
    // Output to browser
    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="insurance_card_'.$id.'.pdf"');
    echo $pdfContent;
    
} catch (Exception $e) {
    header('Content-Type: text/plain');
    http_response_code(400);
    echo "Error: " . $e->getMessage();
}