<?php
require_once 'InvoicePDFv4.php';
require_once('../includes/DGenerators.php');
try {
    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;
    if ($id <= 0) throw new Exception("Invalid ID parameter");
    
    // Get data from database
    $dbOps = new DGenerators();
    $invoiceData = $dbOps->getInsuranceIncInvoice($id);
    
    // Generate PDF  InvoicePDF
    $pdfGenerator = new InvoicePDFv4($invoiceData);
    $pdfContent = $pdfGenerator->generate();
    
    // Output to browser
    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="invoice_'.$id.'.pdf"');
    echo $pdfContent;

} catch (Exception $e) {
    header('Content-Type: text/plain');
    http_response_code(400);
    echo "Error: " . $e->getMessage();
}
