<?php
require_once('../fpdfLib/fpdf.php');
require_once('../includes/DGenerators.php');

class InvoicePDFv5 extends FPDF {
    private $data;
    // private $headerImage = 'path/to/header.png';
    // private $footerImage = 'path/to/footer.png';
    private $headerImage = 'ressources/img/header1s.png';
    private $footerImage = 'ressources/img/footer1s.png';
    private $leftMargin = 15;
    private $rightMargin = 15;
    private $cardWidth = 120;
    private $headerHeight = 8;
    
    public function __construct($data) {
        parent::__construct('L', 'mm', 'A4'); // Landscape A4 (297x210mm)
        $this->data = $data;
    }
    
    public function generate() {
        $this->AddPage();
        
        // First invoice (left side)
        $this->generateInvoice($this->leftMargin);
        
        // Second invoice (right side)
        $this->generateInvoice($this->leftMargin + $this->cardWidth + 20);
        
        return $this->Output('S');
    }
    
    private function generateInvoice($xOffset) {
        
        // Header Image (full width)
        
         if(file_exists($this->headerImage)) {
            $this->Image($this->headerImage, $xOffset, 5, $this->cardWidth);
        }
        
        // Invoice content starting position
        $this->SetY($this->headerHeight + 20);
        
        // Invoice number and date
        $this->SetFont('Arial', 'B', 8);
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth, 6, 'NOTE DE FACTURE No. '.$this->data['Facture'].' DU '.$this->formatDate($this->data['Date_emission']), 0, 1, 'C');
        $this->Ln(1);
        
        // Seller information
        $this->SetFont('Arial', 'B', 7);
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth, 6, 'A. IDENTIFICATION DU VENDEUR', 0, 1);
        
        $this->SetFont('Arial', '', 8);
        $this->createInfoTable($xOffset, [
            ['Raison Sociale :', $this->data['company_name'], 'Centre Fiscal :', 'DGC'],
            ['NIF :', $this->data['company_NIF'], 'Secteur d\'activite :', 'Assurance'],
            ['Registre du Commerce :', '08794', 'Forme juridique :', 'SA'],
            ['BP :', '362', 'Commune :', 'MUKAZA'],
            ['Quartier :', 'ROHERO 1.', 'Avenue de :', 'l\'ONU No.6'],
            ['Assujetti a la TVA :', 'OUI', 'Commentaire :', 'Ass. MARINE']
        ]);
        $this->Ln(1);
        
        // Client information
        $this->SetFont('Arial', 'B', 7);
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth, 6, 'A. LE CLIENT', 0, 1);
        
        $this->SetFont('Arial', '', 8);
        $this->createInfoTable($xOffset, [
            ['Raison Sociale :', $this->data['Proprietaire'], 'NIF :', $this->data['NIF']],
           // ['NIF :', $this->data['NIF'], '', ''],
            ['Resident a :', $this->data['residence'], 'Assujetti a la TVA :', ''],
           // ['Assujetti a la TVA :', $this->data['TVA'], '', ''],
          //  ['Mode de Paiement :', $this->data['mode_payment'], '', ''],
            ['Num Police :', $this->data['Numpol'], 'Mode de Paiement :', $this->data['mode_payment']],
            ['Classe d\'assurance :', $this->data['CatProprietaire'], 'Beneficiaire :', $this->data['Proprietaire']],
            //['Beneficiaire :', $this->data['Proprietaire'], '', ''],
            ['Periode de Couverture du ', $this->formatDate($this->data['Date_effet']), ' au ', $this->formatDate($this->data['Date_Echeance'])]
        ]);
        $this->Ln(1);
        
        // Invoice items
        $this->SetFont('Arial', 'B', 8);
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth, 6, 'Votre compte a ete debite comme suit:', 0, 1);
        
        $this->SetFont('Arial', '', 8);
        $this->createItemsTable($xOffset, [
            ['Description', 'Montant'],
            ['Prime', $this->formatNumber($this->data['PN'])],
            ['Rabais', $this->formatNumber($this->data['RAB'])],
            ['Frais administratifs', $this->formatNumber($this->data['FRAIS'])],
            ['CD+ARCA+FAPS', $this->formatNumber($this->data['CD'])],
            ['TVA (18% de la Prime)', $this->formatNumber($this->data['TVA'])],
            [$this->convertAmountToWords($this->data['PB']), $this->formatNumber($this->data['PB'])]
        ]);
        $this->Ln(5);
        
        // Footer
        
        
        // Footer
    
        
        
        $this->SetFont('Arial', '', 8);
        // First line: "Préparé par" and "Pour Business Insurance..."
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth/2, 4, 'Prepare par :', 0, 0); // Left-aligned
        $this->Cell($this->cardWidth/2, 4, 'Pour Business Insurance and Reinsurance Company', 0, 1, 'R'); // Right-aligned
        
        // Second line: Creator name and "Autorisé par"
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth/2, 4, $this->data['Creator'], 0, 0); // Left-aligned
        $this->Cell($this->cardWidth/2, 4, 'Autorise par :', 0, 1, 'R'); // Right-aligned
        
        
        /*$this->SetX($xOffset);
        $this->Cell($this->cardWidth, 4, 'Prepare par : ',0, 1);
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth, 4, $this->data['Creator'],0, 1);
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth, 4, 'Pour Business Insurance and Reinsurance Company', 0, 1);
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth, 4, 'Autorise par :', 0, 1);*/
        
        $this->Ln(5);
        
        $this->SetFont('Arial', '', 8);
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth, 4, 'MGlobal|Sn|EBMS: '.$this->data['signature'], 0, 1);
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth, 4, 'E: info@bic.bi | W: www.bic.bi | T: 00257 22 28 94 05/06/07 | ', 0, 1);
        // $this->SetX($xOffset);
        // $this->Cell($this->cardWidth, 3, 'T: +257 22289406', 0, 1);
        $this->SetX($xOffset);
        $this->Cell($this->cardWidth, 4, 'Compte BANCOBU: 02552720102-44 BGF: 202870090006 BIJE: 0120101000613 CRDB: 0150807167000', 0, 1);
        
        // Footer Image (if needed)
        // if(file_exists($this->footerImage)) {
        //     $this->Image($this->footerImage, 10, 180, 277);
        // }
        
        // if(file_exists($this->footerImage)) {
        //     $this->Image($this->footerImage, $xOffset, 180, $this->cardWidth);
        // }
    }
    
    private function createInfoTable($xOffset, $rows) {
        // Remove fill and draw colors
        $this->SetFillColor(255, 255, 255); // White background
        $this->SetDrawColor(255, 255, 255); // White borders (invisible)
        
        foreach($rows as $row) {
            $this->SetX($xOffset);
            // Remove border by changing last parameter from 1 to 0
            $this->Cell(35, 5, $row[0], 0, 0, 'L'); // Removed fill parameter
            $this->Cell(30, 5, $row[1], 0, 0, 'L');
            
            if(isset($row[2])) {
                $this->Cell(35, 5, $row[2], 0, 0, 'L'); // Removed fill parameter
                $this->Cell(30, 5, $row[3], 0, 1, 'L');
            } else {
                $this->Cell(80, 5, '', 0, 1, 'L');
            }
        }
    }
    
   /* private function createInfoTable($xOffset, $rows) {
        $this->SetFillColor(240, 240, 240);
        $this->SetDrawColor(200, 200, 200);
        
        foreach($rows as $row) {
            $this->SetX($xOffset);
            $this->Cell(35, 5, $row[0], 1, 0, 'L', true);
            $this->Cell(30, 5, $row[1], 1, 0, 'L');
            
            if(isset($row[2])) {
                $this->Cell(35, 5, $row[2], 1, 0, 'L', true);
                $this->Cell(30, 5, $row[3], 1, 1, 'L');
            } else {
                $this->Cell(80, 5, '', 1, 1, 'L');
            }
        }
    }*/
    
    private function createItemsTable($xOffset, $rows) {
        $this->SetFillColor(240, 240, 240);
        $this->SetDrawColor(200, 200, 200);
        
        // Header
        $this->SetX($xOffset);
        $this->Cell(80, 5, $rows[0][0], 1, 0, 'C', true);
        $this->Cell(50, 5, $rows[0][1], 1, 1, 'C', true);
        
        // Items
        for($i = 1; $i < count($rows); $i++) {
            $this->SetX($xOffset);
            $this->Cell(80, 5, $rows[$i][0], 1, 0, 'L');
            $this->Cell(50, 5, $rows[$i][1], 1, 1, 'R');
        }
    }
    
    private function formatDate($dateString) {
        return date('d/m/Y', strtotime($dateString));
    }
    
    private function formatNumber($number) {
        return number_format($number, 2, ',', ' ');
    }
    
    private function convertAmountToWords($amount) {
        $whole = floor($amount);
        $fraction = round(($amount - $whole) * 100);
        
        $converter = new NumberFormatter('fr', NumberFormatter::SPELLOUT);
        $words = $converter->format($whole);
        
        // Convert to proper French wording for invoices
        $words = str_replace(
            ['un', 'deux', 'trois', 'quatre', 'cinq', 'six', 'sept', 'huit', 'neuf', 'dix',
             'onze', 'douze', 'treize', 'quatorze', 'quinze', 'seize', 'vingt', 'trente',
             'quarante', 'cinquante', 'soixante', 'cent', 'mille', 'million', 'milliard'],
            ['un', 'deux', 'trois', 'quatre', 'cinq', 'six', 'sept', 'huit', 'neuf', 'dix',
             'onze', 'douze', 'treize', 'quatorze', 'quinze', 'seize', 'vingt', 'trente',
             'quarante', 'cinquante', 'soixante', 'cent', 'mille', 'million', 'milliard'],
            $words
        );
        
        // Handle fractions (centimes)
        if ($fraction > 0) {
            $words .= ' virgule ' . $converter->format($fraction);
        }
        
        // Convert to lowercase and remove hyphens (common in French invoices)
        $words = str_replace('-', ' ', strtolower($words));
        
        // Special cases
        $words = str_replace(
            ['vingt un', 'vingt deux', 'vingt trois', 'vingt quatre', 'vingt cinq',
             'vingt six', 'vingt sept', 'vingt huit', 'vingt neuf',
             'soixante et un', 'soixante et onze'],
            ['vingt-et-un', 'vingt-deux', 'vingt-trois', 'vingt-quatre', 'vingt-cinq',
             'vingt-six', 'vingt-sept', 'vingt-huit', 'vingt-neuf',
             'soixante-et-un', 'soixante-et-onze'],
            $words
        );
        
        return $words;
    }
    
}