<?php
require_once('../fpdfLib/fpdf.php');

class PDF extends FPDF {
    function addCard($xOffset) {
        $this->SetFont('Arial', '', 10);
        
        // Line height
        $lh = 6;

        // Header
        $this->SetXY($xOffset + 20, 20);
        $this->Cell(36, $lh, 'BIC SA', 0, 1);
        
        // Dates
        $this->SetXY($xOffset + 20, 30);
        $this->Cell(30, $lh, '02/07/2025', 0, 0);
        $this->Cell(30, $lh, '01/10/2025', 0, 1);

        // Times
        $this->SetXY($xOffset + 20, 36);
        $this->Cell(30, $lh, '19:24:3', 0, 0);
        $this->Cell(30, $lh, '23:59:59', 0, 1);

        // Name
        $this->SetXY($xOffset + 20, 45);
        $this->Cell(60, $lh, 'NDEREYIMANA DEO', 0, 1);

        // Location
        $this->SetXY($xOffset + 20, 55);
        $this->Cell(60, $lh, 'Bujunbura', 0, 1);

        // Registration Number
        $this->SetXY($xOffset + 20, 65);
        $this->Cell(60, $lh, 'PBMO222363', 0, 1);

        // Vehicle make/model
        $this->SetXY($xOffset + 20, 71);
        $this->Cell(30, $lh, 'TOYOTA', 0, 0);
        $this->Cell(30, $lh, 'COROLLA', 0, 1);

        // Code
        $this->SetXY($xOffset + 20, 77);
        $this->Cell(60, $lh, 'G2299A', 0, 1);

        // VIN
        $this->SetXY($xOffset + 20, 83);
        $this->Cell(80, $lh, '2T1BU4EE2DC032162', 0, 1);

        // Promotion
        $this->SetXY($xOffset + 20, 89);
        $this->Cell(60, $lh, 'AFF.PROM.', 0, 1);

        // Bottom numbers
        $this->SetXY($xOffset + 20, 97);
        $this->Cell(20, $lh, '4', 0, 0);
        $this->Cell(20, $lh, '0', 0, 1);
    }
}

$pdf = new PDF('P', 'mm', 'A4'); // Landscape A4
$pdf->AddPage();

// Left Card
$pdf->addCard(10);

// Right Card
$pdf->addCard(100); // Adjust depending on spacing

$pdf->Output();
