<?php
require_once 'InsurancePDFGeneratorBill.php';
require_once('../includes/DGenerators.php');
try {
    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;
    if ($id <= 0) throw new Exception("Invalid ID parameter");
    
    // Get data from database
    $dbOps = new DGenerators();
    $insuranceData = $dbOps->getInsuranceBill($id);

    // Generate PDF
    $pdfGenerator = new InsurancePDFGeneratorBill($insuranceData);
    $pdfContent = $pdfGenerator->generate();
    
    // Output PDF to browser
    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="insurance_receipt_'.$id.'.pdf"');
    echo $pdfContent;
    
} catch (Exception $e) {
    header('Content-Type: text/plain');
    http_response_code(400);
    echo "Error: " . $e->getMessage();
}


