<?php
require_once 'InsurancePDFGeneratorPBMO.php';
require_once('../includes/DGenerators.php');
try {
    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;
    $signature = isset($_GET['iNvSv']) ? trim($_GET['iNvSv']) : '';
    if ($id <= 0 || $signature === '') {
    throw new Exception("Invalid request parameters: ID or signature missing.");
    }
    // Get data from database
    $dbOps = new DGenerators();
    $insuranceData = $dbOps->getInsuranceDataMob($id,$signature);

    // Generate PDF
    $pdfGenerator = new InsurancePDFGeneratorPBMO($insuranceData);
    $pdfContent = $pdfGenerator->generate();
    
    // Output PDF to browser
    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="insurance_'.$id.'.pdf"');
    echo $pdfContent;
    
} catch (Exception $e) {
    header('Content-Type: text/plain');
    http_response_code(400);
    echo "Error: " . $e->getMessage();
}


