<?php
require_once('../fpdfLib/fpdf.php');
class InsurancePDFGeneratorBill {
    private $pdf;
    private $data;
    private $currentY;
    private $headerImage = 'ressources/img/header1s.png';
    
    public function __construct($data) {
        $this->data = $data;
        $this->pdf = new FPDF('P', 'mm', 'A5');
        $this->pdf->AddPage();//'P', 'mm', 'A5'
        $this->pdf->SetFont('Arial', '', 10);
        $this->currentY = $this->pdf->GetY();
    }

    public function generate() {
        $this->addHeader();
        $this->addPolicyInfo();
        $this->addGoodsCharacteristics();
        $this->addInsuranceDetails();
        $this->addSignatures();
        $this->addPaymentDetails();
        $this->addFooter();
        
        return $this->pdf->Output('S');
    }

    private function addHeader() {
        
        
        $this->pdf->Ln(15);
        $this->pdf->SetFont('Arial', 'B', 9);
        $this->pdf->Cell(0, 8, 'RECU DE PAIEMENT', 0, 1, 'C');
        //$this->pdf->Ln(5);
        
        // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
       /* $this->pdf->SetFont('Arial', 'B', 10);
        $this->pdf->Cell(50, 8, 'Nom ou Raison sociale :', 0, 0);
        $this->pdf->SetFont('Arial', '', 10);
        $this->pdf->Cell(0, 8, $this->data['Proprietaire'], 0, 1);
        
        $this->pdf->Cell(50, 8, 'Adresse:', 0, 0);
        $this->pdf->Cell(0, 8, $this->data['residence'], 0, 1);
        
        $this->pdf->Cell(50, 8, 'Telephone :', 0, 0);
        $this->pdf->Cell(0, 8, $this->data['phone'], 0, 1);
        
        $this->pdf->SetFont('Arial', 'B', 10);
        $this->pdf->Cell(0, 8, 'PROJECT TO SUPPORT FOUNDATIONS OF THE DIGITAL ECONOMY IN BURUNDI "PAFEN"', 0, 1, 'C');
        $this->pdf->Ln(5);*/
    }

   private function addPolicyInfo() {
        $this->pdf->SetFont('Arial', '', 9);
        
        // row 1.0
        $this->pdf->Cell(25, 8, 'Nom preneur:', 0, 0);
        $this->pdf->Cell(55, 8, $this->data['Proprietaire'], 0, 0);
        $this->pdf->Cell(25, 8, 'Date facturation:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatDate($this->data['DateEmission']), 0, 1);
        
        // row 2.0
        $this->pdf->Cell(25, 8, 'Compte preneur:', 0, 0);
        $this->pdf->Cell(55, 8, $this->data['agence_account'], 0, 0);
        $this->pdf->Cell(25, 8, 'Date paiement:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatDate($this->data['payment_date']), 0, 1);
        
        // row 3.0
        $this->pdf->Cell(30, 8, 'Numero de Police:', 0, 0);
        $this->pdf->Cell(50, 8, $this->data['Numpol'], 0, 0);
        $this->pdf->Cell(25, 8, 'Montant Paye:', 0, 0);
        $this->pdf->Cell(0, 8, $this->data['PB'], 0, 1);
        
        // row 3.0
        $this->pdf->Cell(30, 8, 'Numero de Facture:', 0, 0);
        $this->pdf->Cell(50, 8, $this->data['facture'], 0, 0);
        $this->pdf->Cell(25, 8, 'Mode paiement:', 0, 0);
        $this->pdf->Cell(0, 8, $this->data['mode_payment'], 0, 1);
        
                // row 3.0
        
        $this->pdf->Cell(10, 8, 'Motif:', 0, 0);
        $this->pdf->Cell(70, 8, 'Assurance | '. $this->data['Numpol'] .' | '. $this->data['facture'], 0, 1);
       
        
        // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        $this->pdf->Ln(5);
        $this->pdf->SetFont('Arial', '', 8);
        // row 2.0
        $this->pdf->Cell(35, 8, 'Numero de Recu:', 0, 0);
        $this->pdf->Cell(100, 8, $this->data['tx_reference'], 0, 1);
        
        $this->pdf->Cell(30, 8, 'Percepteur:', 0, 0);
        $this->pdf->Cell(50, 8, $this->data['cashier_fullname'], 0, 0);
        $this->pdf->Cell(25, 8, 'Signature', 0, 0);
        $this->pdf->Cell(0, 8,'' , 0, 1);
        
        
    }

    private function addGoodsCharacteristics() {
        $this->pdf->Ln(25);
        $this->pdf->SetFont('Arial', 'B', 9);
        $this->pdf->Cell(0, 8, 'RECU DE PAIEMENT', 0, 1, 'C');
        
        
        // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
         $this->pdf->SetFont('Arial', '', 9);
        
        // row 1.0
        // row 1.0
        $this->pdf->Cell(25, 8, 'Nom preneur:', 0, 0);
        $this->pdf->Cell(55, 8, $this->data['Proprietaire'], 0, 0);
        $this->pdf->Cell(25, 8, 'Date facturation:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatDate($this->data['DateEmission']), 0, 1);
        
        // row 2.0
        $this->pdf->Cell(25, 8, 'Compte preneur:', 0, 0);
        $this->pdf->Cell(55, 8, $this->data['agence_account'], 0, 0);
        $this->pdf->Cell(25, 8, 'Date paiement:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatDate($this->data['payment_date']), 0, 1);
        
        // row 3.0
        $this->pdf->Cell(30, 8, 'Numero de Police:', 0, 0);
        $this->pdf->Cell(50, 8, $this->data['Numpol'], 0, 0);
        $this->pdf->Cell(25, 8, 'Montant Paye:', 0, 0);
        $this->pdf->Cell(0, 8, $this->data['PB'], 0, 1);
        
        // row 3.0
        $this->pdf->Cell(30, 8, 'Numero de Facture:', 0, 0);
        $this->pdf->Cell(50, 8, $this->data['facture'], 0, 0);
        $this->pdf->Cell(25, 8, 'Mode paiement:', 0, 0);
        $this->pdf->Cell(0, 8, $this->data['mode_payment'], 0, 1);
        
                // row 3.0
        
        $this->pdf->Cell(10, 8, 'Motif:', 0, 0);
        $this->pdf->Cell(70, 8, 'Assurance | '. $this->data['Numpol'] .' | '. $this->data['facture'], 0, 1);
       
        
        // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        $this->pdf->Ln(1);
        $this->pdf->SetFont('Arial', '', 8);
        // row 2.0
        $this->pdf->Cell(35, 8, 'Numero de Recu:', 0, 0);
        $this->pdf->Cell(100, 8, $this->data['tx_reference'], 0, 1);
        
        $this->pdf->Cell(30, 8, 'Percepteur:', 0, 0);
        $this->pdf->Cell(50, 8, $this->data['cashier_fullname'], 0, 0);
        $this->pdf->Cell(25, 8, 'Signature', 0, 0);
        $this->pdf->Cell(0, 8,'' , 0, 1);
        
       
        
    }

    private function addInsuranceDetails() {
        
        // Thick gray line
      /*  $this->addHorizontalLine(0.5, array(150, 150, 150));
        $this->pdf->Cell(0, 8, 'IDENTIFICATION DE(S) OBJET(S) ASSURE(S)', 0, 1, 'C');
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
        $this->pdf->SetFont('Arial', 'B', 10);
        $this->pdf->Cell(35, 8, 'Objet assure', 0, 0);
        $this->pdf->Cell(70, 8, 'Garanties offertes/Risques assures', 0, 0);
        $this->pdf->Cell(40, 8, 'Capitaux assures', 0, 0);
        $this->pdf->Cell(0, 8, 'Prime.Nette', 0, 1);
        
        $this->pdf->SetFont('Arial', '', 9);
        $this->pdf->Cell(35, 8, $this->data['nature_marchandise'], 0, 0);
        $this->pdf->Cell(70, 8, $this->data['Garantie'], 0, 0);
        $this->pdf->Cell(40, 8, $this->formatNumber($this->data['valeur_assure']), 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['PN']), 0, 1);
       
       // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        $this->pdf->Cell(55, 8, 'PRIME NET HORS TAXE ET FRAIS:', 0, 0);
        $this->pdf->Cell(30, 8, $this->formatNumber($this->data['PN']), 0, 1);
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
         // row 1.0
        $this->pdf->Cell(35, 8, 'Frais factures:', 0, 0);
        $this->pdf->Cell(30, 8, $this->formatNumber($this->data['FRAIS']), 0, 0);
        $this->pdf->Cell(30, 8, 'Prime Nette:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['PN']), 0, 1);
        
        // row 1.0
        $this->pdf->Cell(35, 8, 'Autres frais:', 0, 0);
        $this->pdf->Cell(30, 8, '0', 0, 0);
        $this->pdf->Cell(30, 8, 'Frais:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['CD']), 0, 1);
        
        $this->pdf->Cell(35, 8, 'Rabbais:', 0, 0);
        $this->pdf->Cell(30, 8, '0', 0, 0);
        $this->pdf->Cell(30, 8, 'TVA:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['TVA']), 0, 1);
        
        $this->pdf->Cell(35, 8, 'Remise:', 0, 0);
        $this->pdf->Cell(30, 8, '0', 0, 0);
        $this->pdf->Cell(30, 8, 'Prime totale TVAC:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['PB']), 0, 1);*/
        
        //$this->pdf->Ln(5);
    }

    private function addSignatures() {
        
          // Thick gray line
      /*  $this->addHorizontalLine(0.5, array(150, 150, 150));
        $this->pdf->Cell(45, 8, 'Modalité de Paiement:', 0, 0);
        $this->pdf->Cell(30, 8, $this->data['payment'], 0, 1);
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
        $this->pdf->MultiCell(0, 8, 'Le preneur d\'assurance ou l\'assure declare avoir pris connaissance des conditions generales et particulieres, qui avec la proposition d\'assurance font partie integrante de la police d\'assurance. Sont nulles, toutes les adjonctions ou modifications non revetues du visa de la Direction de la compagnie ou du representant autorise par la compagnie d\'assurances.', 0, 1);
        //$this->pdf->MultiCell(0, 8, 'Sont nulles, toutes les adjonctions ou modifications non revetues du visa de la Direction de la compagnie ou du representant autorise par la compagnie d\'assurances.', 0, 1);
        //$this->pdf->Ln(3);
        
        $this->pdf->Cell(0, 8, 'Fait a Bujumbura, en deux exemplaires, le ' . $this->formatDate($this->data['DateEmission']), 0, 1, 'C');
        $this->pdf->Ln(1);
        
        $this->pdf->Cell(95, 8, 'LE SOUSCRIPTEUR', 0, 0, 'C');
        $this->pdf->Cell(95, 8, 'POUR LA COMPAGNIE D\'ASSURANCE', 0, 1, 'C');
        
        $this->pdf->Cell(95, 8, $this->data['Proprietaire'], 0, 0, 'C');
        $this->pdf->Cell(95, 8, $this->data['Creator'], 0, 1, 'C');
        
        
        $this->pdf->Ln(1);*/
        
    }

    private function addPaymentDetails() {
        
       /* 
        $this->pdf->SetFont('Arial', 'B', 10);
        $this->pdf->Cell(0, 8, 'PRIME NET HORS TAXE ET FRAIS', 0, 1);
        $this->pdf->SetFont('Arial', '', 9);
        
        $this->pdf->Cell(50, 8, 'Frais factures:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['FRAIS']), 0, 1);
        
        //$this->formatNumber($this->data['autres_frais'])
        $this->pdf->Cell(50, 8, 'Autres frais:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        //$this->formatNumber($this->data['rabbais'])
        $this->pdf->Cell(50, 8, 'Rabbais:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        //$this->formatNumber($this->data['remise'])
        $this->pdf->Cell(50, 8, 'Remise:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        $this->pdf->Cell(50, 8, 'Prime Nette:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['PN']), 0, 1);
        
        //$this->formatNumber($this->data['frais_factures'] + $this->data['autres_frais'])
        $this->pdf->Cell(50, 8, 'Frais:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        $this->pdf->Cell(50, 8, 'TVA:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['TVA']), 0, 1);
        
        $this->pdf->Cell(50, 8, 'Prime totale TVAC:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['PB']), 0, 1);
        
        // $this->data['modalite_paiement']
        $this->pdf->Cell(50, 8, 'Modalite de Paiement:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        $this->pdf->Cell(0, 8, date('d/m/Y H:i:s'), 0, 1, 'R');*/
    }

    private function addFooter() {
        /*$this->pdf->SetY(-40);
        $this->pdf->SetFont('Arial', 'B', 8);
        $this->pdf->Cell(0, 8, 'African Gateway Insurance Company', 0, 1, 'C');
        $this->pdf->Cell(0, 8, 'Pensez Grand, Choisissez AGICO', 0, 1, 'C');
        $this->pdf->SetFont('Arial', '', 7);
        $this->pdf->Cell(0, 5, 'Regie par la loi n째1/06 du 17/7/2020', 0, 1, 'C');*/
    }

    private function formatDate($dateString) {
        return date('d/m/Y', strtotime($dateString));
    }

    private function formatNumber($number) {
        return number_format($number, 2, ',', ' ');
    }
    
    private function addHorizontalLine($width = 0.1, $color = array(0, 0, 0), $padding = 1) {
    $this->pdf->SetDrawColor($color[0], $color[1], $color[2]);
    $this->pdf->SetLineWidth($width);
    $y = $this->pdf->GetY();
    $this->pdf->Line(10, $y + ($padding/2), 200, $y + ($padding/2));
    $this->pdf->Ln($padding);
    }

}
?>