<?php
     class DbOperations
        {
            private $con;

            function __construct(){
                require_once dirname(__FILE__).'/DbConnect.php';
                $db = new DbConnect();

                $this->con = $db->connect();
            }
            /* CRUD -> c -> Create */

            public function mobicEBMS($mobic_ProId){
                $stmt = $this->con->prepare("SELECT id FROM `bic_obr_dataebms` WHERE `id`=?");
                $stmt->bind_param("s",$mobic_ProId);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
            
            public function getProprioById($mobic_ProId){
                $stmt = $this->con->prepare("SELECT *  FROM `bic_obr_dataebms` WHERE `id`=?");
                $stmt->bind_param("s",$mobic_ProId);
                $stmt->execute();
                return $stmt->get_result()->fetch_array();
            }
        //,$agenceLib ,$agenceLib,  AND `Agence`=?
            public function mobicAddress($proprioLib){
                $stmt = $this->con->prepare("SELECT Id FROM `bic_preneur` WHERE `Nomprenom`=?");
                $stmt->bind_param("s",$proprioLib);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
        //,$agenceLib ,$agenceLib,  AND `Agence`=?
            public function getAddressByProprio($proprioLib){
                $stmt = $this->con->prepare("SELECT *  FROM `bic_preneur` WHERE `Nomprenom`=?");
                $stmt->bind_param("s",$proprioLib);
                $stmt->execute();
                return $stmt->get_result()->fetch_array();
            }

            public function getTokenBySignIn(){
                $data = array(
                    'username' => 'wsl400082911100284',
                    'password' => 'Tt<~,1yN'
                   );
                $ch = curl_init('https://ebms.obr.gov.bi:8443/ebms_api/login/');
                $post = json_encode($data);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, 1); 
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
                $result = curl_exec($ch);
                curl_close($ch);
                //$access_token = json_decode($result);

                $data = json_decode($result, true);
                $access_token = $data['result']['token'];
                $_SESSION['name']=$access_token;
                $access_token=$_SESSION['name'];
                //return $access_token->token;
                return $access_token;
            }

            public function getPsrSign($Sign,$mobic_ProId){
                $dateSend = date("Y-m-d");
                $stmt = $this->con->prepare("UPDATE `bic_obr_dataebms` SET `obr`=?,`date`=? WHERE `id`=?");
                $stmt->bind_param("sss", $Sign,$dateSend,$mobic_ProId);
                if ($stmt->execute()) {
                return 1;
                }else {
                 return 2;
                }
            }

            public function getProof($numero_facture,$date_facture,$proprioLib,$residence,$signature,$device_name,
                                    $item_name,$item_price,$item_price_ntva,$tva_amount,$item_price_wvat,$item_total_amount,
                                    $mobic_ProId){
                if ($this->isProofExist($numero_facture)) {
                   return 0;
                }else {
                    $dateSend = date("Y-m-d");
                    $obrValue = 2;
                    $stmt = $this->con->prepare("INSERT INTO `bic_obr_mobic`(`invoice_number`, `invoice_date`,`customer_name`,`customer_address`, `invoice_signature`, `invoice_signature_date`,`device_id`, `item_designation`, `item_price`, `item_price_nvat`, `vat`, `item_price_wvat`, `item_total_amount`, `obr`, `obr_date`,`idMobic`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("ssssssssssssssss", $numero_facture,$date_facture,$proprioLib,$residence,$signature,$date_facture,$device_name,$item_name,$item_price,$item_price_ntva,$tva_amount,$item_price_wvat,$item_total_amount,$obrValue,$dateSend,$mobic_ProId);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isProofExist($numero_facture){
                $stmt = $this->con->prepare("SELECT id FROM `bic_obr_mobic` WHERE `invoice_number`=?");
                $stmt->bind_param("s", $numero_facture);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }



            public function mobicEBMSinvcnc(){
                $data = array(
                    'username' => 'wsl400082911100284',
                    'password' => 'Tt<~,1yN'
                   );
                $ch = curl_init('https://ebms.obr.gov.bi:8443/ebms_api/login/');
                $post = json_encode($data);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, 1); 
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
                $result = curl_exec($ch);
                curl_close($ch);
                $data = json_decode($result, true);
                $access_token = $data['result']['token'];
                $_SESSION['name']=$access_token;
                $access_token=$_SESSION['name'];
                 return $access_token;
            }

            public function mobicEBMSinvchck($mobic_ProId){
                $stmt = $this->con->prepare("SELECT id FROM `bic_obr_mobic` WHERE `id`=?");
                $stmt->bind_param("s",$mobic_ProId);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
            
            public function getSignatureById($mobic_ProId){
                $stmt = $this->con->prepare("SELECT *  FROM `bic_obr_mobic` WHERE `id`=?");
                $stmt->bind_param("s",$mobic_ProId);
                $stmt->execute();
                return $stmt->get_result()->fetch_array();
            }

            public function getTokenBySignInchck(){
                $data = array(
                    'username' => 'wsl400082911100284',
                    'password' => 'Tt<~,1yN'
                   );
                $ch = curl_init('https://ebms.obr.gov.bi:8443/ebms_api/login/');
                $post = json_encode($data);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, 1); 
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
                $result = curl_exec($ch);
                curl_close($ch);
                $data = json_decode($result, true);
                $access_token = $data['result']['token'];
                $_SESSION['name']=$access_token;
                $access_token=$_SESSION['name'];
                 return $access_token;
            }


         }
 ?>