<?php
header('Content-Type: application/json; charset=utf-8');
ob_start();

// Force UTF-8
mb_internal_encoding('UTF-8');

require_once('../includes/Developers.php');

$response = [];

try {
    if (!isset($_GET['plate_id']) || empty(trim($_GET['plate_id']))) {
        throw new Exception("Missing plate_id parameter");
    }
    
    $plate = trim($_GET['plate_id']);
    $db = new Developers();
    $autoContrat = $db->getRenewAutov0($plate);
    
    // Clean UTF-8 before processing
    $autoContrat = cleanData($autoContrat);
    
    $hasData = false;
    if (is_array($autoContrat) || is_object($autoContrat)) {
        $hasData = !empty((array)$autoContrat);
    } else {
        $hasData = !empty($autoContrat);
    }
    
    $response = [
        "success" => $hasData,
        "RenouvelCont" => $autoContrat,
        "timestamp" => date('Y-m-d H:i:s')
    ];
    
    if (!$hasData) {
        $response["message"] = "No insurance found for plate: " . $plate;
    }
    
} catch (Exception $e) {
    $response = [
        "success" => false,
        "message" => $e->getMessage(),
        "timestamp" => date('Y-m-d H:i:s')
    ];
}

ob_end_clean();

// Clean the entire response array
$response = cleanData($response);

$json_output = json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

// If encoding fails, try a more aggressive clean
if ($json_output === false) {
    // Remove any problematic data
    $response = [
        "success" => isset($response["success"]) ? $response["success"] : false,
        "message" => "Data processing completed",
        "timestamp" => date('Y-m-d H:i:s')
    ];
    
    if (isset($response["RenouvelCont"]) && !empty($response["RenouvelCont"])) {
        $response["RenouvelCont"] = "Data available but cannot display details due to encoding issues";
    }
    
    $json_output = json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

echo $json_output;
exit();

/**
 * Clean data for UTF-8 encoding
 */
function cleanData($data) {
    if (is_array($data)) {
        return array_map('cleanData', $data);
    } elseif (is_object($data)) {
        $data = (array)$data;
        return cleanData($data);
    } elseif (is_string($data)) {
        // Remove invalid UTF-8 characters
        if (function_exists('iconv')) {
            $data = @iconv('UTF-8', 'UTF-8//IGNORE//TRANSLIT', $data);
        }
        
        // Alternative if iconv fails
        if ($data === false || $data === null) {
            $data = preg_replace('/[^\x00-\x7F]/', '', $data);
        }
        
        return $data;
    }
    return $data;
}
?>


<?php
/*header('Content-Type: application/json; charset=utf-8');
ob_clean();
error_reporting(0);
require_once('../includes/Developers.php');
if (isset($_GET['plate_id'])) {
    $plate = $_GET['plate_id'];
    $db = new Developers();
    $autoContrat = $db->getRenewAutov0($plate);
    echo json_encode([
        "success" => !empty($autoContrat),
        "RenouvelCont" => $autoContrat,
        "message" => empty($autoContrat) ? "No Insurance found." : null
    ]);

} else {

    echo json_encode([
        "success" => false,
        "message" => "Missing parameter plate_id"
    ]);
}*/
?>