<?php 

header('Content-Type: application/json; charset=utf-8');
require_once('../includes/Developers.php');

$response = [];

// Ensure the request method is GET
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Check if 'user_id' parameter is provided
    if (!empty($_GET['user_id'])) {
        $userId = $_GET['user_id'];
        $status = 1;

        $db = new Developers();
        $accDetails = $db->getMyAccNumber($userId, $status);

        if ($accDetails) {
            // Format balance and return response
            $formattedDetails = number_format($accDetails, 0, ',', ' ');
            $response = [
                'error' => false,
                'max_acc' => $formattedDetails,
            ];
        } else {
            // Handle case where balance retrieval fails
            $defaultDetails = 11111111;
            $formattedDetails = number_format($defaultDetails, 0, ',', ' ');
            $response = [
                'error' => true,
                'message' => $formattedDetails,
            ];
        }
    } else {
        // Handle missing 'user_id' parameter
        $response = [
            'error' => true,
            'message' => 'Required parameters are missing',
        ];
    }
} else {
    // Handle invalid request method
    $response = [
        'error' => true,
        'message' => 'Invalid request method',
    ];
}

// Send JSON response
echo json_encode($response);


/*


header('Content-Type: application/json; charset=utf-8');
require_once('../includes/DbOperations.php');
$response = array();
if ($_SERVER['REQUEST_METHOD']=='GET'){
    if (isset($_GET['user_id'])) {
            $userId = $_GET['user_id'];
            $status = 1;
             $db = new DbOperations();
            $gissBalance  = $db->getManagerAccNumber($userId,$status);
             if ($gissBalance) {
                     $response['error'] = false;
                     $nombre_format_francais = number_format($gissBalance, 0, ',', ' ');
                     $response = array("max_acc" => $nombre_format_francais);
                     echo json_encode($response);
                   }else{
                       $gissBalance = 11111111;
                       $nombre_format_francais = number_format($gissBalance, 0, ',', ' ');
                     $response['error'] = true;
                    $response['message'] = $nombre_format_francais;
                } 
                
        } else {
            $response['error'] = true;
            $response['message'] = 'Required parameters are missing';
            echo json_encode($response);
        }
                
    }else {
       $response['error'] = true;
       $response['message'] = "Requete invalide";
}

*/
?>