<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../includes/Developers.php';

$response = array();

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        $response['error'] = true;
        $response['message'] = "Méthode de requête invalide. Veuillez utiliser POST.";
        echo json_encode($response);
        exit;
    }

    $requiredFields = [
        'purchase_id', 'userUid'
    ];

    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            $response['error'] = true;
            $response['message'] = "Champ obligatoire manquant : $field";
            echo json_encode($response);
            exit;
        }
    }

    // Extract and sanitize input data
    $order_Id       = $_POST['purchase_id'];
    $payer_Id  = $_POST['userUid'];
    
    $db = new Developers();
    $currentDate = date("Y-m-d");
    $currentTime = date("H:i:s");
    $payment = "eBIC";
    
    // Fetch purchase details
        $typeCardDetails = $db->getCardAccValues($payer_Id);
        if (!$typeCardDetails) {
            $response['error'] = true;
            $response['message'] = "Référence de carte introuvable.";
            echo json_encode($response);
            exit;
        }

        $cardId         = $typeCardDetails['id'];
        $cardNumber     = $typeCardDetails['CardSerialId'];
        $cardName       = $typeCardDetails['AccName'];
        $PayerName      = $cardName;
        $cardAcc        = $typeCardDetails['AccNumber'];
        $cardPIN        = $typeCardDetails['AccCardPin'];
        $codeKey        = $db->getMixedRandomId(20, false, true, true);
        
        /*
        $updateStatus = $db->getPaymentUpdCard($order_Id,$payment,$PayerName,$cardNumber,$cardName);
        if ($updateStatus !== 1) {
            $response['error'] = true;
            $response['message'] = "Échec de la mise à jour du statut de la transaction.";
            return;
        }
        */
        
        $updateCardStatus = $db->getPayAccQrUpdCard($cardId,$codeKey);
        if ($updateCardStatus !== 1) {
            $response['error'] = true;
            $response['message'] = "Échec de la mise à jour du statut de la carte.";
            return;
        }

    // Fetch purchase details
    $typeCartDetails = $db->getPurchasedValues($order_Id);
    if (!$typeCartDetails) {
        $response['error'] = true;
        $response['message'] = "Référence de facture introuvable.";
        echo json_encode($response);
        exit;
    }
        //UPDATE `agc_purchase` SET `payment`=?,`payer_name`=?,`card_number`=?,`card_name`=? WHERE `id`=?
        //$payment,$PayerName,$cardNumber,$cardName,$order_Id
        $PayerName      = $typeCartDetails['payer_name'];
        $initiatorCode  = $typeCartDetails['paidto_number'];
        $cartQty        = $typeCartDetails['product_qty'];
        $amount         = $typeCartDetails['balance_paid'];
        $invoiceId      = $typeCartDetails['invoice_id'];
        $policeId       = $typeCartDetails['product_paid'];
        $customerNumber = $typeCartDetails['payer_number'];
        $sessionId      = $typeCartDetails['op_reference'];
        $codeKey        = $db->getMixedRandomId(15, false, true, true);
        
        $narration      = $invoiceId .'_'. $policeId;
        $visaTrx        = $codeKey .'_'. $sessionId;

        global $response;

        // Update transaction status
        
        $partnerTrx = $sessionId;
        $nameCustomer = $PayerName;
        $responseCode = $codeKey;
        $description = "eBIC Card";
        $cashtelTrx = $visaTrx;
        $statusValue = 2;
        $updateStatus = $db->getPaymentUpdTransAg($order_Id,$narration,$partnerTrx,$nameCustomer,$responseCode,$description,$cashtelTrx,$statusValue,$payment,$cardNumber,$cardName);
    
        if ($updateStatus !== 1) {
            $response['error'] = true;
            $response['message'] = "Échec de la mise à jour du statut de la transaction.";
            return;
        }
    
        $response['error'] = false;
        $response['message'] = "Merci pour votre confiance ! Maintenant, approuvez ou annulez";
        $response['message'] = $description;
   
         
echo json_encode($response);
?>