<?php
 header('Content-Type: application/json; charset=utf-8');
 require_once('../includes/Developers.php');
$response = array();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!empty($_GET['sender_id'])) {
        // Sanitize input to prevent SQL injection
        $senderId = intval($_GET['sender_id']);
        
        // Database instance
        $db = new Developers();

        // Fetch sender contact
        $contact = $db->getContactBySenderId($senderId);

        // Check if contact is retrieved
        if (!empty($contact)) {
            $response = [
                'success' => true,
                'contact' => $contact
            ];
        } else {
            $response = [
                'success' => false,
                'message' => 'Contact not found'
            ];
        }
    } else {
        $response = [
            'success' => false,
            'message' => 'Required parameter sender_id is missing'
        ];
    }
} else {
    $response = [
        'success' => false,
        'message' => 'Invalid request method'
    ];
}

echo json_encode($response);

?>