<?php
// Configure session settings BEFORE starting session
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1); // Enable only with HTTPS
ini_set('session.cookie_samesite', 'Strict');
ini_set('session.use_strict_mode', 1);
ini_set('session.use_only_cookies', 1);

// Security headers
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");

// Start session
session_start();

// Generate CSRF token if not exists
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion - MOBIC GLOBAL</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #84BD00 0%, #f6f4f4ff 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            padding: 20px;
        }
        .login-container {
            max-width: 420px;
            margin: 0 auto;
        }
        .decota {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        .form-control {
            border-radius: 10px;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            transition: all 0.3s;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.25rem rgba(102, 126, 234, 0.25);
        }
        .btn-secondary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 12px;
            border-radius: 10px;
            font-weight: bold;
            transition: transform 0.3s;
        }
        .btn-secondary:hover {
            transform: translateY(-2px);
        }
        .alert {
            border-radius: 10px;
            border: none;
        }
        .logo {
            text-align: center;
            margin-bottom: 20px;
        }
        .logo img {
            max-width: 150px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .password-container {
            position: relative;
        }
        .toggle-password {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #667eea;
            cursor: pointer;
        }
        .forgot-password {
            text-align: right;
            margin-top: 10px;
        }
        .forgot-password a {
            color: #667eea;
            text-decoration: none;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <form action="servicesforallwithaccessVersion" method="POST" class="decota" id="loginForm" onsubmit="return validateForm()">
            <!-- CSRF Token user_settings_log -->
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token']); ?>">
            
            <!-- Company Logo/Name -->
            <div class="logo">
                <p class="text-center mb-1" style="color:#000; font-family:Arial;font-weight:bold; font-size: 24px;">
                    MOBIC GLOBAL
                </p>
                <p class="text-center mb-3" style="color:#666; font-family:Arial; font-size:12px;">
                    Plateforme de digitalisation, gestion et contrôle des compagnies et agences d'assurance
                </p>
            </div>

            <!-- Display Error Messages -->
            <?php if (isset($_SESSION['error'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php 
                    echo htmlspecialchars($_SESSION['error']); 
                    unset($_SESSION['error']);
                    ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if (isset($_SESSION['success'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php 
                    echo htmlspecialchars($_SESSION['success']); 
                    unset($_SESSION['success']);
                    ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <!-- Username Field -->
            <div class="form-group mb-3">
                <label for="username" class="form-label" style="color:#333; font-weight:bold;">Nom d'utilisateur</label>
                <input type="text" 
                       name="username" 
                       id="username"
                       class="form-control" 
                       placeholder="Entrez votre nom d'utilisateur" 
                       required 
                       minlength="3" 
                       maxlength="50" 
                       pattern="[A-Za-z0-9_]+"
                       title="Seules les lettres, chiffres et underscore sont autorisés"
                       value="<?php echo isset($_SESSION['login_attempt_username']) ? htmlspecialchars($_SESSION['login_attempt_username']) : ''; ?>"
                       autocomplete="username">
                <div class="invalid-feedback">
                    Le nom d'utilisateur doit contenir entre 3 et 50 caractères (lettres, chiffres ou underscore uniquement)
                </div>
            </div>

            <!-- Password Field -->
            <div class="form-group mb-3">
                <label for="password" class="form-label" style="color:#333; font-weight:bold;">Mot de passe</label>
                <div class="password-container">
                    <input type="password" 
                           name="password" 
                           id="password"
                           class="form-control" 
                           placeholder="Entrez votre mot de passe" 
                           required 
                           minlength="8" 
                           maxlength="100"
                           pattern="^(?=.*[A-Za-z])(?=.*\d)(?=.*[@$!%*#?&])[A-Za-z\d@$!%*#?&]{8,}$"
                           title="Le mot de passe doit contenir au moins 8 caractères, une lettre, un chiffre et un caractère spécial"
                           autocomplete="current-password">
                    <button type="button" class="toggle-password" onclick="togglePassword()">
                        <i class="fas fa-eye"></i>
                    </button>
                </div>
                <div class="invalid-feedback">
                    Le mot de passe doit contenir au moins 8 caractères, une lettre, un chiffre et un caractère spécial
                </div>
            </div>

            <!-- Remember Me (Optional) -->
            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" name="remember_me" id="remember_me">
                <label class="form-check-label" for="remember_me" style="color:#666;">
                    Se souvenir de moi
                </label>
            </div>

            <!-- Submit Button -->
            <button type="submit" 
                    name="open_ssl_con" 
                    class="btn btn-secondary btn-block w-100"
                    id="loginButton">
                <span id="buttonText">Se Connecter</span>
                <span id="loadingSpinner" class="spinner-border spinner-border-sm d-none" role="status"></span>
            </button>

            <!-- Forgot Password Link -->
            <div class="forgot-password">
                <a href="forgot_password.php">Mot de passe oublié ?</a>
            </div>

            <!-- Rate Limit Warning -->
            <div class="alert alert-warning mt-3 d-none" id="rateLimitWarning">
                <i class="fas fa-exclamation-triangle"></i>
                <span id="rateLimitMessage"></span>
            </div>
        </form>

        <!-- Session Warning -->
        <div class="alert alert-info mt-3 text-center">
            <small>
                <i class="fas fa-info-circle"></i>
                Pour votre sécurité, la session expire après 40 minutes d'inactivité
            </small>
        </div>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    
    <script>
        // Password toggle
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const toggleButton = document.querySelector('.toggle-password i');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                toggleButton.classList.remove('fa-eye');
                toggleButton.classList.add('fa-eye-slash');
            } else {
                passwordInput.type = 'password';
                toggleButton.classList.remove('fa-eye-slash');
                toggleButton.classList.add('fa-eye');
            }
        }

        // Form validation
        function validateForm() {
            const form = document.getElementById('loginForm');
            const username = document.getElementById('username');
            const password = document.getElementById('password');
            const button = document.getElementById('loginButton');
            const buttonText = document.getElementById('buttonText');
            const loadingSpinner = document.getElementById('loadingSpinner');
            
            // Check if form is valid
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
                form.classList.add('was-validated');
                return false;
            }
            
            // Check rate limiting
            if (checkRateLimit()) {
                // Show loading state
                button.disabled = true;
                buttonText.textContent = 'Connexion...';
                loadingSpinner.classList.remove('d-none');
                
                return true;
            } else {
                event.preventDefault();
                return false;
            }
        }

        // Rate limiting check
        function checkRateLimit() {
            const now = Date.now();
            const lastAttempt = localStorage.getItem('lastLoginAttempt');
            const attempts = parseInt(localStorage.getItem('loginAttempts')) || 0;
            const maxAttempts = 5;
            const lockTime = 300000; // 5 minutes
            
            if (attempts >= maxAttempts && lastAttempt && (now - lastAttempt) < lockTime) {
                const remaining = Math.ceil((lockTime - (now - lastAttempt)) / 1000 / 60);
                const warning = document.getElementById('rateLimitWarning');
                const message = document.getElementById('rateLimitMessage');
                
                message.textContent = `Trop de tentatives. Veuillez réessayer dans ${remaining} minute(s).`;
                warning.classList.remove('d-none');
                
                return false;
            }
            
            return true;
        }

        // Update rate limiting on failed attempts
        function updateRateLimit() {
            const now = Date.now();
            const lastAttempt = localStorage.getItem('lastLoginAttempt');
            const attempts = parseInt(localStorage.getItem('loginAttempts')) || 0;
            
            // Reset if last attempt was more than 5 minutes ago
            if (lastAttempt && (now - lastAttempt) > 300000) {
                localStorage.setItem('loginAttempts', 0);
                localStorage.setItem('lastLoginAttempt', now);
            } else {
                localStorage.setItem('lastLoginAttempt', now);
                localStorage.setItem('loginAttempts', attempts + 1);
            }
        }

        // Check for existing rate limit on page load
        document.addEventListener('DOMContentLoaded', function() {
            const now = Date.now();
            const lastAttempt = localStorage.getItem('lastLoginAttempt');
            const attempts = parseInt(localStorage.getItem('loginAttempts')) || 0;
            const maxAttempts = 5;
            const lockTime = 300000;
            
            if (attempts >= maxAttempts && lastAttempt && (now - lastAttempt) < lockTime) {
                const remaining = Math.ceil((lockTime - (now - lastAttempt)) / 1000 / 60);
                const warning = document.getElementById('rateLimitWarning');
                const message = document.getElementById('rateLimitMessage');
                
                message.textContent = `Trop de tentatives. Veuillez réessayer dans ${remaining} minute(s).`;
                warning.classList.remove('d-none');
            }
            
            // Clear old rate limiting data
            if (lastAttempt && (now - lastAttempt) > 300000) {
                localStorage.removeItem('lastLoginAttempt');
                localStorage.removeItem('loginAttempts');
            }
        });

        // Real-time validation
        document.getElementById('username').addEventListener('input', function() {
            const username = this.value;
            const regex = /^[A-Za-z0-9_]+$/;
            
            if (username.length > 0) {
                if (!regex.test(username)) {
                    this.setCustomValidity('Seules les lettres, chiffres et underscore sont autorisés');
                } else if (username.length < 3) {
                    this.setCustomValidity('Minimum 3 caractères requis');
                } else {
                    this.setCustomValidity('');
                }
            } else {
                this.setCustomValidity('');
            }
        });

        document.getElementById('password').addEventListener('input', function() {
            const password = this.value;
            const regex = /^(?=.*[A-Za-z])(?=.*\d)(?=.*[@$!%*#?&])[A-Za-z\d@$!%*#?&]{8,}$/;
            
            if (password.length > 0) {
                if (password.length < 8) {
                    this.setCustomValidity('Minimum 8 caractères requis');
                } else if (!regex.test(password)) {
                    this.setCustomValidity('Doit contenir une lettre, un chiffre et un caractère spécial');
                } else {
                    this.setCustomValidity('');
                }
            } else {
                this.setCustomValidity('');
            }
        });

        // Prevent form submission on Enter key in specific fields
        document.getElementById('username').addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                document.getElementById('password').focus();
            }
        });
    </script>
</body>
</html>