<?php
require_once 'config.php';

class AuthService {
    
    public static function getAccessToken() {
        $url = TravelInsuranceConfig::BASE_URL . TravelInsuranceConfig::ENDPOINT_TOKEN;
        
        $postData = http_build_query([
            'grant_type' => 'client_credentials',
            'scope' => 'urn:axa.partners.sales.individual.travel.quotesrequests.write urn:axa.partners.sales.individual.travel.policies.write'
        ]);
        
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $postData,
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/x-www-form-urlencoded',
                'Authorization: Basic ' . base64_encode(TravelInsuranceConfig::AUTH_USERNAME . ':' . TravelInsuranceConfig::AUTH_PASSWORD)
            ],
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 30
        ]);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode === 200) {
            $data = json_decode($response, true);
            return $data['access_token'] ?? null;
        }
        
        return null;
    }
}
?>