<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../includes/Developers.php';

$response = array();

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        $response['error'] = true;
        $response['message'] = "Méthode de requête invalide. Veuillez utiliser POST.";
        echo json_encode($response);
        exit;
    }

    $requiredFields = [
        'purchase_id', 'userUid'
    ];

    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            $response['error'] = true;
            $response['message'] = "Champ obligatoire manquant : $field";
            echo json_encode($response);
            exit;
        }
    }

    // Extract and sanitize input data
    $order_Id       = $_POST['purchase_id'];
    $payer_Id  = $_POST['userUid'];
    
    $db = new Developers();
    $currentDate = date("Y-m-d");
    $currentTime = date("H:i:s");

    $companyId = 1;

    // Fetch company credentials
    $companyLogDetails = $db->GetLogValues($companyId);
    if (!$companyLogDetails) {
        $response['error'] = true;
        $response['message'] = "Informations d'identification de l'entreprise introuvables.";
        echo json_encode($response);
        exit;
    }

    $cpnyUID   = $companyLogDetails['username'];
    $cpnyPass  = $companyLogDetails['password'];
    $partnerPIN = $companyLogDetails['pin'];

    // Fetch purchase details
    $typeCartDetails = $db->getPurchasedValues($order_Id);
    if (!$typeCartDetails) {
        $response['error'] = true;
        $response['message'] = "Référence de facture introuvable.";
        echo json_encode($response);
        exit;
    }

        $initiatorCode  = $typeCartDetails['paidto_number'];
        $cartQty        = $typeCartDetails['product_qty'];
        $amount         = $typeCartDetails['balance_paid'];
        $invoiceId      = $typeCartDetails['invoice_id'];
        $policeId       = $typeCartDetails['product_paid'];
        $customerNumber = $typeCartDetails['payer_number'];
        $sessionId      = $typeCartDetails['op_reference'];
        
        $narration      = $invoiceId .'_'. $policeId;

        global $response;
    
        $url = "https://payments.cashtel.bi:8443/cpgTest/auth/token";
        $authPayload = ["login" => $cpnyUID, "password" => $cpnyPass];
    
        // Authenticate and get token
        $authResponse = $db->customerPaymentv1($url, $authPayload);
        $authData = json_decode($authResponse, true);
    
        if (!isset($authData['token'])) {
            $response['error'] = true;
            $response['message'] = "Échec de l'authentification auprès de la passerelle de paiement.";
            return;
        }
    
        $token = $authData['token'];
    
        // Validate customer details
        $customerDetails = $db->customerPaymentv2($token, $sessionId, $customerNumber);
        $customerData = json_decode($customerDetails, true);
    
        if (!$customerData || empty($customerData['active']) || empty($customerData['name'])) {
            $response['error'] = true;
            $response['message'] = "La validation du compte client a échoué.";
            return;
        }
    
        // Process payment
        $paymentPayload = [
            "partnerTrxId" => $sessionId,
            "initiatorCode" => $initiatorCode,
            "pin" => $partnerPIN,
            "amount" => $amount,
            "narration" => $narration,
            "customerNumber" => $customerNumber
        ];
    
        $paymentResponse = $db->customerPaymentv3($token, $paymentPayload);
        $paymentData = json_decode($paymentResponse, true);
    
        if (!isset($paymentData['responseCode'], $paymentData['description'], $paymentData['cashTelTrxId'], $paymentData['partnerTrxId'])) {
            $response['error'] = true;
             $response['message'] = $paymentData['description'];
            //$response['message'] = "Payment processing failed.";
            return;
        }
    
        // Update transaction status
        $partnerTrx = $paymentData['partnerTrxId'];
        $nameCustomer = $customerData['name'];
        $responseCode = $paymentData['responseCode'];
        $description = $paymentData['description'];
        $cashtelTrx = $paymentData['cashTelTrxId'];
        $statusValue = 2;
        $updateStatus = $db->getPaymentUpdTrans($order_Id,$narration,$partnerTrx,$nameCustomer,$responseCode,$description,$cashtelTrx,$statusValue);
    
        if ($updateStatus !== 1) {
            $response['error'] = true;
            $response['message'] = "Échec de la mise à jour du statut de la transaction.";
            return;
        }
    
        $response['error'] = false;
        // $response['message'] = "Thank you for your trust!";
        $response['message'] = $description;
   
         
echo json_encode($response);
?>