<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../includes/Developers.php';

$response = array();

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        $response['error'] = true;
        $response['message'] = "Méthode de requête invalide. Veuillez utiliser POST.";
        echo json_encode($response);
        exit;
    }

    $requiredFields = [
        'purchase_id', 'userUid'
    ];

    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            $response['error'] = true;
            $response['message'] = "Champ obligatoire manquant : $field";
            echo json_encode($response);
            exit;
        }
    }

    // Extract and sanitize input data
    $order_Id       = $_POST['purchase_id'];
    $payer_Id  = $_POST['userUid'];
    $payment = "Card";
    
    $db = new Developers();
    $currentDate = date("Y-m-d");
    $currentTime = date("H:i:s");


        // Fetch purchase details
        $typeCardDetails = $db->getCardAccValues($payer_Id);
        if (!$typeCardDetails) {
            $response['error'] = true;
            $response['message'] = "Référence de carte introuvable.";
            echo json_encode($response);
            exit;
        }

        $cardId         = $typeCardDetails['id'];
        $cardNumber     = $typeCardDetails['CardSerialId'];
        $cardName       = $typeCardDetails['AccName'];
        $PayerName      = $cardName;
        $cardAcc        = $typeCardDetails['AccNumber'];
        $cardPIN        = $typeCardDetails['AccCardPin'];
        $codeKey        = $db->getMixedRandomId(20, false, true, true);
        
        $updateStatus = $db->getPaymentUpdCard($order_Id,$payment,$PayerName,$cardNumber,$cardName);
    
        if ($updateStatus !== 1) {
            $response['error'] = true;
            $response['message'] = "Échec de la mise à jour du statut de la transaction.";
            return;
        }
        
        $updateCardStatus = $db->getPayAccQrUpdCard($cardId,$codeKey);
    
        if ($updateCardStatus !== 1) {
            $response['error'] = true;
            $response['message'] = "Échec de la mise à jour du statut de la carte.";
            return;
        }
    
        $response['error'] = false;
        $response['message'] = "La carte est prete, continuer pour payer!";
        //$response['message'] = $description;
   
         
echo json_encode($response);
?>