<?php
require_once('../fpdfLib/fpdf.php');
require_once('../includes/DGenerators.php');
require_once('../fpdfLib/phpqrcode/qrlib.php'); // Ensure phpqrcode is available

class InsuranceCardPDF extends FPDF {
    private $cardData;
    private $leftCardSettings = [];
    private $rightCardSettings = [];
    private $qrCodeBaseURL = "https://bicnv-sa.com/MGlobal/live/STRv1/ve5/ie1fec5i82eo&1ed96e24y8iy.php";
    private $qrCodePath;

    public function __construct($data) {
        parent::__construct('P', 'mm', 'A4');
        $this->cardData = $data;

        // Generate QR using DB fields
        $this->qrCodePath = $this->generateQRCode(
            $this->cardData['Id'] ?? '',   // Example: first DB field
            $this->cardData['detailsqrCode'] ?? '' // Example: second DB field
        );

        // Default positions for left card v2 'qr' => ['x' => 30, 'y' => 1, 'size' => 20] | v3 x 35
        $this->leftCardSettings = [
            'company' => ['x' => 22, 'y' => 25, 'w' => 30],
            'qr' => ['x' => 30, 'y' => 1, 'size' => 20], // QR next to header
            'dates' => ['x' => 18, 'y' => 45, 'w' => 20],
            'times' => ['x' => 22, 'y' => 48, 'w' => 15],
            'client' => ['x' => 12, 'y' => 58, 'w' => 60],
            'province' => ['x' => 17, 'y' => 68, 'w' => 60],
            'policy' => ['x' => 17, 'y' => 76, 'w' => 60],
            'vehicle' => ['x' => 15, 'y' => 80, 'w' => 30],
            'plate' => ['x' => 17, 'y' => 84, 'w' => 60],
            'chassis' => ['x' => 17, 'y' => 88, 'w' => 80],
            'insurance' => ['x' => 15, 'y' => 93, 'w' => 60],
            'count' => ['x' => 23, 'y' => 100, 'w' => 23],
           //  'qrv2' => ['x' => 30, 'y' => 115, 'size' => 20], // QR next to header
        ];

       // Default positions for right card (offset by 98mm)
        $this->rightCardSettings = $this->leftCardSettings;
        foreach ($this->rightCardSettings as &$setting) {
            $setting['x'] += 100;
        }
        
        // Now, adjust ONLY the QR position (extra +20 on X)
        $this->rightCardSettings['qr']['x'] += 15;
        
         // Now, adjust ONLY the QR position (extra +20 on X)
        $this->rightCardSettings['qrv2']['x'] += 15;

    }

    public function generate() {
        $this->AddPage();
        $this->addCard($this->leftCardSettings);
        $this->addCard($this->rightCardSettings);
        return $this->Output('S');
    }

        public function adjustCardPosition($cardSide, $element, $x, $y, $width = null) {
            if ($cardSide === 'left') {
                $target =& $this->leftCardSettings;  // Assign by reference
            } else {
                $target =& $this->rightCardSettings;
            }
        
            if (isset($target[$element])) {
                $target[$element]['x'] = $x;
                $target[$element]['y'] = $y;
                if ($width !== null) {
                    $target[$element]['w'] = $width;
                }
            }
        }

    private function addCard($settings) {
        $this->SetFont('Arial', '', 8);
        $lh = 6;
        
        // Draw larger white background for QR code area (adjust size as needed)
        // $this->SetFillColor(255, 255, 255); // white
        // $this->Rect($settings['qr']['x'] - 5, $settings['qr']['y'] - 5, $settings['qr']['size'] + 10, $settings['qr']['size'] + 10, 'F');

        // Company Header
        $this->SetXY($settings['company']['x'], $settings['company']['y']);
        $this->Cell($settings['company']['w'], $lh, strtoupper($this->cardData['company_name']), 0, 1);

        // QR Code
        
        // if (file_exists($this->qrCodePath)) {
        //     $this->Image($this->qrCodePath, $settings['qr']['x'], $settings['qr']['y'], $settings['qr']['size']);
        // }
        
        // QR Code with white background rectangle
        
        /*if (file_exists($this->qrCodePath)) {
            // Draw white background behind QR
            $this->SetFillColor(255, 255, 255); // white
            $this->Rect($settings['qr']['x'] - 1, $settings['qr']['y'] - 1, $settings['qr']['size'] + 2, $settings['qr']['size'] + 2, 'F');
            
            // Place QR on top
            $this->Image($this->qrCodePath, $settings['qr']['x'], $settings['qr']['y'], $settings['qr']['size']);
        }*/
          // QR Code with white background rectangle
        // if (file_exists($this->qrCodePath)) {
        //     // Place QR on top of the white background
        //     $this->Image($this->qrCodePath, $settings['qr']['x'], $settings['qr']['y'], $settings['qr']['size']);
        // }
        
            // FIRST QR CODE (original position) with white background
        if (file_exists($this->qrCodePath)) {
            // Draw white background behind first QR
            $this->SetFillColor(255, 255, 255); // white
            $this->Rect($settings['qr']['x'] - 1, $settings['qr']['y'] - 1, 
                       $settings['qr']['size'] + 2, $settings['qr']['size'] + 2, 'F');
            
            // Place first QR on top
            $this->Image($this->qrCodePath, $settings['qr']['x'], $settings['qr']['y'], 
                       $settings['qr']['size']);
        }

        // Dates
        $this->SetXY($settings['dates']['x'], $settings['dates']['y']);
        $this->Cell($settings['dates']['w'], $lh, $this->formatDate($this->cardData['DateEffet']), 0, 0);
        $this->Cell($settings['dates']['w'], $lh, $this->formatDate($this->cardData['DateEcheance']), 0, 1);

        // Times
        $this->SetXY($settings['times']['x'], $settings['times']['y']);
        $this->Cell($settings['times']['w'], $lh, $this->cardData['timeCreation'], 0, 0);
        $this->Cell($settings['times']['w'] + 5, $lh, $this->cardData['expiry_time'], 0, 1);

        // Client
        $this->SetXY($settings['client']['x'], $settings['client']['y']);
        $this->Cell($settings['client']['w'], $lh, strtoupper($this->cardData['Proprietaire']), 0, 1);

        // Province
        $this->SetXY($settings['province']['x'], $settings['province']['y']);
        $this->Cell($settings['province']['w'], $lh, strtoupper($this->cardData['province']), 0, 1);

        // Policy
        $this->SetXY($settings['policy']['x'], $settings['policy']['y']);
        $this->Cell($settings['policy']['w'], $lh, $this->cardData['Numpol'], 0, 1);

        // Vehicle
        $this->SetXY($settings['vehicle']['x'], $settings['vehicle']['y']);
        $this->Cell($settings['vehicle']['w'], $lh, strtoupper($this->cardData['ClassMarkModel']), 0, 1);

        // Plate
        $this->SetXY($settings['plate']['x'], $settings['plate']['y']);
        $this->Cell($settings['plate']['w'], $lh, $this->cardData['Plaque'], 0, 1);

        // Chassis
        $this->SetXY($settings['chassis']['x'], $settings['chassis']['y']);
        $this->Cell($settings['chassis']['w'], $lh, $this->cardData['NumChasis'], 0, 1);

        // Insurance
        $this->SetXY($settings['insurance']['x'], $settings['insurance']['y']);
        $this->Cell($settings['insurance']['w'], $lh, $this->cardData['UsageAuto'], 0, 1);

        // Count
        $this->SetXY($settings['count']['x'], $settings['count']['y']);
        $this->Cell($settings['count']['w'], $lh, $this->cardData['PaleSeatCabine'], 0, 0);
        $this->Cell(20, $lh, $this->cardData['SeatPlacePlato'], 0, 1);
        
        // SECOND QR CODE at bottom with white background
       /* $bottomQrY = 112; // Adjust this value based on your card layout
        $bottomQrX = $settings['qr']['x']; // Same X position as first QR
        
        if (file_exists($this->qrCodePath)) {
            // Draw white background behind second QR
            $this->SetFillColor(255, 255, 255); // white
            $this->Rect($bottomQrX - 1, $bottomQrY - 1, 
                       $settings['qr']['size'] + 2, $settings['qr']['size'] + 2, 'F');
            
            // Place second QR on top
            $this->Image($this->qrCodePath, $bottomQrX, $bottomQrY, 
                       $settings['qr']['size']);
        }*/
    
    }

    // Build full URL with two DB parameters & generate QR
    private function generateQRCode($param1, $param2) {
        $fullUrl = $this->qrCodeBaseURL . "?id=" . urlencode($param1) . "&iNvSv=" . urlencode($param2);
        $tempDir = sys_get_temp_dir();
        $filePath = $tempDir . '/qrcode_' . uniqid() . '.png';
        QRcode::png($fullUrl, $filePath, QR_ECLEVEL_H, 4);
        return $filePath;
    }

    private function formatDate($dateString) {
        return date('d/m/Y', strtotime($dateString));
    }
}


// Usage
try {
    $id = $_GET['id'] ?? 0;

    $dbOps = new DGenerators();
    $cardData = $dbOps->getInsuranceCardData($id);

    $pdfGenerator = new InsuranceCardPDF($cardData);
    $pdfContent = $pdfGenerator->generate();

    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="insurance_card_'.$id.'.pdf"');
    echo $pdfContent;
} catch (Exception $e) {
    header('Content-Type: text/plain');
    http_response_code(400);
    echo "Error: " . $e->getMessage();
}
