<?php
require_once('../fpdfLib/fpdf.php');

class InsuranceCardPDF extends FPDF {
    private $data;
    private $cardWidth = 85;  // Card width in mm 85
    private $cardHeight = 94; // Card height in mm 
    
    public function __construct($data) {
        parent::__construct('P', 'mm', 'A4'); // A4 landscape (297x210mm)
        $this->data = $data;
    }
    
    public function generate() {
        $this->AddPage();
        
        // Calculate positions for two cards per page
        $marginLeft = (297 - ($this->cardWidth * 2 + 10)) / 2; // Center two cards with 10mm gap 297
        $marginTop = (210 - $this->cardHeight) / 2; // Vertical center 210
        
        // First card
        $this->generateCardContent($marginLeft, $marginTop);
        
        // Second card
        $this->generateCardContent($marginLeft + $this->cardWidth + 10, $marginTop);
        
        return $this->Output('S');
    }
    
    private function generateCardContent($x, $y) {
        // Save current position
        $originalX = $this->GetX();
        $originalY = $this->GetY();
        
        // Set position for this card
        $this->SetXY($x, $y);
        
        // Draw card border (optional)
       // $this->Rect($x, $y, $this->cardWidth, $this->cardHeight);
        
        // Set margins within the card
        $cardMargin = 5;
        $this->SetLeftMargin($x + $cardMargin);
        $this->SetRightMargin(297 - $x - $this->cardWidth + $cardMargin);
        $this->SetY($y + $cardMargin);
        
        // Company name (top center)
        $this->SetFont('Arial', 'B', 10);
        $this->Cell($this->cardWidth - ($cardMargin * 2), 8, strtoupper($this->data['company_name']), 0, 1, 'C');
        $this->Ln(10);
        
        // Dates and times
        $this->SetFont('Arial', 'B', 10);
        $this->Cell($this->cardWidth - ($cardMargin * 2), 5, $this->formatDateRange(), 0, 1, 'C');
        $this->Cell($this->cardWidth - ($cardMargin * 2), 5, $this->formatTimeRange(), 0, 1, 'C');
        $this->Ln(3);
        
        // Client information
        $this->SetFont('Arial', 'B', 10);
        $this->Cell($this->cardWidth - ($cardMargin * 2), 7, strtoupper($this->data['Proprietaire']), 0, 1, 'C');
        
        //, 'C'
         $this->Ln(5);
        $this->SetFont('Arial', 'B', 10);
        $this->Cell($this->cardWidth - ($cardMargin * 2), 7, strtoupper($this->data['province']), 0, 1);
        $this->Ln(3);
        
        // Policy number , 'C'
        $this->SetFont('Arial', 'B', 10);
        $this->Cell($this->cardWidth - ($cardMargin * 2), 7, $this->data['Numpol'], 0, 1);
        
        // Vehicle information , 'C'
        $this->SetFont('Arial', '', 10);
        $this->Cell($this->cardWidth - ($cardMargin * 2), 7, $this->formatVehicleInfo(), 0, 1);
        
        // Plate number (larger font) , 'C'
        $this->SetFont('Arial', 'B', 10);
        $this->Cell($this->cardWidth - ($cardMargin * 2), 8, $this->data['Plaque'], 0, 1);
        
        // Chassis number (smaller font) , 'C'
        $this->SetFont('Arial', '', 10);
        $this->Cell($this->cardWidth - ($cardMargin * 2), 6, $this->data['NumChasis'], 0, 1);
        
        // Insurance type , 'C'
        $this->SetFont('Arial', '', 10);
        $this->Cell($this->cardWidth - ($cardMargin * 2), 7, $this->data['UsageAuto'], 0, 1);
        
        // Card count , 'C'
        $this->SetFont('Arial', 'B', 10);
        $this->Cell($this->cardWidth - ($cardMargin * 2), 7, $this->formatCardCount(), 0, 1);
        
        // Restore original position
        $this->SetXY($originalX, $originalY);
    }
    
    private function formatDateRange() {
        return $this->formatDate($this->data['DateEffet']) . '  ' . $this->formatDate($this->data['DateEcheance']);
    }
    
    private function formatTimeRange() {
        return $this->data['timeCreation'] . '    ' . $this->data['expiry_time'];
    }
    
    private function formatVehicleInfo() {
        return strtoupper($this->data['ClassMarkModel'] . '    ');
    }
    
    private function formatCardCount() {
        return $this->data['PaleSeatCabine'] . '    '.$this->data['SeatPlacePlato'];
    }
    
    private function formatDate($date) {
        return date('d/m/Y', strtotime($date));
    }
}


/*

class InsuranceCardPDF extends FPDF {
    private $data;
    
    public function __construct($data) {
        parent::__construct('L', 'mm', array(85, 54)); // Card size in mm (horizontal)
        $this->data = $data;
    }
    
    public function generate() {
        $this->AddPage();
        $this->SetAutoPageBreak(false);
        $this->SetMargins(5, 5, 5);
        
        // Set font and colors
        $this->SetFont('Arial', 'B', 10);
        $this->SetTextColor(0, 0, 0);
        
        // Company name (top center)$this->data['company_name']
        $this->Cell(0, 8, strtoupper('BIC SA'), 0, 1, 'C');
        $this->Ln(2);
        
        // Dates and times
        $this->SetFont('Arial', '', 8);
        $dateString = $this->formatDate($this->data['DateEffet']) . '  ' . $this->formatDate($this->data['DateEcheance']);
        $timeString = $this->data['timeCreation'] . '    ' . $this->data['expiry_time'];
        
        $this->Cell(0, 5, $dateString, 0, 1, 'C');
        $this->Cell(0, 5, $timeString, 0, 1, 'C');
        $this->Ln(3);
        
        // Client name
        $this->SetFont('Arial', 'B', 10);
        $this->Cell(0, 7, strtoupper($this->data['Proprietaire']), 0, 1, 'C');
        
        // City
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 7, strtoupper($this->data['province']), 0, 1, 'C');
        $this->Ln(3);
        
        // Policy number
        $this->SetFont('Arial', 'B', 10);
        $this->Cell(0, 7, $this->data['Numpol'], 0, 1, 'C');
        
        // Vehicle make and model
        $this->SetFont('Arial', '', 10);
        $vehicleInfo = strtoupper($this->data['ClassMarkModel'] . '    ' . $this->data['ClassMarkModel']);
        $this->Cell(0, 7, $vehicleInfo, 0, 1, 'C');
        
        // Plate number
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 8, $this->data['Plaque'], 0, 1, 'C');
        
        // Chassis number
        $this->SetFont('Arial', '', 8);
        $this->Cell(0, 6, $this->data['NumChasis'], 0, 1, 'C');
        
        // Insurance type
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 7, $this->data['UsageAuto'], 0, 1, 'C');
        
        // Card count
        $this->SetFont('Arial', 'B', 10);
        $this->Cell(0, 7, $this->data['PaleSeatCabine'] . '    0', 0, 1, 'C');
        
        // Duplicate the card (as shown in sample)
        $this->AddPage();
        $this->generateCardContent(); // Reuse the same content
        
        return $this->Output('S');
    }
    
    private function generateCardContent() {
        // Same content generation logic as above
        // ... [repeated content generation code]
    }
    
    private function formatDate($date) {
        return date('d/m/Y', strtotime($date));
    }
}

*/