<?php
session_start();
require_once '../includes/DbOperations.php';

$response = [];

try {

    // ----------------------------------------------
    // VALIDATE REQUEST
    // ----------------------------------------------
    if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['btnchckTinvar'])) {
        throw new Exception("Déclaration invalide");
    }

    if (empty($_POST['param_TinId'])) {
        throw new Exception("Valeurs vides non autorisées");
    }

    $ebmsCustId = trim($_POST['param_TinId']);

    // ----------------------------------------------
    // INIT DB & TOKEN
    // ----------------------------------------------
    $db = new DbOperations();
    $token = $db->getTokenByRequest();

    if (empty($token)) {
        http_response_code(401);
        throw new Exception("Invalid Token");
    }

    // ----------------------------------------------
    // CALL EBMS API
    // ----------------------------------------------
    $ebms_checkTIN = $db->ebmsGetTINByAPI($token, $ebmsCustId);

    if (!$ebms_checkTIN) {
        throw new Exception("Erreur lors de la requête EBMS");
    }

    $json = json_decode($ebms_checkTIN, true);

    if (!is_array($json)) {
        throw new Exception("Réponse EBMS invalide");
    }

    // ----------------------------------------------
    // SAFE DATA EXTRACTION
    // ----------------------------------------------
    $main_msg = $json['msg'] ?? 'Aucun message';
    $tp_name  = $json['result']['result']['taxpayer'][0]['tp_name'] ?? 'Inconnu';

    // ----------------------------------------------
    // SUCCESS
    // ----------------------------------------------
    $_SESSION['success'] = "Message [ Status ] : $main_msg | Nom du Contribuable ayant le NIF [ ".$ebmsCustId."] : $tp_name";
    header('Location: ../../syst_tax_track_control');
    exit;

} catch (Exception $e) {

    // ----------------------------------------------
    // ERROR HANDLING
    // ----------------------------------------------
    $_SESSION['stata'] = $e->getMessage();
    header('Location: ../../syst_tax_track_control');
    exit;
}
?>