<?php
session_start();
require_once '../includes/DbOperations.php';

$response = [];

try {

    // ----------------------------------------------
    // VALIDATE REQUEST
    // ----------------------------------------------
    if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['btnchckInvoiceVar'])) {
        throw new Exception("Déclaration invalide");
    }

    if (empty($_POST['idProprio'])) {
        throw new Exception("Valeurs vides non autorisées");
    }

    $signatureId = trim($_POST['idProprio']);

    // ----------------------------------------------
    // INIT DB & TOKEN
    // ----------------------------------------------
    $db = new DbOperations();
    $token = $db->getTokenByRequest();

    if (empty($token)) {
        http_response_code(401);
        throw new Exception("Invalid Token");
    }

    // ----------------------------------------------
    // CALL EBMS API
    // ----------------------------------------------
    $ebms_checkINV = $db->EBMSCheckINVByAPI($token,$signatureId);

   // $ebms_checkTIN = $db->ebmsGetTINByAPI($token, $ebmsCustId);

    if (!$ebms_checkINV) {
        throw new Exception("Erreur lors de la requête EBMS");
    }

    $json = json_decode($ebms_checkINV, true);

   if (!is_array($json)) {
        throw new Exception("Réponse EBMS invalide");
    }

    if (!isset($json['success']) || $json['success'] !== true) {
        throw new Exception($json['msg'] ?? 'Erreur EBMS inconnue');
    }

    // ----------------------------------------------
    // SAFE DATA EXTRACTION
    // ----------------------------------------------
    $invoices = $json['result']['invoices'] ?? [];

    if (empty($invoices)) {
        throw new Exception("Aucune facture trouvée");
    }

    $invoice = $invoices[0];

    $invoice_number = $invoice['invoice_number'] ?? null;
    $invoice_date   = $invoice['invoice_date'] ?? null;
    $customer_name  = $invoice['customer_name'] ?? null;
    $customer_address  = $invoice['customer_address'] ?? null;

    // ----------------------------------------------
    // SUCCESS
    // ----------------------------------------------

    $_SESSION['success'] = "Facture: $invoice_number | Client: $customer_name | Date: $invoice_date <br>";
    header('Location: ../../syst_tax_track_invoice_control');
    exit;

} catch (Exception $e) {

    // ----------------------------------------------
    // ERROR HANDLING
    // ----------------------------------------------
    $_SESSION['stata'] = $e->getMessage();
    header('Location: ../../syst_tax_track_invoice_control');
    exit;
}
?>