<?php
session_start();
require_once '../includes/DbOperations.php';

$response = [];

try {

    // ----------------------------------------------
    // VALIDATE REQUEST
    // ----------------------------------------------
    if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['btnCancelInvoiceVar'])) {
        throw new Exception("Déclaration invalide");
    }

    if (empty($_POST['idProprio'])) {
        throw new Exception("Valeurs vides non autorisées");
    }

    if (empty($_POST['motif_description'])) {
        throw new Exception("Valeurs vides non autorisées");
    }

    $signatureId = trim($_POST['idProprio']);
    $motif = trim($_POST['motif_description']);

    // ----------------------------------------------
    // INIT DB & TOKEN
    // ----------------------------------------------
    $db = new DbOperations();
    $token = $db->getTokenByRequest();

    if (empty($token)) {
        http_response_code(401);
        throw new Exception("Invalid Token");
    }

    // ----------------------------------------------
    // CALL EBMS API
    // ----------------------------------------------
    $ebms_cancelINV = $db->EBMSCancelInvByAPI($token,$signatureId,$motif);

    if (!$ebms_cancelINV) {
        throw new Exception("Erreur lors de la requête EBMS");
    }

    $json = json_decode($ebms_cancelINV, true);

   if (!is_array($json)) {
        throw new Exception("Réponse EBMS invalide");
    }

    if (!isset($json['success']) || $json['success'] !== true) {
        throw new Exception($json['msg'] ?? 'Erreur EBMS inconnue');
    }

    /* ----------------------------------------------
     * POST-EBMS DB UPDATES
     * ---------------------------------------------- */
    if ($db->EBMSconfirmCancel($signatureId) !== 1) {
        throw new Exception("Erreur de confirmation annulation contrat");
    }

    // ----------------------------------------------
    // SAFE DATA EXTRACTION
    // ----------------------------------------------
    $message = $json['msg'] ?? null;

    // ----------------------------------------------
    // SUCCESS
    // ----------------------------------------------

    $_SESSION['success'] = $message ;
    header('Location: ../../syst_tax_cancel_invoice_control');
    exit;

} catch (Exception $e) {

    // ----------------------------------------------
    // ERROR HANDLING
    // ----------------------------------------------
    $_SESSION['stata'] = $e->getMessage();
    header('Location: ../../syst_tax_cancel_invoice_control');
    exit;
}
?>