<?php
session_start();
require_once '../includes/DbOperations.php';

/* ----------------------------------------------
 * INIT
 * ---------------------------------------------- */
$response = [];
$invoiceItems = [];

try {

    /* ----------------------------------------------
     * VALIDATE REQUEST
     * ---------------------------------------------- */

    if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['btnAddInvoiceVar'])) {
        throw new Exception("Déclaration invalide");
    }

    if (empty($_POST['idProprio'])) {
        throw new Exception("Valeurs vides non autorisées");
    }

   

    $contract_Id = trim($_POST['idProprio']);

    /* ----------------------------------------------
     * INIT DB & LOAD INVOICE
     * ---------------------------------------------- */
    $db = new DbOperations();

    if (!$db->PullDetailsResponsInvoice($contract_Id)) {
        http_response_code(404);
        throw new Exception("Contrat invalide ou introuvable");
    }

    $invoiceDetails = $db->getDetailsResponsInvoiceById($contract_Id);
    if (empty($invoiceDetails)) {
        throw new Exception("Détails de facture introuvables");
    }

    /* ----------------------------------------------
     * INVOICE DATES & SIGNATURE
     * ---------------------------------------------- */
    $invoice_number = $invoiceDetails['Facture'] ?? null;
    if (empty($invoice_number)) {
        throw new Exception("Numéro de facture manquant");
    }

    $signature = $invoiceDetails['signature'] ?? null;

    if (empty($signature)) {
        $emission_date  = $invoiceDetails['DateEmission'];
        $emission_time  = $invoiceDetails['timeCreation'];
        $invoiceOriginal_date = $emission_date . ' ' . $emission_time;
        $date_signature = date("YmdHis", strtotime($invoiceOriginal_date));
        $signature = '4000829111/wsl400082911100284/' . $date_signature . '/' . $invoice_number;
        $invoiceOriginal_date_v1 = $invoiceOriginal_date;
    } else {
        $invoiceOriginal_date = $invoiceDetails['date_signature'];
        $invoiceOriginal_date_v1 = $invoiceOriginal_date;
        $signature = $invoiceDetails['signature'];
    }

    /* ----------------------------------------------
     * CUSTOMER & CONTRACT DATA
     * ---------------------------------------------- */
    $customer_name    = $invoiceDetails['Proprietaire'];
    $customer_address = $invoiceDetails['residence'];
    $ownership_agence = $invoiceDetails['agence'];

    $product   = "Ass_responscivile";
    $device_id = "wsl400082911100284";

    /* ----------------------------------------------
     * FINANCIAL CALCULATION
     * ---------------------------------------------- */
    $PN     = (float) $invoiceDetails['PN'];
    $FRAIS  = (float) $invoiceDetails['FRAIS'];
    $CD     = (float) $invoiceDetails['CD'];
    $TVA    = (float) $invoiceDetails['TVA'];
    $PB     = (float) $invoiceDetails['PB'];

    $item_price = $PN + $FRAIS + $CD;

    /* ----------------------------------------------
     * INVOICE ITEMS
     * ---------------------------------------------- */
    $item_name = "RESPONS_CIVILE";

    $invoiceItems[] = [
        "device_id"         => $device_id,
        "item_designation"  => $item_name,
        "item_quantity"     => "1.0",
        "item_price"        => $item_price,
        "item_ct"           => "0.0",
        "item_tl"           => "0.0",
        "item_price_nvat"   => $item_price,
        "vat"               => $TVA,
        "item_price_wvat"   => $PB,
        "item_total_amount" => $PB
    ];

    /* ----------------------------------------------
     * FINAL EBMS PAYLOAD
     * ---------------------------------------------- */
    $invoicePayload = [
        "invoice_number" => $invoice_number,
        "invoice_date" => $invoiceOriginal_date,
        "invoice_type" => "FN",
        "tp_type" => "1",
        "tp_name" => "BIC SA BUSINESS INSURANCE AND REINSURANCE COMPANY",
        "tp_TIN" => "4000829111", 
        "tp_trade_number" => "08794",
        "tp_postal_number" => "362",
        "tp_phone_number" => "22280042",
        "tp_address_province" => "BUJUMBURA MAIRIE",
        "tp_address_commune" => "MUKAZA",
        "tp_address_quartier" => "ROHERO I",
        "tp_address_avenue" => "ONU",
        "tp_address_number" => "6",
        "vat_taxpayer" => "1",
        "ct_taxpayer" => "0",
        "tl_taxpayer" => "0",
        "tp_fiscal_center" => "DGC",
        "tp_activity_sector" => "ASSURANCE",
        "tp_legal_form" => "SA",
        "payment_type" => "1",
        "invoice_currency" => "BIF",
        "customer_name" => $customer_name,
        "customer_TIN" => "",
        "customer_address" => $customer_address,
        "vat_customer_payer" => "0",
        "cancelled_invoice_ref" => "",
        "invoice_ref" => "",
        "cn_motif" => "",
        "invoice_signature" => $signature,
        "invoice_signature_date" => $invoiceOriginal_date_v1,
        "invoice_items" =>$invoiceItems
    ];

    /* ----------------------------------------------
     * TOKEN & EBMS CALL
     * ---------------------------------------------- */
    $token = $db->getTokenByRequest();
    if (empty($token)) {
        http_response_code(401);
        throw new Exception("Token EBMS invalide");
    }

    $ebmsResponse = $db->EBMSAddInvoiceByDetails($invoicePayload, $token);
    if (!$ebmsResponse) {
        throw new Exception("Erreur lors de la requête EBMS");
    }

    $json = json_decode($ebmsResponse, true);

    if (!is_array($json) || empty($json['success'])) {
        throw new Exception($json['msg'] ?? "Réponse EBMS invalide");
    }

    /* ----------------------------------------------
     * POST-EBMS DB UPDATES
     * ---------------------------------------------- */
    if ($db->getSignContractResponsMain($contract_Id) !== 1) {
        throw new Exception("Erreur signature contrat");
    }

    if ($db->validateDetailsResponsByInvoice($invoice_number) !== 1) {
        throw new Exception("Erreur validation facture");
    }

    if ($db->getOBRDerailsAdded(
        $invoice_number,
        $invoiceOriginal_date,
        $customer_name,
        $customer_address,
        $signature,
        $invoiceOriginal_date_v1,
        $device_id,
        $item_name,
        $item_price,
        $item_price,
        $TVA,
        $PB,
        $PB,
        $contract_Id,
        $ownership_agence,
        $product
    ) !== 1) {
        throw new Exception("Erreur enregistrement OBR");
    }

    /* ----------------------------------------------
     * SUCCESS
     * ---------------------------------------------- */
    $_SESSION['success'] = $json['msg'] ?? "Facture enregistrée avec succès";
    header('Location: ../../syst_tax_respons_control');
    exit;

} catch (Exception $e) {

    /* ----------------------------------------------
     * ERROR HANDLING
     * ---------------------------------------------- */
    $_SESSION['stata'] = $e->getMessage();
    header('Location: ../../syst_tax_respons_control');
    exit;
}
?>

