<?php
session_start();
require_once '../includes/DbOperations.php';

/* ----------------------------------------------
 * INIT
 * ---------------------------------------------- */
$response = [];
$invoiceItems = [];

try {

    /* ----------------------------------------------
     * VALIDATE REQUEST
     * ---------------------------------------------- */

    if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['btnAddInvoiceVar'])) {
        throw new Exception("Déclaration invalide");
    }

    if (empty($_POST['idProprio'])) {
        throw new Exception("Valeurs vides non autorisées");
    }

   

    $contract_Id = trim($_POST['idProprio']);

    /* ----------------------------------------------
     * INIT DB & LOAD INVOICE
     * ---------------------------------------------- */
    $db = new DbOperations();

    if (!$db->PullDetailsInvoice($contract_Id)) {
        http_response_code(404);
        throw new Exception("Contrat invalide ou introuvable");
    }

    $invoiceDetails = $db->getDetailsInvoiceById($contract_Id);
    if (empty($invoiceDetails)) {
        throw new Exception("Détails de facture introuvables");
    }

    /* ----------------------------------------------
     * INVOICE DATES & SIGNATURE
     * ---------------------------------------------- */
    $invoice_number = $invoiceDetails['facture'] ?? null;
    if (empty($invoice_number)) {
        throw new Exception("Numéro de facture manquant");
    }

    $signature = $invoiceDetails['signature'] ?? null;

    if (empty($signature)) {
        $emission_date  = $invoiceDetails['DateEmission'];
        $emission_time  = $invoiceDetails['timeCreation'];
        $invoiceOriginal_date = $emission_date . ' ' . $emission_time;
        $date_signature = date("YmdHis", strtotime($invoiceOriginal_date));
        $signature = '4000829111/wsl400082911100284/' . $date_signature . '/' . $invoice_number;
        $invoiceOriginal_date_v1 = $invoiceOriginal_date;
    } else {
        $invoiceOriginal_date = $invoiceDetails['date_signature'];
        $invoiceOriginal_date_v1 = $invoiceOriginal_date;
        $signature = $invoiceDetails['signature'];
    }

    /* ----------------------------------------------
     * CUSTOMER & CONTRACT DATA
     * ---------------------------------------------- */
    $customer_name    = $invoiceDetails['Proprietaire'];
    $customer_address = $invoiceDetails['residence'];
    $ownership_agence = $invoiceDetails['agence'];

    $product   = "Ass_automobile";
    $device_id = "wsl400082911100284";

    /* ----------------------------------------------
     * FINANCIAL CALCULATION
     * ---------------------------------------------- */
    $PN     = (float) $invoiceDetails['PN'];
    $FRAIS  = (float) $invoiceDetails['FRAIS'];
    $CD     = (float) $invoiceDetails['CD'];
    $TVA    = (float) $invoiceDetails['TVA'];
    $PB     = (float) $invoiceDetails['PB'];

    $item_price = $PN + $FRAIS + $CD;

    /* ----------------------------------------------
     * INVOICE ITEMS
     * ---------------------------------------------- */
    $item_name = "AUTOMOBILE";

    $invoiceItems[] = [
        "device_id"         => $device_id,
        "item_designation"  => $item_name,
        "item_quantity"     => "1.0",
        "item_price"        => $item_price,
        "item_ct"           => "0.0",
        "item_tl"           => "0.0",
        "item_price_nvat"   => $item_price,
        "vat"               => $TVA,
        "item_price_wvat"   => $PB,
        "item_total_amount" => $PB
    ];

    /* ----------------------------------------------
     * FINAL EBMS PAYLOAD
     * ---------------------------------------------- */
    $invoicePayload = [
        "invoice_number" => $invoice_number,
        "invoice_date" => $invoiceOriginal_date,
        "invoice_type" => "FN",
        "tp_type" => "1",
        "tp_name" => "BIC SA BUSINESS INSURANCE AND REINSURANCE COMPANY",
        "tp_TIN" => "4000829111", 
        "tp_trade_number" => "08794",
        "tp_postal_number" => "362",
        "tp_phone_number" => "22280042",
        "tp_address_province" => "BUJUMBURA MAIRIE",
        "tp_address_commune" => "MUKAZA",
        "tp_address_quartier" => "ROHERO I",
        "tp_address_avenue" => "ONU",
        "tp_address_number" => "6",
        "vat_taxpayer" => "1",
        "ct_taxpayer" => "0",
        "tl_taxpayer" => "0",
        "tp_fiscal_center" => "DGC",
        "tp_activity_sector" => "ASSURANCE",
        "tp_legal_form" => "SA",
        "payment_type" => "1",
        "invoice_currency" => "BIF",
        "customer_name" => $customer_name,
        "customer_TIN" => "",
        "customer_address" => $customer_address,
        "vat_customer_payer" => "0",
        "cancelled_invoice_ref" => "",
        "invoice_ref" => "",
        "cn_motif" => "",
        "invoice_signature" => $signature,
        "invoice_signature_date" => $invoiceOriginal_date_v1,
        "invoice_items" =>$invoiceItems
    ];
    /*
            "vat_customer_payer" => "0",
            "invoice_signature" => $signature,
            "invoice_signature_date" => $invoiceOriginal_date_v1,
            "invoice_items" => $invoiceItems

        "vat_customer_payer" => "0",
        "cancelled_invoice_ref" => "",
        "invoice_ref" => "",
        "cn_motif" => "",
        "invoice_identifier" => $signature,
    */
    /* ----------------------------------------------
     * TOKEN & EBMS CALL
     * ---------------------------------------------- */
    $token = $db->getTokenByRequest();
    if (empty($token)) {
        http_response_code(401);
        throw new Exception("Token EBMS invalide");
    }

    $ebmsResponse = $db->EBMSAddInvoiceByDetails($invoicePayload, $token);
    if (!$ebmsResponse) {
        throw new Exception("Erreur lors de la requête EBMS");
    }

    $json = json_decode($ebmsResponse, true);

    if (!is_array($json) || empty($json['success'])) {
        throw new Exception($json['msg'] ?? "Réponse EBMS invalide");
    }

    /* ----------------------------------------------
     * POST-EBMS DB UPDATES
     * ---------------------------------------------- */
    if ($db->getSignContractMain($contract_Id) !== 1) {
        throw new Exception("Erreur signature contrat");
    }

    if ($db->validateDetailsByInvoice($invoice_number) !== 1) {
        throw new Exception("Erreur validation facture");
    }

    if ($db->getOBRDetailsAdded(
        $invoice_number,
        $invoiceOriginal_date,
        $customer_name,
        $customer_address,
        $signature,
        $invoiceOriginal_date_v1,
        $device_id,
        $item_name,
        $item_price,
        $item_price,
        $TVA,
        $PB,
        $PB,
        $contract_Id,
        $ownership_agence,
        $product
    ) !== 1) {
        throw new Exception("Erreur enregistrement OBR");
    }

    /* ----------------------------------------------
     * SUCCESS
     * ---------------------------------------------- */
    $_SESSION['success'] = $json['msg'] ?? "Facture enregistrée avec succès";
    header('Location: ../../syst_tax_automobile_control_v2');
    exit;

} catch (Exception $e) {

    /* ----------------------------------------------
     * ERROR HANDLING
     * ---------------------------------------------- */
    $_SESSION['stata'] = $e->getMessage();
    header('Location: ../../syst_tax_automobile_control_v2');
    exit;
}
?>

<?php
/*session_start();
require_once '../includes/DbOperations.php';

$response = [];
$transformedInvoiceItems = array();
$invoiceFinalResponse = array();
try {

    // ----------------------------------------------
    // VALIDATE REQUEST
    // ----------------------------------------------
    if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['btnAddInvoiceVar'])) {
        throw new Exception("Déclaration invalide");
    }

    if (empty($_POST['idProprio'])) {
        throw new Exception("Valeurs vides non autorisées");
    }

    $contract_Id = trim($_POST['idProprio']);

    // ----------------------------------------------
    // INIT DB & TOKEN AND MORE
    // ----------------------------------------------
    $db = new DbOperations();

    if (!$db->PullDetailsInvoice($contract_Id)) {
         http_response_code(404); // Not Found
         $resp_data['error'] = 'Invalid Contract';
         echo json_encode($resp_data);
         return;
        } 

  $invoiceDetails        = $db->getDetailsInvoiceById($contract_Id);
  $invoice_number        = $invoiceDetails['facture'];
  $invoice_date          = $invoiceDetails['date_signature'] ?? null;
    if (empty($invoice_date)) {
                
         $emission_date             = $invoiceDetails['DateEmission'];
         $emission_time             = $invoiceDetails['timeCreation'];
         $invoiceOriginal_date      = $emission_date .' '.$emission_time;
         $date_signature            = date("YmdHis",strtotime($invoiceOriginal_date));
         $signature                 = '4000829111/wsl400082911100284/' . $date_signature . '/' . $invoice_number;
   

    } else {
                // 🟢 Case: value exists
                // Normal processing
        $invoiceOriginal_date       = $invoice_date;
        $signature                  = $invoiceDetails['signature'];
        $invoiceOriginal_date_v1       = $invoiceOriginal_date;

    }

         $customer_name         = $invoiceDetails['Proprietaire'];
         $customer_address      = $invoiceDetails['residence'];
         $ownership_agence      = $invoiceDetails['agence'];
         $product               = "Ass_automobile";
         $device_id             = "wsl400082911100284";
         define('DEFAULT_ITEM_QUANTITY', '1.0');
         define('DEFAULT_ITEM_CT', '0.0');
         define('DEFAULT_ITEM_TL', '0.0');
         $item_designation      = "AUTOMOBILE";
         $invoice_PN            = $invoiceDetails['PN'];
         $invoice_FRAIS         = $invoiceDetails['FRAIS'];
         $invoice_CD            = $invoiceDetails['CD'];
         

         $item_price            = $invoice_PN + $invoice_FRAIS + $invoice_CD;
         $item_price_nvat       =  $item_price;
         $invoice_TVA           = $invoiceDetails['TVA'];
         $itemTotValu           = $invoiceDetails['PB'];
         $item_total_amountPB   = $itemTotValu;

         function sanitize_input($input) {
               $input = trim($input);
               $input = stripslashes($input);
               $input = htmlspecialchars($input);
               return $input;
            }
            $item_name = sanitize_input($item_designation);
            $item_price_final = floatval($item_price);
            $item_price_ntva = floatval($item_price_nvat);
            $tva_amount = floatval($invoice_TVA);
            $item_price_wvat = floatval($itemTotValu);
            $item_total_amount = floatval($item_total_amountPB);

            $transformedInvoiceItems []= array(
                // array( )
                "device_id" => $device_id,
                "item_designation" => $item_name,
                "item_quantity" => DEFAULT_ITEM_QUANTITY,
                "item_price" => $item_price_final,
                "item_ct" => DEFAULT_ITEM_CT,
                "item_tl" => DEFAULT_ITEM_TL,
                "item_price_nvat" => $item_price_ntva,
                "vat" => $tva_amount,
                "item_price_wvat" => $item_price_wvat,
                "item_total_amount" => $item_total_amount
             );

             $invoiceFinalResponse = array(
	             "invoice_number" => $invoice_number,
                  "invoice_date" => $invoiceOriginal_date,
                  "invoice_type" => "FN",
                  "tp_type" => "1",
                  "tp_name" => "BUSINESS INSURANCE AND REINSURANCE COMPANY",
                  "tp_TIN" => "4000829111",
                  "tp_trade_number" => "08794",
                  "tp_postal_number" => "362",
                  "tp_phone_number" => "22280042",
                  "tp_address_province" => "BUJUMBURA MAIRIE",
                  "tp_address_commune" => "MUKAZA",
                  "tp_address_quartier" => "ROHERO I",
                  "tp_address_avenue" => "ONU",
                  "tp_address_number" => "6",
                  "vat_taxpayer" => "1",
                  "ct_taxpayer" => "0",
                  "tl_taxpayer" => "0",
                  "tp_fiscal_center" => "DGC",
                  "tp_activity_sector" => "ASSURANCE",
                  "tp_legal_form" => "SA",
                  "payment_type" => "1",
                  "invoice_currency" => "BIF",
                  "customer_name" => $customer_name,
                  "customer_TIN" => "",
                  "customer_address" => $customer_address,
                  "vat_customer_payer" => "0",
                  "cancelled_invoice_ref" => "",
                  "invoice_ref" => "",
                  "cn_motif" => "",
                  "invoice_signature" => $signature,
                  "invoice_signature_date" => $invoiceOriginal_date_v1,
                  "invoice_items" =>$transformedInvoiceItems
                );

            $token = $db->getTokenByRequest();

            if (empty($token)) {
                http_response_code(401);
                throw new Exception("Invalid Token");
            }

    // ----------------------------------------------
    // CALL EBMS API
    // ----------------------------------------------
    $ebms_insert = $db->EBMSAddInvoiceByDetails($invoiceFinalResponse,$token);

    if (!$ebms_insert) {
        throw new Exception("Erreur lors de la requête EBMS");
    }

    $json = json_decode($ebms_insert, true);

    // ----------------------------------------------
    // SAFE DATA EXTRACTION
    // ----------------------------------------------
    
    if (!is_array($json)) {
    throw new Exception("Réponse EBMS invalide");
    }

    if (!isset($json['success']) || $json['success'] !== true) {
        $errorMsg = $json['msg'] ?? 'Erreur inconnue EBMS';
        throw new Exception($errorMsg);
    }

    // ----------------------------------------------
    // SUCCESS
    // ----------------------------------------------

     // Top-level values
    $success = $json['success'] ?? false;
    $message = $json['msg'] ?? null;
    $electronicSignature = $json['electronic_signature'] ?? null;

    // Nested "result" values
    $invoiceNumber = $json['result']['invoice_number'] ?? null;
    $invoiceRegisteredNumber = $json['result']['invoice_registered_number'] ?? null;
    $invoiceRegisteredDate = $json['result']['invoice_registered_date'] ?? null;

    $updateInvoice = $db->getSignContractMain($contract_Id);
    if ($updateInvoice !== 1) {
        throw new Exception("Erreur lors de la signature du contrat");
    }

    $updateInvoiceDetails = $db->validateDetailsByInvoice($invoice_number);
    if ($updateInvoiceDetails !== 1) {
        throw new Exception("Erreur lors de la validation des détails de la facture");
    }

    $storeInvoice = $db->getOBRDetailsAdded(
        $invoice_number,
        $invoiceOriginal_date,
        $customer_name,
        $customer_address,
        $signature,
        $invoiceOriginal_date_v1,
        $device_id,
        $item_name,
        $item_price_final,
        $item_price_ntva,
        $tva_amount,
        $item_price_wvat,
        $item_total_amount,
        $contract_Id,
        $ownership_agence,
        $product
    );

    if ($storeInvoice !== 1) {
        throw new Exception("Erreur lors de l'enregistrement des données OBR");
    }

    $_SESSION['success'] = $message;
    header('Location: ../../syst_tax_track_control');
    exit;

    } catch (Exception $e) {

    // ----------------------------------------------
    // ERROR HANDLING
    // ----------------------------------------------
    $_SESSION['stata'] = $e->getMessage();
    header('Location: ../../syst_tax_track_control');
    exit;
}*/
?>