<?php
     class DbOperations
        {
            private $con;

            function __construct(){
                require_once dirname(__FILE__).'/DbConnect.php';
                $db = new DbConnect();

                $this->con = $db->connect();
            }
            /* CRUD -> c -> Create */

            /**
             * Automobile
             */
            public function PullDetailsInvoice($contract_Id){
                $stmt = $this->con->prepare("SELECT Id FROM `agc_contrat` WHERE `Id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }

            public function getDetailsInvoiceById($contract_Id){
                $stmt = $this->con->prepare("SELECT *  FROM `agc_contrat` WHERE `Id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                return $stmt->get_result()->fetch_array();
            }

            public function getTokenByRequest(){
                $data = array(
                    'username' => 'wsl400082911100284',
                    'password' => 'Tt<~,1yN'
                   );
                $ch = curl_init('https://ebms.obr.gov.bi:8443/ebms_api/login/');
                $post = json_encode($data);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, 1); 
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
                $result = curl_exec($ch);
                curl_close($ch);
                //$access_token = json_decode($result);

                $data = json_decode($result, true);
                $access_token = $data['result']['token'];
                $_SESSION['name']=$access_token;
                $access_token=$_SESSION['name'];
                //return $access_token->token;
                return $access_token;
            }

            public function getSoftTokenByRequest(){
                $data = array(
                    'username' => 'wsl400082911100129',
                    'password' => 'Tt<~,1yN'
                   );
                $ch = curl_init('https://ebms.obr.gov.bi:8443/ebms_api/login/');
                $post = json_encode($data);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, 1); 
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
                $result = curl_exec($ch);
                curl_close($ch);
                //$access_token = json_decode($result);

                $data = json_decode($result, true);
                $access_token = $data['result']['token'];
                $_SESSION['name']=$access_token;
                $access_token=$_SESSION['name'];
                //return $access_token->token;
                return $access_token;
            }

            public function getSignContractMain($contract_Id){
              
                    $stat = 2;
                    $dateSend = date("Y-m-d");
                    $stmt = $this->con->prepare("UPDATE `agc_contrat` SET `obr`=?,`date_obr`=? WHERE `Id`=?");
                    $stmt->bind_param("isi", $stat,$dateSend,$contract_Id);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

                
            }

            public function validateDetailsByInvoice($invoice_number){

                    $stat = 2;
                    $dateSend = date("Y-m-d");
                    $stmt = $this->con->prepare("UPDATE `agc_automobile_detail` SET `obr`=?,`date_obr`=? WHERE `Id`=?");
                    $stmt->bind_param("iss", $stat,$dateSend,$invoice_number);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

            }

             public function getOBRDetailsAdded($invoice_number,$invoiceOriginal_date, $customer_name, $customer_address, 
                    $signature, $invoiceOriginal_date_v1, $device_id, $item_name, $item_price_final, $item_price_ntva, $tva_amount, 
                    $item_price_wvat, $item_total_amount, $contract_Id, $ownership_agence, $product){
                if ($this->isOBRDetailsExist($invoice_number)) {
                   return 0;
                }else {
                    $dateSend = date("Y-m-d");
                    $obrValue = 2;
                    //$status   = "Sent";
                    $stmt = $this->con->prepare("INSERT INTO `agc_obr_mobic`(`invoice_number`, `invoice_date`,`customer_name`,
                    `customer_address`, `invoice_signature`, `invoice_signature_date`,`device_id`, `item_designation`, 
                    `item_price`, `item_price_nvat`, `vat`, `item_price_wvat`, `item_total_amount`, `obr`, `obr_date`,
                    `idMobic`, `agence`, `produit`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("ssssssssssssssssss", $invoice_number,$invoiceOriginal_date, $customer_name, $customer_address, 
                    $signature, $invoiceOriginal_date_v1, $device_id, $item_name, $item_price_final, $item_price_ntva, $tva_amount, 
                    $item_price_wvat, $item_total_amount, $obrValue, $dateSend, $contract_Id, $ownership_agence, $product);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }
            public function EBMSconfirmCancel($signatureId){
              
                    $stat = "Canceled";
                    $stmt = $this->con->prepare("UPDATE `agc_obr_mobic` SET `status`=? WHERE `invoice_signature`=?");
                    $stmt->bind_param("ss", $stat,$signatureId);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

                
            }

            private function isOBRDetailsExist($numero_facture){
                $stmt = $this->con->prepare("SELECT id FROM `agc_obr_mobic` WHERE `invoice_number`=?");
                $stmt->bind_param("s", $numero_facture);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }

            /**
             * Transport PullDetailsInvoice
             */
            public function PullDetailsTransInvoice($contract_Id){
                $stmt = $this->con->prepare("SELECT Id FROM `agc_contrat_marine` WHERE `Id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
            public function getDetailsTransInvoiceById($contract_Id){
                $stmt = $this->con->prepare("SELECT *  FROM `agc_contrat_marine` WHERE `Id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                return $stmt->get_result()->fetch_array();
            }
            public function getSignContractTransMain($contract_Id){
              
                    $stat = 2;
                    $dateSend = date("Y-m-d");
                    $stmt = $this->con->prepare("UPDATE `agc_contrat_marine` SET `obr`=?,`date_obr`=? WHERE `Id`=?");
                    $stmt->bind_param("isi", $stat,$dateSend,$contract_Id);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

                
            }
            public function validateDetailsTransByInvoice($invoice_number){

                    $stat = 2;
                    $dateSend = date("Y-m-d");
                    $stmt = $this->con->prepare("UPDATE `agc_transport_detail` SET `obr`=?,`date_obr`=? WHERE `Id`=?");
                    $stmt->bind_param("iss", $stat,$dateSend,$invoice_number);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

            }
            /**
            * Incendie PullDetailsInvoice
            */
            public function PullDetailsIncInvoice($contract_Id){
                $stmt = $this->con->prepare("SELECT Id FROM `agc_contrat_fire` WHERE `Id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
            public function getDetailsIncInvoiceById($contract_Id){
                $stmt = $this->con->prepare("SELECT *  FROM `agc_contrat_fire` WHERE `Id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                return $stmt->get_result()->fetch_array();
            }
            public function getSignContractIncMain($contract_Id){
              
                    $stat = 2;
                    $dateSend = date("Y-m-d");
                    $stmt = $this->con->prepare("UPDATE `agc_contrat_fire` SET `obr`=?,`date_obr`=? WHERE `Id`=?");
                    $stmt->bind_param("isi", $stat,$dateSend,$contract_Id);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

                
            }
            public function validateDetailsIncByInvoice($invoice_number){

                    $stat = 2;
                    $dateSend = date("Y-m-d");
                    $stmt = $this->con->prepare("UPDATE `agc_incendi_detail` SET `obr`=?,`date_obr`=? WHERE `Id`=?");
                    $stmt->bind_param("iss", $stat,$dateSend,$invoice_number);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

            }
            /**
            * Accident PullDetailsInvoice
            */
            public function PullDetailsAccInvoice($contract_Id){
                $stmt = $this->con->prepare("SELECT Id FROM `agc_contrat_ac` WHERE `Id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
            public function getDetailsAccInvoiceById($contract_Id){
                $stmt = $this->con->prepare("SELECT *  FROM `agc_contrat_ac` WHERE `Id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                return $stmt->get_result()->fetch_array();
            }
            public function getSignContractAccMain($contract_Id){
              
                    $stat = 2;
                    $dateSend = date("Y-m-d");
                    $stmt = $this->con->prepare("UPDATE `agc_contrat_ac` SET `obr`=?,`date_obr`=? WHERE `Id`=?");
                    $stmt->bind_param("isi", $stat,$dateSend,$contract_Id);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

                
            }
            public function validateDetailsAccByInvoice($invoice_number){

                    $stat = 2;
                    $dateSend = date("Y-m-d");
                    $stmt = $this->con->prepare("UPDATE `agc_accident_detail` SET `obr`=?,`date_obr`=? WHERE `Id`=?");
                    $stmt->bind_param("iss", $stat,$dateSend,$invoice_number);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

            }
            /**
            * Respons. Civil PullDetailsInvoice
            */
            public function PullDetailsResponsInvoice($contract_Id){
                $stmt = $this->con->prepare("SELECT Id FROM `agc_contrat_rc` WHERE `Id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
            public function getDetailsResponsInvoiceById($contract_Id){
                $stmt = $this->con->prepare("SELECT *  FROM `agc_contrat_rc` WHERE `Id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                return $stmt->get_result()->fetch_array();
            }
            public function getSignContractResponsMain($contract_Id){
              
                    $stat = 2;
                    $dateSend = date("Y-m-d");
                    $stmt = $this->con->prepare("UPDATE `agc_contrat_rc` SET `obr`=?,`date_obr`=? WHERE `Id`=?");
                    $stmt->bind_param("isi", $stat,$dateSend,$contract_Id);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

                
            }
            public function validateDetailsResponsByInvoice($invoice_number){

                    $stat = 2;
                    $dateSend = date("Y-m-d");
                    $stmt = $this->con->prepare("UPDATE `agc_respons_detail` SET `obr`=?,`date_obr`=? WHERE `Id`=?");
                    $stmt->bind_param("iss", $stat,$dateSend,$invoice_number);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

            }
            /**
            * RQuickSoft PullDetailsInvoice
            */
            public function PullDetailsSoftInvoice($contract_Id){
                $stmt = $this->con->prepare("SELECT id FROM `agc_obr_quicksoft` WHERE `id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
            public function getDetailsSoftInvoiceById($contract_Id){
                $stmt = $this->con->prepare("SELECT *  FROM `agc_obr_quicksoft` WHERE `id`=?");
                $stmt->bind_param("i",$contract_Id);
                $stmt->execute();
                return $stmt->get_result()->fetch_array();
            }
            public function getSignContractSoftMain($contract_Id){
              
                    $stat = 1;
                    $dateSend = date("Y-m-d");
                    $stmt = $this->con->prepare("UPDATE `agc_obr_quicksoft` SET `obr`=?,`date_obr`=? WHERE `id`=?");
                    $stmt->bind_param("isi", $stat,$dateSend,$contract_Id);
                    if ($stmt->execute()) {
                    return 1;
                    }else {
                    return 2;
                    }

                
            }

            public function getOBRDetailsSoftAdded($invoice_number,$invoiceOriginal_date, $customer_name, $customer_address, 
                    $signature, $invoiceOriginal_date_v1, $device_id, $item_name, $item_price_final, $item_price_ntva, $tva_amount, 
                    $item_price_wvat, $item_total_amount, $contract_Id, $ownership_agence, $product){
                if ($this->isOBRDetailsSoftExist($invoice_number)) {
                   return 0;
                }else {
                    $dateSend = date("Y-m-d");
                    $obrValue = 2;
                    //$status   = "Sent";
                    $stmt = $this->con->prepare("INSERT INTO `agc_obr_quicksoft_main`(`invoice_number`, `invoice_date`,`customer_name`,
                    `customer_address`, `invoice_signature`, `invoice_signature_date`,`device_id`, `item_designation`, 
                    `item_price`, `item_price_nvat`, `vat`, `item_price_wvat`, `item_total_amount`, `obr`, `obr_date`,
                    `idMobic`, `agence`, `produit`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("ssssssssssssssssss", $invoice_number,$invoiceOriginal_date, $customer_name, $customer_address, 
                    $signature, $invoiceOriginal_date_v1, $device_id, $item_name, $item_price_final, $item_price_ntva, $tva_amount, 
                    $item_price_wvat, $item_total_amount, $obrValue, $dateSend, $contract_Id, $ownership_agence, $product);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isOBRDetailsSoftExist($numero_facture){
                $stmt = $this->con->prepare("SELECT id FROM `agc_obr_quicksoft_main` WHERE `invoice_number`=?");
                $stmt->bind_param("s", $numero_facture);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }

            public function ebmsGetTINByAPI($token, $ebmsCustId){
                $apiEndpoint = 'https://ebms.obr.gov.bi:8443/ebms_api/checkTIN/';
                // Set cURL options
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $apiEndpoint);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Authorization: Bearer ' . $token,
                    'Content-Type: application/json'
                ]);
                // Construct JSON payload with parameter value
                $payload = json_encode(['tp_TIN' => $ebmsCustId]);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                // Execute cURL request
                $response = curl_exec($ch);
                    // Check for cURL errors
                if ($response === false) {
                    $error = curl_error($ch);
                    curl_close($ch);
                    return json_encode([
                        'success' => false,
                        'msg' => 'Error calling API: ' . $error
                    ]);
                }
                // Close cURL session
                curl_close($ch);
                // Parse the JSON response
                $responseData = json_decode($response, true);
                // Check if JSON decoding was successful
                if ($responseData === null) {
                    return json_encode([
                        'success' => false,
                        'msg' => 'Error parsing API response'
                    ]);
                }
                // Return the formatted response
                return json_encode([
                    'success' => true,
                    'msg' => 'Operation reussie',
                    'result' => $responseData
                ]);
            }

            public function EBMSCheckINVByAPI($token,$signatureId){
                $apiEndpoint = 'https://ebms.obr.gov.bi:8443/ebms_api/getInvoice/';
                // Set cURL options
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $apiEndpoint);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Authorization: Bearer ' . $token,
                    'Content-Type: application/json'
                ]);
                // Construct JSON payload with parameter value invoice_signature
                $payload = json_encode(['invoice_signature' => $signatureId]);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                // Execute cURL request
                $response = curl_exec($ch);
                    // Check for cURL errors
                if ($response === false) {
                    $error = curl_error($ch);
                    curl_close($ch);
                    return json_encode([
                        'success' => false,
                        'msg' => 'Error calling API: ' . $error
                    ]);
                }
                // Close cURL session
                curl_close($ch);
                // Parse the JSON response

                return $response;
               
                // $responseData = json_decode($response, true);

                // Check if JSON decoding was successful

               /* if ($responseData === null) {
                    return json_encode([
                        'success' => false,
                        'msg' => 'Error parsing API response'
                    ]);
                }*/

                // Return the formatted response

                /*return json_encode([
                    'success' => true,
                    'msg' => 'Operation reussie',
                    'result' => $responseData
                ]);*/

            }
            public function EBMSCancelInvByAPI($token,$signatureId,$motif){
                $apiEndpoint = 'https://ebms.obr.gov.bi:8443/ebms_api/cancelInvoice/';
                // Set cURL options
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $apiEndpoint);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Authorization: Bearer ' . $token,
                    'Content-Type: application/json'
                ]);
                // Construct JSON payload with parameter value
                $payload = json_encode(['invoice_signature' => $signatureId,'cn_motif' => $motif]);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                // Execute cURL request
                $response = curl_exec($ch);
                    // Check for cURL errors
                if ($response === false) {
                    $error = curl_error($ch);
                    curl_close($ch);
                    return json_encode([
                        'success' => false,
                        'msg' => 'Error calling API: ' . $error
                    ]);
                }
                // Close cURL session
                curl_close($ch);
                // Parse the JSON response
                return $response;
                
                //$responseData = json_decode($response, true);

                // Check if JSON decoding was successful
            
                /* if ($responseData === null) {
                    return json_encode([
                        'success' => false,
                        'msg' => 'Error parsing API response'
                    ]);
                }*/

                // Return the formatted response

             /* return json_encode([
                    'success' => true,
                    'msg' => 'Operation reussie',
                    'result' => $responseData
                ]);*/

            }

           /**
            * General Send Invoice
            */

            public function EBMSAddInvoiceByDetails($invoiceFinalResponse,$token){
                $apiEndpoint = 'https://ebms.obr.gov.bi:8443/ebms_api/addInvoice/';
                // Set cURL options https://ebms.obr.gov.bi:9443/ebms_api/addInvoice_confirm/ 
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $apiEndpoint);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Authorization: Bearer ' . $token,
                    'Content-Type: application/json'
                ]);
                // Encode the details array into JSON format
                $payload = json_encode($invoiceFinalResponse);
                // Set cURL POST request with payload
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                // Execute cURL request
                $response = curl_exec($ch);
                // Check for cURL errors
                if ($response === false) {
                    $error = curl_error($ch);
                    curl_close($ch);
                    return [
                        'success' => false,
                        'msg' => 'Error calling API: ' . $error
                    ];
                }
                // Close cURL session
                curl_close($ch);
                // Parse the JSON response
                return $response;
                //$responseData = json_decode($response, true);
                // Check if JSON decoding was successful
                
                /*if ($responseData === null) {
                    return [
                        'success' => false,
                        'msg' => 'Error parsing API response'
                    ];
                }
                */
                // Return the formatted response

               /* return [
                    'success' => true,
                    'msg' => 'Operation reussie',
                    'rslt' => $responseData
                ];*/

            }


            //=================================================

            /*
            public function getTokenBySignIn(){
                $data = array(
                    'username' => 'wsl400082911100284',
                    'password' => 'Tt<~,1yN'
                   );
                $ch = curl_init('https://ebms.obr.gov.bi:8443/ebms_api/login/');
                $post = json_encode($data);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, 1); 
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
                $result = curl_exec($ch);
                curl_close($ch);
                //$access_token = json_decode($result);

                $data = json_decode($result, true);
                $access_token = $data['result']['token'];
                $_SESSION['name']=$access_token;
                $access_token=$_SESSION['name'];
                //return $access_token->token;
                return $access_token;
            }

            public function getPsrSign($Sign,$mobic_ProId){
                $dateSend = date("Y-m-d");
                $stmt = $this->con->prepare("UPDATE `bic_obr_dataebms` SET `obr`=?,`date`=? WHERE `id`=?");
                $stmt->bind_param("sss", $Sign,$dateSend,$mobic_ProId);
                if ($stmt->execute()) {
                return 1;
                }else {
                 return 2;
                }
            }

            public function getProof($numero_facture,$date_facture,$proprioLib,$residence,$signature,$device_name,
                                    $item_name,$item_price,$item_price_ntva,$tva_amount,$item_price_wvat,$item_total_amount,
                                    $mobic_ProId){
                if ($this->isProofExist($numero_facture)) {
                   return 0;
                }else {
                    $dateSend = date("Y-m-d");
                    $obrValue = 2;
                    $stmt = $this->con->prepare("INSERT INTO `bic_obr_mobic`(`invoice_number`, `invoice_date`,`customer_name`,`customer_address`, `invoice_signature`, `invoice_signature_date`,`device_id`, `item_designation`, `item_price`, `item_price_nvat`, `vat`, `item_price_wvat`, `item_total_amount`, `obr`, `obr_date`,`idMobic`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $stmt->bind_param("ssssssssssssssss", $numero_facture,$date_facture,$proprioLib,$residence,$signature,$date_facture,$device_name,$item_name,$item_price,$item_price_ntva,$tva_amount,$item_price_wvat,$item_total_amount,$obrValue,$dateSend,$mobic_ProId);
                    if ($stmt->execute()) {
                       return 1;
                    }else {
                        return 2;
                    }
                }

            }

            private function isProofExist($numero_facture){
                $stmt = $this->con->prepare("SELECT id FROM `bic_obr_mobic` WHERE `invoice_number`=?");
                $stmt->bind_param("s", $numero_facture);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows > 0;
            }

            public function mobicEBMSinvcnc(){
                $data = array(
                    'username' => 'wsl400082911100284',
                    'password' => 'Tt<~,1yN'
                   );
                $ch = curl_init('https://ebms.obr.gov.bi:8443/ebms_api/login/');
                $post = json_encode($data);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, 1); 
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
                $result = curl_exec($ch);
                curl_close($ch);
                $data = json_decode($result, true);
                $access_token = $data['result']['token'];
                $_SESSION['name']=$access_token;
                $access_token=$_SESSION['name'];
                 return $access_token;
            }

            public function mobicEBMSinvchck($mobic_ProId){
                $stmt = $this->con->prepare("SELECT id FROM `bic_obr_mobic` WHERE `id`=?");
                $stmt->bind_param("s",$mobic_ProId);
                $stmt->execute();
                $stmt->store_result();
                return $stmt->num_rows >0;
            }
            
            public function getSignatureById($mobic_ProId){
                $stmt = $this->con->prepare("SELECT *  FROM `bic_obr_mobic` WHERE `id`=?");
                $stmt->bind_param("s",$mobic_ProId);
                $stmt->execute();
                return $stmt->get_result()->fetch_array();
            }

            public function getTokenBySignInchck(){
                $data = array(
                    'username' => 'wsl400082911100284',
                    'password' => 'Tt<~,1yN'
                   );
                $ch = curl_init('https://ebms.obr.gov.bi:8443/ebms_api/login/');
                $post = json_encode($data);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, 1); 
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post); 
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
                $result = curl_exec($ch);
                curl_close($ch);
                $data = json_decode($result, true);
                $access_token = $data['result']['token'];
                $_SESSION['name']=$access_token;
                $access_token=$_SESSION['name'];
                 return $access_token;
            }
            */

         }
 ?>