<?php
require_once('../fpdfLib/fpdf.php');
require_once('../includes/DGenerators.php');

class InsuranceCardPDF extends FPDF {
    private $cardData;
    private $leftCardSettings = [];
    private $rightCardSettings = [];
    
    public function __construct($data) {
        parent::__construct('P', 'mm', 'A4');
        $this->cardData = $data;
        
        // Default positions for left card (first card)
        $this->leftCardSettings = [
            'company' => ['x' => 22, 'y' => 25, 'w' => 30],
            'dates' => ['x' => 18, 'y' => 45, 'w' => 20],
            'times' => ['x' => 22, 'y' => 48, 'w' => 15],
            'client' => ['x' => 12, 'y' => 58, 'w' => 60],
            'province' => ['x' => 17, 'y' => 68, 'w' => 60],
            'policy' => ['x' => 17, 'y' => 76, 'w' => 60],
            'vehicle' => ['x' => 15, 'y' => 80, 'w' => 30],
            'plate' => ['x' => 17, 'y' => 84, 'w' => 60],
            'chassis' => ['x' => 17, 'y' => 88, 'w' => 80],
            'insurance' => ['x' => 15, 'y' => 93, 'w' => 60],
            'count' => ['x' => 23, 'y' => 100, 'w' => 23]
        ];
        
        // Default positions for right card (offset by 98mm)
        $this->rightCardSettings = $this->leftCardSettings;
        foreach ($this->rightCardSettings as &$setting) {
            $setting['x'] += 100;
        }
    }
    
    public function generate() {
        $this->AddPage();
        
        // Left card with left card settings
        $this->addCard($this->leftCardSettings);
        
        // Right card with right card settings
        $this->addCard($this->rightCardSettings);
        
        return $this->Output('S');
    }
    
    // Method to adjust positions for a specific card
    public function adjustCardPosition($cardSide, $element, $x, $y, $width = null) {
        if ($cardSide === 'left') {
            $this->leftCardSettings[$element]['x'] = $x;
            $this->leftCardSettings[$element]['y'] = $y;
            if ($width !== null) {
                $this->leftCardSettings[$element]['w'] = $width;
            }
        } else {
            $this->rightCardSettings[$element]['x'] = $x;
            $this->rightCardSettings[$element]['y'] = $y;
            if ($width !== null) {
                $this->rightCardSettings[$element]['w'] = $width;
            }
        }
    }
    
    private function addCard($settings) {
        $this->SetFont('Arial', '', 8);
        $lh = 6; // Line height
        
        // Company Header
        $this->SetXY($settings['company']['x'], $settings['company']['y']);
        $this->Cell($settings['company']['w'], $lh, strtoupper($this->cardData['company_name']), 0, 1);
        
        // Dates
        $this->SetXY($settings['dates']['x'], $settings['dates']['y']);
        $this->Cell($settings['dates']['w'], $lh, $this->formatDate($this->cardData['DateEffet']), 0, 0);
        $this->Cell($settings['dates']['w'], $lh, $this->formatDate($this->cardData['DateEcheance']), 0, 1);
        
        // Times
        $this->SetXY($settings['times']['x'], $settings['times']['y']);
        $this->Cell($settings['times']['w'], $lh, $this->cardData['timeCreation'], 0, 0);
        $this->Cell($settings['times']['w'] + 5, $lh, $this->cardData['expiry_time'], 0, 1);
        
        // Client Information
        $this->SetXY($settings['client']['x'], $settings['client']['y']);
        $this->Cell($settings['client']['w'], $lh, strtoupper($this->cardData['Proprietaire']), 0, 1);
        
        $this->SetXY($settings['province']['x'], $settings['province']['y']);
        $this->Cell($settings['province']['w'], $lh, strtoupper($this->cardData['province']), 0, 1);
        
        // Policy Information
        $this->SetXY($settings['policy']['x'], $settings['policy']['y']);
        $this->Cell($settings['policy']['w'], $lh, $this->cardData['Numpol'], 0, 1);
        
        // Vehicle Information
        $this->SetXY($settings['vehicle']['x'], $settings['vehicle']['y']);
        $this->Cell($settings['vehicle']['w'], $lh, strtoupper($this->cardData['ClassMarkModel']), 0, 1);
        
        // Plate Number
        $this->SetXY($settings['plate']['x'], $settings['plate']['y']);
        $this->Cell($settings['plate']['w'], $lh, $this->cardData['Plaque'], 0, 1);
        
        // Chassis Number
        $this->SetXY($settings['chassis']['x'], $settings['chassis']['y']);
        $this->Cell($settings['chassis']['w'], $lh, $this->cardData['NumChasis'], 0, 1);
        
        // Insurance Type
        $this->SetXY($settings['insurance']['x'], $settings['insurance']['y']);
        $this->Cell($settings['insurance']['w'], $lh, $this->cardData['UsageAuto'], 0, 1);
        
        // Card Count
        $this->SetXY($settings['count']['x'], $settings['count']['y']);
        $this->Cell($settings['count']['w'], $lh, $this->cardData['PaleSeatCabine'], 0, 0);
        $this->Cell(20, $lh, $this->cardData['SeatPlacePlato'], 0, 1);
    }
    
    private function formatDate($dateString) {
        return date('d/m/Y', strtotime($dateString));
    }
}

/*class InsuranceCardPDF extends FPDF {
    private $cardData;
    
    public function __construct($data) {
        parent::__construct('P', 'mm', 'A4'); // Portrait A4 (210x297mm)
        $this->cardData = $data;
    }
    
    public function generate() {
        $this->AddPage();
        
        // Left card (10mm from left edge)
        $this->addCard(2);
        
        // Right card (100mm from left edge - adjust spacing as needed)
        $this->addCard(100);
        
        return $this->Output('S');
    }
    
    private function addCard($xOffset) {
        $this->SetFont('Arial', '', 8);
        $lh = 6; // Line height
        
        // Company Header 20 34 30
        $this->SetXY($xOffset + 18, 28);
        $this->Cell(30, $lh, strtoupper($this->cardData['company_name']), 0, 1);
        
        
        // Dates old Y: 20 30 24
        $this->SetXY($xOffset + 18, 45);
        $this->Cell(20, $lh, $this->formatDate($this->cardData['DateEffet']), 0, 0);
        $this->Cell(20, $lh, $this->formatDate($this->cardData['DateEcheance']), 0, 1);
        
        // Times old Y: 22 36 26
        $this->SetXY($xOffset + 22, 48);
        $this->Cell(15, $lh, $this->cardData['timeCreation'], 0, 0);
        $this->Cell(20, $lh, $this->cardData['expiry_time'], 0, 1);
        
        // Client Information 45
        $this->SetXY($xOffset + 12, 58);
        $this->Cell(60, $lh, strtoupper($this->cardData['Proprietaire']), 0, 1);
        // 20 55
        $this->SetXY($xOffset + 15, 70);
        $this->Cell(60, $lh, strtoupper($this->cardData['province']), 0, 1);
        
        // Policy Information 20 65
        $this->SetXY($xOffset + 15, 76);
        $this->Cell(60, $lh, $this->cardData['Numpol'], 0, 1);
        
        // Vehicle Information 20 71
        $this->SetXY($xOffset + 15, 80);
        $this->Cell(30, $lh, strtoupper($this->cardData['ClassMarkModel']), 0, 0);
        $this->Cell(30, $lh, '', 0, 1);
        
        // Plate Number 20 77 76
        $this->SetXY($xOffset + 15, 84);
        $this->Cell(60, $lh, $this->cardData['Plaque'], 0, 1);
        
        // Chassis Number 20 83 80
        $this->SetXY($xOffset + 15, 88);
        $this->Cell(80, $lh, $this->cardData['NumChasis'], 0, 1);
        
        // Insurance Type 20 89 84
        $this->SetXY($xOffset + 15, 94);
        $this->Cell(60, $lh, $this->cardData['UsageAuto'], 0, 1);
        
        // Card Count 24 97 100 90
        $this->SetXY($xOffset + 18, 98);
        $this->Cell(23, $lh, $this->cardData['PaleSeatCabine'], 0, 0);
        $this->Cell(20, $lh, $this->cardData['SeatPlacePlato'], 0, 1);
    }
    
    private function formatDate($dateString) {
        return date('d/m/Y', strtotime($dateString));
    }
}

*/

// Database Connection and Data Fetching
try {
    $id = $_GET['id'] ?? 0;
    $dbOps = new DGenerators();
    $cardData = $dbOps->getInsuranceCardData($id);
    
    // Generate PDF
    $pdfGenerator = new InsuranceCardPDF($cardData);
    //$pdfContent = $pdfGenerator->generate();
    
    // Adjust positions before generation (if needed)
$pdfGenerator->adjustCardPosition('left', 'dates', 20, 45); // Move left card dates down
$pdfGenerator->adjustCardPosition('right', 'company', 110, 24); // Move right card company header

// Generate PDF
$pdfContent = $pdfGenerator->generate();
    
    // Output to browser
    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="insurance_card_'.$id.'.pdf"');
    echo $pdfContent;
    
} catch (Exception $e) {
    header('Content-Type: text/plain');
    http_response_code(400);
    echo "Error: " . $e->getMessage();
}
/*require_once('../includes/DGenerators.php');
require_once 'InsuranceCardPDFv3.php';

try {
    //$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
    $id = $_GET['id'] ?? 0;
    if ($id <= 0) {
        throw new Exception("Invalid ID parameter");
    }

    $dbOps = new DGenerators();
    $cardData = $dbOps->getInsuranceCardData($id);

    if (!$cardData) {
        throw new Exception("No insurance card found with ID: $id");
    }

    $pdfGenerator = new InsuranceCardPDFv3($cardData);
    $pdfContent = $pdfGenerator->generate();

    // Clean buffer and output PDF
    ob_end_clean(); // Clear any unwanted output
    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="insurance_card_'.$id.'.pdf"');
    echo $pdfContent;

} catch (Exception $e) {
    ob_end_clean(); // Clear anything that was printed
    header('Content-Type: text/plain');
    http_response_code(400);
    echo "Error: " . $e->getMessage();
}*/

?>