<?php
require_once('../fpdfLib/fpdf.php');
require_once('../includes/DGenerators.php');

class InvoicePDF extends FPDF {
    private $data;
    private $headerImage = 'ressources/img/header1s.png';
    private $footerImage = 'ressources/img/footer1s.png';
    
    public function __construct($data) {
        parent::__construct('L', 'mm', 'A4'); // Landscape A4
        $this->data = $data;
    }
    
    public function generate() {
        $this->AddPage();
        
        // First invoice copy
        $this->generateInvoice();
        
        // Second invoice copy (duplicate)
        $this->generateInvoice();
        
        return $this->Output('S');
    }
    
    private function generateInvoice() {
        // Header Image
        if(file_exists($this->headerImage)) {
            $this->Image($this->headerImage, 10, 10, 277); // Full width
        }
        
        $this->SetY(40); // Position after header
        
        // Company Info
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 6, 'BIC NON VIE', 0, 1, 'C');
        $this->Cell(0, 6, 'Date: '.$this->data['facture'], 0, 1, 'C');
        $this->Cell(0, 6, '(BUSINESS INSURANCE & REINSURANCE COMPANY)', 0, 1, 'C');
        $this->Cell(0, 6, 'Entreprise rgie par le code des assurances du Burundi', 0, 1, 'C');
        $this->Ln(5);
        
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 8, 'Votre Assureur Prfr', 0, 1, 'C');
        $this->Ln(5);
        
        // Invoice Number
        $this->SetFont('Arial', 'B', 14);
        $this->Cell(0, 10, 'NOTE DE FACTURE N '.$this->data['facture'].' DU '.$this->formatDate($this->data['DateEmission']), 0, 1, 'C');
        $this->Ln(10);
        
        // Seller Information
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 8, 'A. IDENTIFICATION DU VENDEUR', 0, 1);
        $this->SetFont('Arial', '', 10);
        
        // Seller Table
        $this->createInfoTable([
            ['Raison Sociale :', $this->data['company_name'], 'Centre Fiscal :', 'DGC'],
            ['NIF :', $this->data['company_NIF'], 'Secteur d\'activit :', 'Assurance'],
            ['Registre du Commerce :', '08794', 'Forme juridique :', 'SA'],
            ['BP :', '362', 'Commune :', 'MUKAZA'],
            ['Quartier :', 'ROHERO 1.', 'Avenue de :', 'TONU N6.'],
            ['Assujetti  la TVA :', 'OUI', 'Commentaire :', 'Ass. AUTOMOBILE']
        ]);
        $this->Ln(10);
        
        // Client Information
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 8, 'A. LE CLIENT', 0, 1);
        $this->SetFont('Arial', '', 10);
        
        // Client Table
        $this->createInfoTable([
            ['Raison Sociale :', $this->data['Proprietaire'], '', ''],
            ['NIF :', $this->data['NIF'], '', ''],
            ['Rsident  :', $this->data['residence'], '', ''],
            ['Assujetti  la TVA :', $this->data['TVA'], '', ''],
            ['Mode de Paiement :', $this->data['mode_payment'], '', '']
        ]);
        $this->Ln(5);
        
        // Policy Information
        $this->createInfoTable([
            ['Num Police :', $this->data['Numpol'], '', ''],
            ['Classe d\'assurance :', $this->data['PlaqueCategor'], '', ''],
            ['Bnfciaire :', $this->data['Proprietaire'], '', ''],
            ['Prix de Couverture DU', $this->formatDate($this->data['DateEffet']), 'AU', $this->formatDate($this->data['DateEcheance'])]
        ]);
        $this->Ln(10);
        
        // Invoice Items
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 8, 'Votre compte a t dbit comme suit:', 0, 1);
        $this->SetFont('Arial', '', 10);
        
        // Items Table
        $this->createItemsTable([
            ['Description', 'Montant'],
            ['Prime', $this->formatNumber($this->data['PN'])],
            ['Rabais', $this->formatNumber($this->data['RAB'])],
            ['Frais administratifs', $this->formatNumber($this->data['FRAIS'])],
            ['CD+ARCA+FAPS', $this->formatNumber($this->data['CD'])],
            ['TVA (18% de la Prime)', $this->formatNumber($this->data['TVA'])],
           // [strtolower($this->data['amount_in_words']), $this->formatNumber($this->data['PB'])]
            [$this->convertAmountToWords($this->data['PB']), $this->formatNumber($this->data['PB'])]
        ]);
        $this->Ln(15);
        
        // Footer
        $this->SetFont('Arial', '', 10);
        $this->Cell(90, 6, 'Prpar par :', 0, 0);
        $this->Cell(0, 6, $this->data['Creator'], 0, 1);
        $this->Ln(5);
        
        $this->Cell(0, 6, 'Pour Business Insurance and Reinsurance Company', 0, 1, 'C');
        $this->Cell(0, 6, 'Authoris par :', 0, 1, 'C');
        $this->Ln(5);
        
        // Signature
        $this->SetFont('Arial', '', 8);
        $this->Cell(0, 5, 'Signature: '.$this->data['signature'], 0, 1);
        $this->Cell(0, 5, 'E: info@bic.bi W: www.bic', 0, 1);
        $this->Cell(0, 5, 'T: +257 22289406', 0, 1);
        $this->Cell(0, 5, 'Compte BANCOBU: 02552720102-44 BGF: 202870090006 BLIE: 0120101000613 CRDB: 0150807167000', 0, 1);
        
        // Footer Image
        if(file_exists($this->footerImage)) {
           // $this->Image($this->footerImage, 10, 180, 277); // Full width
        }
        
        // Add space between copies
        $this->Ln(20);
    }
    
    private function createInfoTable($rows) {
        $this->SetFillColor(240, 240, 240);
        $this->SetDrawColor(200, 200, 200);
        
        foreach($rows as $row) {
            $this->Cell(50, 8, $row[0], 1, 0, 'L', true);
            $this->Cell(60, 8, $row[1], 1, 0, 'L');
            if(isset($row[2])) {
                $this->Cell(50, 8, $row[2], 1, 0, 'L', true);
                $this->Cell(60, 8, $row[3], 1, 1, 'L');
            } else {
                $this->Cell(110, 8, '', 1, 1, 'L');
            }
        }
    }
    
    private function createItemsTable($rows) {
        $this->SetFillColor(240, 240, 240);
        $this->SetDrawColor(200, 200, 200);
        
        // Header
        $this->Cell(140, 8, $rows[0][0], 1, 0, 'C', true);
        $this->Cell(50, 8, $rows[0][1], 1, 1, 'C', true);
        
        // Items
        $this->SetFont('Arial', '', 10);
        for($i = 1; $i < count($rows); $i++) {
            $this->Cell(140, 8, $rows[$i][0], 1, 0, 'L');
            $this->Cell(50, 8, $rows[$i][1], 1, 1, 'R');
        }
    }
    
    private function formatDate($dateString) {
        return date('d/m/Y', strtotime($dateString));
    }
    
    private function formatNumber($number) {
        return number_format($number, 2, ',', ' ');
    }
    private function convertAmountToWords($amount) {
    $whole = floor($amount);
    $fraction = round(($amount - $whole) * 100);
    
    $converter = new NumberFormatter('fr', NumberFormatter::SPELLOUT);
    $words = $converter->format($whole);
    
    // Convert to proper French wording for invoices
    $words = str_replace(
        ['un', 'deux', 'trois', 'quatre', 'cinq', 'six', 'sept', 'huit', 'neuf', 'dix',
         'onze', 'douze', 'treize', 'quatorze', 'quinze', 'seize', 'vingt', 'trente',
         'quarante', 'cinquante', 'soixante', 'cent', 'mille', 'million', 'milliard'],
        ['un', 'deux', 'trois', 'quatre', 'cinq', 'six', 'sept', 'huit', 'neuf', 'dix',
         'onze', 'douze', 'treize', 'quatorze', 'quinze', 'seize', 'vingt', 'trente',
         'quarante', 'cinquante', 'soixante', 'cent', 'mille', 'million', 'milliard'],
        $words
    );
    
    // Handle fractions (centimes)
    if ($fraction > 0) {
        $words .= ' virgule ' . $converter->format($fraction);
    }
    
    // Convert to lowercase and remove hyphens (common in French invoices)
    $words = str_replace('-', ' ', strtolower($words));
    
    // Special cases
    $words = str_replace(
        ['vingt un', 'vingt deux', 'vingt trois', 'vingt quatre', 'vingt cinq',
         'vingt six', 'vingt sept', 'vingt huit', 'vingt neuf',
         'soixante et un', 'soixante et onze'],
        ['vingt-et-un', 'vingt-deux', 'vingt-trois', 'vingt-quatre', 'vingt-cinq',
         'vingt-six', 'vingt-sept', 'vingt-huit', 'vingt-neuf',
         'soixante-et-un', 'soixante-et-onze'],
        $words
    );
    
    // Add currency (Francs burundais)
    $words .= ' francs burundais';
    
    return $words;
}
}
