<?php
require_once('../fpdfLib/fpdf.php');
class InsurancePDFGeneratorPBMO {
    private $pdf;
    private $data;
    private $currentY;
     private $headerImage = 'ressources/img/header1s.png';

    public function __construct($data) {
        $this->data = $data;
        $this->pdf = new FPDF();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial', '', 10);
        $this->currentY = $this->pdf->GetY();
    }

    public function generate() {
        $this->addHeader();
        $this->addPolicyInfo();
        $this->addGoodsCharacteristics();
        $this->addInsuranceDetails();
        $this->addSignatures();
        $this->addPaymentDetails();
        $this->addFooter();
        
        return $this->pdf->Output('S');
    }

    private function addHeader() {
        $this->pdf->SetFont('Arial', 'B', 12);
        $this->pdf->Cell(0, 8, 'CONDITIONS PARTICULIERES: ASSURANCE AUTOMOBILE', 0, 1, 'C');
        //$this->pdf->Ln(5);
        
        // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
       /* $this->pdf->SetFont('Arial', 'B', 10);
        $this->pdf->Cell(50, 8, 'Nom ou Raison sociale :', 0, 0);
        $this->pdf->SetFont('Arial', '', 10);
        $this->pdf->Cell(0, 8, $this->data['Proprietaire'], 0, 1);
        
        $this->pdf->Cell(50, 8, 'Adresse:', 0, 0);
        $this->pdf->Cell(0, 8, $this->data['residence'], 0, 1);
        
        $this->pdf->Cell(50, 8, 'Telephone :', 0, 0);
        $this->pdf->Cell(0, 8, $this->data['phone'], 0, 1);
        
        $this->pdf->SetFont('Arial', 'B', 10);
        $this->pdf->Cell(0, 8, 'PROJECT TO SUPPORT FOUNDATIONS OF THE DIGITAL ECONOMY IN BURUNDI "PAFEN"', 0, 1, 'C');
        $this->pdf->Ln(5);*/
    }

   private function addPolicyInfo() {
        $this->pdf->SetFont('Arial', '', 9);
        
        // row 1.0
        $this->pdf->Cell(35, 8, 'Date de l\'operation:', 0, 0);
        $this->pdf->Cell(30, 8, $this->formatDate($this->data['DateEmission']), 0, 0);
        $this->pdf->Cell(30, 8, 'Intermediaire:', 0, 0);
        $this->pdf->Cell(0, 8,'N/A' , 0, 1);
        
        // row 2.0
        $this->pdf->Cell(35, 8, 'Numero de Police:', 0, 0);
        $this->pdf->Cell(30, 8, $this->data['Numpol'], 0, 0);
        $this->pdf->Cell(30, 8, 'Facture No.:', 0, 0);
        $this->pdf->Cell(0, 8, $this->data['facture'] , 0, 1);
        
        
        //$this->pdf->Ln(10);
        
        // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
        // row 3.0
        $this->pdf->Cell(45, 8, 'Date d\'effet:', 0, 0);
        $this->pdf->Cell(30, 8, $this->formatDate($this->data['DateEffet']), 0, 0);
        $this->pdf->Cell(40, 8, 'Date d\'echeance:', 0, 0);
        $this->pdf->Cell(40, 8,  $this->formatDate($this->data['DateEcheance']), 0, 1);
     //   $this->pdf->Cell(40, 8, 'Garantie:', 0, 0);
       // $this->pdf->Cell(40, 8,  $this->formatDate($this->data['Garantie']), 0, 1);
      //  $this->pdf->Cell(0, 8,  '', 0, 1);
        
        // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
        //$this->pdf->Ln(10);
        
        // row 4.0
        $this->pdf->Cell(35, 8, 'Preneur d\'assurance:', 0, 0);
        $this->pdf->Cell(40, 8, $this->data['Proprietaire'], 0, 0);
        $this->pdf->Cell(20, 8, 'Residence:', 0, 0);
        $this->pdf->Cell(20, 8,  $this->data['residence'], 0, 0);
        $this->pdf->Cell(20, 8, 'NIF:', 0, 0);
        $this->pdf->Cell(0, 8,  $this->data['NIF'], 0, 1);
        
        // row 5.0
        $this->pdf->Cell(25, 8, 'Souscripteur No.:', 0, 0);
        $this->pdf->Cell(25, 8, $this->data['user_code'], 0, 0);
        $this->pdf->Cell(20, 8, 'Adresse:', 0, 0);
        $this->pdf->Cell(20, 8,  $this->data['residence'], 0, 0);
        $this->pdf->Cell(20, 8, 'Telephone:', 0, 0);
        $this->pdf->Cell(0, 8,  $this->data['phone'], 0, 1);
        
       
        
        // First row
      /*  $this->pdf->Cell(45, 8, 'Date d\'effet:', 0, 0);
        $this->pdf->Cell(30, 8, $this->formatDate($this->data['DateEffet']), 0, 0);
        $this->pdf->Cell(30, 8, 'TR' . $this->data['facture'], 0, 1);
        
        // Second row
        $this->pdf->Cell(45, 8, 'Souscripteur No.:', 0, 0);
        $this->pdf->Cell(30, 8, $this->data['user_code'], 0, 0);
        $this->pdf->Cell(30, 8, 'Date de l\'operation:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatDate($this->data['DateEmission']), 0, 1);
        
        // Third row $this->data['intermediaire']
        $this->pdf->Cell(45, 8, 'Numero de Police:', 0, 0);
        $this->pdf->Cell(30, 8, $this->data['Numpol'], 0, 0);
        $this->pdf->Cell(30, 8, 'Intermediaire:', 0, 0);
        $this->pdf->Cell(0, 8,'N/A' , 0, 1);
        
        // Fourth row $this->data['avenant_num']
        $this->pdf->Cell(45, 8, 'Avenant N째:', 0, 0);
        $this->pdf->Cell(30, 8, 'N/A', 0, 0);
        $this->pdf->Cell(30, 8, 'Date d\'echeance:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatDate($this->data['DateEcheance']), 0, 1);
        
        // Fifth row $this->data['duree_jours'] , $this->data['profession']
        $this->pdf->Cell(45, 8, 'Duree:', 0, 0);
        $this->pdf->Cell(30, 8, 'N/A' . ' Jours', 0, 0);
        $this->pdf->Cell(30, 8, 'Profession:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        // Sixth row $this->data['email']
        $this->pdf->Cell(45, 8, 'Email:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A' , 0, 1);*/
        
        //$this->pdf->Ln(10);
    }

    private function addGoodsCharacteristics() {
        // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
        $this->pdf->SetFont('Arial', 'B', 8);
        $this->pdf->Cell(0, 8, 'CARACTERISTIQUES DES OBJETS ASSURES', 0, 1, 'C');
        $this->pdf->SetFont('Arial', '', 9);
        // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
        // row 6.0
        $this->pdf->Cell(30, 8, 'Immatric. Veh.:', 0, 0);
        $this->pdf->Cell(20, 8, $this->data['Plaque'], 0, 0);
        $this->pdf->Cell(20, 8, 'No Chassis:', 0, 0);
        $this->pdf->Cell(38, 8,  $this->data['NumChasis'], 0, 0);
        $this->pdf->Cell(20, 8, 'Marque:', 0, 0);
        $this->pdf->Cell(30, 8, $this->data['ClassMarkModel'], 0, 1);
       // $this->pdf->Cell(0, 8,  'N/A', 0, 1);
        
        // row 7.0
        
        $this->pdf->Cell(28, 8, 'Puissance:', 0, 0);
        $this->pdf->Cell(20, 8, $this->data['PuissanceCV'], 0, 0);
        $this->pdf->Cell(25, 8, 'Pass. en Cabine:', 0, 0);
        $this->pdf->Cell(40, 8,  $this->data['PaleSeatCabine'], 0, 0);
        $this->pdf->Cell(35, 8, 'Pass. sur plateau:', 0, 0);
        $this->pdf->Cell(40, 8,  $this->data['SeatPlacePlato'], 0, 1);
        //  $this->pdf->Cell(0, 8,  'N/A', 0, 1);
        
        
        // row 8.0
        $this->pdf->Cell(18, 8, 'Usage:', 0, 0);
        $this->pdf->Cell(30, 8, $this->data['UsageAuto'], 0, 0);
        $this->pdf->Cell(25, 8, 'N° Certificat.:', 0, 0);
        $this->pdf->Cell(40, 8,  $this->data['NumCertificat'], 0, 0);
        $this->pdf->Cell(35, 8, 'Par:', 0, 0);
        $this->pdf->Cell(0, 8,  'N/A', 0, 1);
        /*
        $this->pdf->SetFont('Arial', 'B', 8);
        $this->pdf->Cell(0, 8, 'DETAILS DE LA PRIME D\'ASSURANCE AUTOMOBILE', 0, 1, 'C');
        $this->pdf->SetFont('Arial', '', 9);
        // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
        // row 9.0
        $this->pdf->Cell(45, 8, 'Prime Nette :', 0, 0);
        $this->pdf->Cell(20, 8, $this->formatNumber($this->data['PN']), 0, 0);
        $this->pdf->Cell(20, 8, 'Frais admin.:', 0, 0);
        $this->pdf->Cell(30, 8,  $this->formatNumber($this->data['FRAIS']), 0, 0);
        $this->pdf->Cell(20, 8, 'Contrib Dev.:', 0, 0);
        $this->pdf->Cell(30, 8,  $this->formatNumber($this->data['CD']), 0, 1);
         // $this->pdf->Cell(0, 8,  'N/A', 0, 1);
        
        // row 10.0
        $this->pdf->Cell(45, 8, 'T.V.A.:', 0, 0);
        $this->pdf->Cell(20, 8, $this->formatNumber($this->data['TVA']), 0, 0);
        $this->pdf->Cell(20, 8, 'Prime brute :', 0, 0);
        $this->pdf->Cell(30, 8,  $this->formatNumber($this->data['PB']), 0, 0);
        $this->pdf->Cell(20, 8, 'Facture Num :', 0, 0);
        $this->pdf->Cell(30, 8,  $this->data['facture'], 0, 1);
        //$this->pdf->Cell(0, 8,  'N/A', 0, 1);*/
        
      
        /*
          
        // row 11.0
        $this->pdf->Cell(35, 8, 'Description:', 0, 0);
        $this->pdf->Cell(30, 8, $this->data['nature_marchandise'], 0, 1);
        
        $this->pdf->SetFont('Arial', 'B', 10);
        $this->pdf->Cell(0, 8, 'CARACTERISTIQUES DES MARCHANDISES & DU VOYAGE', 0, 1);
        $this->pdf->SetFont('Arial', '', 9);
        
        //$this->data['identification_objet']
        $this->pdf->Cell(50, 8, 'IDENTIFICATION DE(S) OBJET(S) ASSURE(S)', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        $this->pdf->Cell(50, 8, 'Valeur assuree (En Devises):', 0, 0);
        $this->pdf->Cell(30, 8, $this->formatNumber($this->data['valeur_devise']), 0, 0);
        $this->pdf->Cell(30, 8, 'En BIF:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['PN']), 0, 1);
        
        $this->pdf->Cell(50, 8, 'Description:', 0, 0);
        $this->pdf->MultiCell(0, 8, $this->data['nature_marchandise'], 0, 1);
        
        $this->pdf->Cell(50, 8, 'Nature de l\'emballage:', 0, 0);
        $this->pdf->Cell(30, 8, $this->data['natureEmballage'], 0, 0);
        $this->pdf->Cell(30, 8, 'Type de Transport:', 0, 0);
        $this->pdf->Cell(0, 8, $this->data['type_voie'], 0, 1);
        
        $this->pdf->Cell(50, 8, 'Depart:', 0, 0);
        $this->pdf->Cell(30, 8, $this->data['pays_port_origine'], 0, 0);
        $this->pdf->Cell(30, 8, 'Arrivee:', 0, 0);
        $this->pdf->Cell(0, 8, $this->data['pays_port_destination'], 0, 1);
        
        //$this->data['quantite'] $this->data['nombre_colis']
        $this->pdf->Cell(50, 8, 'Quantite:', 0, 0);
        $this->pdf->Cell(30, 8, '0', 0, 0);
        $this->pdf->Cell(30, 8, 'Nombre de Colis:', 0, 0);
        $this->pdf->Cell(0, 8, '0', 0, 1);
        
        //$this->data['transport_par']
        $this->pdf->Cell(50, 8, 'Par:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        $this->pdf->Ln(10);
        */
        
    }

    private function addInsuranceDetails() {
       
      
        
        // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
         $this->pdf->SetFont('Arial', 'B', 8);
        $this->pdf->Cell(0, 8, 'DETAILS DE LA PRIME D\'ASSURANCE AUTOMOBILE', 0, 1, 'C');
        $this->pdf->SetFont('Arial', '', 9);
      //  $this->pdf->Cell(0, 8, 'IDENTIFICATION DE(S) OBJET(S) ASSURE(S)', 0, 1, 'C');
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
        $this->pdf->SetFont('Arial', 'B', 10);
        $this->pdf->Cell(35, 8, 'Objet assure', 0, 0);
        $this->pdf->Cell(70, 8, 'Garantie', 0, 0);
        $this->pdf->Cell(40, 8, 'Prime Nette', 0, 0);
        $this->pdf->Cell(0, 8, 'Prime Brute', 0, 1);
        
        $this->pdf->SetFont('Arial', '', 9);
        $this->pdf->Cell(35, 8, $this->data['Plaque'], 0, 0);
        $this->pdf->Cell(70, 8, $this->data['Garantie'], 0, 0);
        $this->pdf->Cell(40, 8, $this->formatNumber($this->data['PN']), 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['PB']), 0, 1);
       
       // Thick gray line
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        $this->pdf->Cell(55, 8, 'PRIME NET HORS TAXE ET FRAIS:', 0, 0);
        $this->pdf->Cell(30, 8, $this->formatNumber($this->data['PN']), 0, 1);
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
         // row 1.0
        $this->pdf->Cell(35, 8, 'Prime nette.:', 0, 0);
        $this->pdf->Cell(30, 8, $this->formatNumber($this->data['PN']), 0, 0);
        $this->pdf->Cell(30, 8, 'Frais admin.:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['FRAIS']), 0, 1);
        
        // row 1.0
        $this->pdf->Cell(35, 8, 'Autres frais (CD):', 0, 0);
        $this->pdf->Cell(30, 8, $this->formatNumber($this->data['CD']), 0, 0);
        $this->pdf->Cell(30, 8, 'TVA:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['TVA']), 0, 1);
        
        $this->pdf->Cell(35, 8, 'Rabbais:', 0, 0);
        $this->pdf->Cell(30, 8, '0', 0, 0);
        $this->pdf->Cell(45, 8, 'Modalite de Paiement:', 0, 0);
        $this->pdf->Cell(30, 8, $this->data['mode_payment'], 0, 1);
        //$this->pdf->Cell(30, 8, 'TVA:', 0, 0);
        //$this->pdf->Cell(0, 8, $this->formatNumber($this->data['TVA']), 0, 1);
        
       /* $this->pdf->Cell(35, 8, 'Remise:', 0, 0);
        $this->pdf->Cell(30, 8, '0', 0, 0);
        $this->pdf->Cell(30, 8, 'Prime totale TVAC:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['PB']), 0, 1);
        */
        //$this->pdf->Ln(5);
    }

    private function addSignatures() {
        
          // Thick gray line
       // $this->addHorizontalLine(0.5, array(150, 150, 150));
       // $this->pdf->Cell(45, 8, 'Modalite de Paiement:', 0, 0);
      //  $this->pdf->Cell(30, 8, $this->data['mode_payment'], 0, 1);
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        
        $this->pdf->SetFont('Arial', 'B', 8);
        $this->pdf->Cell(12, 8, 'N.B.*:', 0, 0);
        $this->pdf->Cell(0, 8, 'La presente police d\'assurance prend effet dans un delai de 6 heures. A defaut, elle entre en vigueur a 00h00 le jour suivant. ', 0, 1);
       // $this->pdf->SetFont('Arial', 'B', 10);
      //  $this->pdf->Cell(35, 8, 'La presence police d\'assurance prend effet endeans 6h00. A defaut, 00h00:00 ', 0, 1);
      //  $this->pdf->Cell(0, 8, $this->formatNumber($this->data['PB']), 0, 1);
      
        $this->addHorizontalLine(0.5, array(150, 150, 150));
        $this->pdf->SetFont('Arial', '', 8);
        $this->pdf->MultiCell(0, 8, 'Le preneur d\'assurance ou l\'assure declare avoir pris connaissance des conditions generales et particulieres, qui avec la proposition d\'assurance font partie integrante de la police d\'assurance.Sont nulles, toutes les adjonctions ou modifications non revetues du visa de la Direction de la compagnie ou du representant autorise par la compagnie d\'assurances.', 0, 1);
        
        //$this->pdf->MultiCell(0, 8, 'Sont nulles, toutes les adjonctions ou modifications non revetues du visa de la Direction de la compagnie ou du representant autorise par la compagnie d\'assurances.', 0, 1);
        //$this->pdf->Ln(3);
        
        $this->pdf->Cell(0, 8, 'Fait a Bujumbura, en deux exemplaires, le ' . $this->formatDate($this->data['DateEmission']), 0, 1, 'C');
        $this->pdf->Ln(1);
        
        $this->pdf->Cell(95, 8, 'LE PRENEUR', 0, 0, 'C');
        $this->pdf->Cell(95, 8, 'POUR LA COMPAGNIE D\'ASSURANCE', 0, 1, 'C');
        
        $this->pdf->Cell(95, 8, $this->data['Proprietaire'], 0, 0, 'C');
        $this->pdf->Cell(95, 8, $this->data['Creator'], 0, 1, 'C');
        
        
        $this->pdf->Ln(1);
        
    }

    private function addPaymentDetails() {
        
       /* 
        $this->pdf->SetFont('Arial', 'B', 10);
        $this->pdf->Cell(0, 8, 'PRIME NET HORS TAXE ET FRAIS', 0, 1);
        $this->pdf->SetFont('Arial', '', 9);
        
        $this->pdf->Cell(50, 8, 'Frais factures:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['FRAIS']), 0, 1);
        
        //$this->formatNumber($this->data['autres_frais'])
        $this->pdf->Cell(50, 8, 'Autres frais:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        //$this->formatNumber($this->data['rabbais'])
        $this->pdf->Cell(50, 8, 'Rabbais:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        //$this->formatNumber($this->data['remise'])
        $this->pdf->Cell(50, 8, 'Remise:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        $this->pdf->Cell(50, 8, 'Prime Nette:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['PN']), 0, 1);
        
        //$this->formatNumber($this->data['frais_factures'] + $this->data['autres_frais'])
        $this->pdf->Cell(50, 8, 'Frais:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        $this->pdf->Cell(50, 8, 'TVA:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['TVA']), 0, 1);
        
        $this->pdf->Cell(50, 8, 'Prime totale TVAC:', 0, 0);
        $this->pdf->Cell(0, 8, $this->formatNumber($this->data['PB']), 0, 1);
        
        // $this->data['modalite_paiement']
        $this->pdf->Cell(50, 8, 'Modalite de Paiement:', 0, 0);
        $this->pdf->Cell(0, 8, 'N/A', 0, 1);
        
        $this->pdf->Cell(0, 8, date('d/m/Y H:i:s'), 0, 1, 'R');*/
    }

    private function addFooter() {
        /*$this->pdf->SetY(-40);
        $this->pdf->SetFont('Arial', 'B', 8);
        $this->pdf->Cell(0, 8, 'African Gateway Insurance Company', 0, 1, 'C');
        $this->pdf->Cell(0, 8, 'Pensez Grand, Choisissez AGICO', 0, 1, 'C');
        $this->pdf->SetFont('Arial', '', 7);
        $this->pdf->Cell(0, 5, 'Regie par la loi n째1/06 du 17/7/2020', 0, 1, 'C');*/
    }

    private function formatDate($dateString) {
        return date('d/m/Y', strtotime($dateString));
    }

    private function formatNumber($number) {
        return number_format($number, 2, ',', ' ');
    }
    
    private function addHorizontalLine($width = 0.2, $color = array(0, 0, 0), $padding = 5) {
    $this->pdf->SetDrawColor($color[0], $color[1], $color[2]);
    $this->pdf->SetLineWidth($width);
    $y = $this->pdf->GetY();
    $this->pdf->Line(10, $y + ($padding/2), 200, $y + ($padding/2));
    $this->pdf->Ln($padding);
    }

}

// Usage example:
// $data = getInsuranceDataFromDatabase($id); // Implement this function
// $pdfGenerator = new InsurancePDFGenerator($data);
// $pdfContent = $pdfGenerator->generate();
// header('Content-Type: application/pdf');
// echo $pdfContent;
?>