<?php
require_once('../fpdfLib/fpdf.php');

class InsurancePDFGeneratorAccBillv2 {
    private $pdf;
    private $data;
    private $headerImage = 'ressources/img/header1s.png';

    public function __construct($data) {
        $this->data = $data;
        $this->pdf = new FPDF('P', 'mm', 'A5');
        $this->pdf->SetMargins(10, 10, 10);
        $this->pdf->SetFont('Arial', '', 10);
    }

    public function generate() {
        $this->pdf->AddPage();
        $this->drawReceipt(10);   // First receipt at top
        $this->drawReceipt(105);  // Second receipt lower (duplicate)
        return $this->pdf->Output('S');
    }

    /** DRAW ONE RECEIPT BLOCK AT SPECIFIED Y POSITION **/
    private function drawReceipt($startY) {
        $this->pdf->SetY($startY);

        // Header image
        if (file_exists($this->headerImage)) {
            $this->pdf->Image($this->headerImage, 10, $this->pdf->GetY(), 120);
            $this->pdf->Ln(25);
        } else {
            $this->pdf->Ln(15);
        }

        // Title
        $this->pdf->SetFont('Arial', 'B', 11);
        $this->pdf->Cell(0, 8, 'RECU DE PAIEMENT', 0, 1, 'C');
        $this->addHorizontalLine(0.5, [150, 150, 150]);
        $this->pdf->Ln(3);

        // Policy Info
        $this->pdf->SetFont('Arial', '', 9);
        $this->addRow('Nom preneur:', $this->data['Proprietaire'], 'Date facturation:', $this->formatDate($this->data['Date_emission']));
        $this->addRow('Compte preneur:', $this->data['agence_account'], 'Date paiement:', $this->formatDate($this->data['payment_date']));
        $this->addRow('Numero de Police:', $this->data['Numpol'], 'Montant Paye:', $this->data['PB']);
        $this->addRow('Numero de Facture:', $this->data['Facture'], 'Mode paiement:', $this->data['mode_payment']);
        $this->addRow('Motif:', 'Assurance | ' . $this->data['Numpol'] . ' | ' . $this->data['Facture']);
        $this->addHorizontalLine(0.5, [150, 150, 150]);
        $this->pdf->Ln(2);

        // Footer Block
        $this->pdf->SetFont('Arial', '', 8);
        $this->addRow('Numero de Recu:', $this->data['tx_reference']);
        $this->addRow('Percepteur:', $this->data['cashier_fullname'], 'Signature:', '');
    }

    /** HORIZONTAL LINE **/
    private function addHorizontalLine($width = 0.1, $color = [0, 0, 0], $padding = 1) {
        $this->pdf->SetDrawColor($color[0], $color[1], $color[2]);
        $this->pdf->SetLineWidth($width);
        $y = $this->pdf->GetY();
        $this->pdf->Line(10, $y + ($padding / 2), 140, $y + ($padding / 2));
        $this->pdf->Ln($padding);
    }

    /** HELPER FOR ROWS **/
    private function addRow($label1, $value1, $label2 = '', $value2 = '') {
        $this->pdf->Cell(30, 6, $label1, 0, 0);
        $this->pdf->Cell(50, 6, $value1, 0, 0);
        if ($label2 !== '') {
            $this->pdf->Cell(30, 6, $label2, 0, 0);
            $this->pdf->Cell(0, 6, $value2, 0, 1);
        } else {
            $this->pdf->Cell(0, 6, '', 0, 1);
        }
    }

    /** FORMATTERS **/
    private function formatDate($dateString) {
        return !empty($dateString) ? date('d/m/Y', strtotime($dateString)) : '';
    }
    private function formatNumber($number) {
        return number_format($number, 2, ',', ' ');
    }
}
