<?php
require_once('../fpdfLib/fpdf.php');

class InsuranceCardPDFv3 extends FPDF {
    private $cardData;

    public function __construct($cardData) {
        parent::__construct('P', 'mm', 'A4'); // Portrait
        $this->cardData = $cardData;
    }

    public function generate() {
        $this->AddPage();
        $this->SetFont('Arial', '', 10);

        // Top card
        $this->renderCard(10, 20, $this->cardData);

        // Bottom card (duplicate)
        $this->renderCard(10, 130, $this->cardData);

        ob_start();
        $this->Output('S');
        return ob_get_clean();
    }

    private function renderCard($xStart, $yStart, $data) {
        $lineHeight = 7.2;
        $y = $yStart;

        // Helper
        $set = function($dx, $text) use ($xStart, &$y) {
            $this->SetXY($xStart + $dx, $y);
            $this->Cell(0, 6, $text, 0, 1);
        };

        // Card Content
        //$set(28, $data['company_name']);  $y += $lineHeight;
        $set(28, htmlspecialchars($data['company_name']));  $y += $lineHeight;

        // Dates
        // Dates
        $this->SetXY($xStart + 28, $y);
        $this->Cell(30, 6, $data['DateEffet'], 0, 0);
        $this->SetXY($xStart + 65, $y);
        $this->Cell(30, 6, $data['DateEcheance'], 0, 1);
        $y += $lineHeight;
       

        // Times
        // Times
        $this->SetXY($xStart + 28, $y);
        $this->Cell(30, 6, $data['timeCreation'], 0, 0);
        $this->SetXY($xStart + 65, $y);
        $this->Cell(30, 6, $data['expiry_time'], 0, 1);
        $y += $lineHeight;
        /*$this->SetXY($xStart + 28, $y);
        $this->Cell(30, 6, $data['timeCreation'], 0, 0);
        $this->SetXY($xStart + 65, $y);
        $this->Cell(30, 6, '23:59:59', 0, 1);
        $y += $lineHeight;*/

        // Name
        //$set(28, $data['Proprietaire']);  $y += $lineHeight;
        // Owner
        $set(28, htmlspecialchars($data['Proprietaire'])); $y += $lineHeight;

        // Province
        //$set(28, strtoupper($data['province'])); $y += $lineHeight;
        // Province
        $set(28, strtoupper($data['province'])); $y += $lineHeight;

        // Police
        //$set(28, strtoupper($data['Numpol'])); $y += $lineHeight;
        // Policy
        $set(28, strtoupper($data['Numpol'])); $y += $lineHeight;

        // Brand and model
        /*$this->SetXY($xStart + 28, $y);
        $this->Cell(30, 6, strtoupper($data['ClassMarkModel']), 0, 0);
        $this->SetXY($xStart + 58, $y);
        $this->Cell(30, 6, strtoupper($data['ClassMarkModel']), 0, 1);
        $y += $lineHeight;*/
        
        // Brand & model
        $set(28, strtoupper($data['ClassMarkModel']));
        $y += $lineHeight;
        
        
        // Plate
        $set(28, strtoupper($data['Plaque'])); $y += $lineHeight;

        // VIN
        
        // Chassis
        $set(28, strtoupper($data['NumChasis'])); $y += $lineHeight;

        // Affiliation UsageAuto
       
        // Usage
        $set(28, strtoupper($data['UsageAuto'])); $y += $lineHeight;

        // Bottom numeric values
        $this->SetXY($xStart + 28, $y);
        $this->Cell(20, 6, isset($data['PaleSeatCabine']) ? $data['PaleSeatCabine'] : '4', 0, 0);
        $this->SetXY($xStart + 50, $y);
        $this->Cell(20, 6, isset($data['SeatPlacePlato']) ? $data['SeatPlacePlato'] : '0', 0, 1);
    }
}
?>
